/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.io;

import com.adobe.internal.io.ByteWriter;
import java.io.IOException;

public interface ByteWriterFactory {
    public ByteWriter getByteWriter(Longevity var1, EncryptionStatus var2, Fixed var3, long var4, boolean var6) throws IOException;

    public ByteWriter[] getByteWriter(Longevity var1, EncryptionStatus var2, Fixed var3, long[] var4, boolean var5) throws IOException;

    public void closeByteWriter(ByteWriter var1) throws IOException;

    public void closeFactory() throws IOException;

    public static class EncryptionStatus {
        private final int id;
        private final String name;
        public static final EncryptionStatus CLEAR = new EncryptionStatus(0, "CLEAR");
        public static final EncryptionStatus ENCRYPTED = new EncryptionStatus(1, "ENCRYPTED");
        public static final EncryptionStatus DECRYPTED = new EncryptionStatus(1, "DECRYPTED");
        private static final EncryptionStatus[] allValues = new EncryptionStatus[]{CLEAR, ENCRYPTED, DECRYPTED};

        private EncryptionStatus(int id, String name) {
            this.id = id;
            this.name = name.intern();
        }

        public String name() {
            return this.name;
        }

        public static EncryptionStatus parse(String s) {
            for (int i = 0; i < allValues.length; ++i) {
                if (EncryptionStatus.allValues[i].name.compareToIgnoreCase(s) != 0) continue;
                return allValues[i];
            }
            return null;
        }

        public int getId() {
            return this.id;
        }
    }

    public static class Fixed {
        private final int id;
        private final String name;
        public static final Fixed FIXED = new Fixed(0, "FIXED");
        public static final Fixed GROWABLE = new Fixed(1, "GROWABLE");
        private static final Fixed[] allValues = new Fixed[]{FIXED, GROWABLE};

        private Fixed(int id, String name) {
            this.id = id;
            this.name = name.intern();
        }

        public String name() {
            return this.name;
        }

        public static Fixed parse(String s) {
            for (int i = 0; i < allValues.length; ++i) {
                if (Fixed.allValues[i].name.compareToIgnoreCase(s) != 0) continue;
                return allValues[i];
            }
            return null;
        }

        public int getId() {
            return this.id;
        }
    }

    public static class Longevity {
        private final int id;
        private final String name;
        public static final Longevity TEMPORARY = new Longevity(0, "TEMPORARY");
        public static final Longevity SHORT = new Longevity(1, "SHORT");
        public static final Longevity LONG = new Longevity(2, "LONG");
        public static final Longevity PERMANENT = new Longevity(3, "PERMANENT");
        private static final Longevity[] allValues = new Longevity[]{TEMPORARY, SHORT, LONG, PERMANENT};

        private Longevity(int id1, String name) {
            this.id = id1;
            this.name = name.intern();
        }

        public String name() {
            return this.name;
        }

        public static Longevity parse(String s) {
            for (int i = 0; i < allValues.length; ++i) {
                if (Longevity.allValues[i].name.compareToIgnoreCase(s) != 0) continue;
                return allValues[i];
            }
            return null;
        }

        public int getId() {
            return this.id;
        }
    }
}

