/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.agl.charset;

import com.adobe.agl.charset.CharsetICU;
import com.adobe.agl.converters.NativeConverter;
import java.nio.charset.Charset;
import java.nio.charset.spi.CharsetProvider;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

public final class CharsetProviderICU
extends CharsetProvider {
    public final Charset charsetForName(String charsetName) {
        String canonicalName = NativeConverter.getCanonicalName(charsetName);
        if (canonicalName == null) {
            return null;
        }
        String[] aliases = NativeConverter.getAliases(charsetName);
        return new CharsetICU(canonicalName, aliases);
    }

    public final void putCharsets(Map map) {
        String[] charsets = NativeConverter.getAvailable();
        for (int i = 0; i < charsets.length; ++i) {
            String[] aliases = NativeConverter.getAliases(charsets[i]);
            if (map.containsKey(charsets[i])) continue;
            map.put(charsets[i], aliases);
        }
    }

    public final Iterator charsets() {
        String[] charsets = NativeConverter.getAvailable();
        CharsetIterator iter = new CharsetIterator(charsets);
        return iter;
    }

    protected final class CharsetIterator
    implements Iterator {
        private String[] names;
        private int currentIndex;

        protected CharsetIterator(String[] strs) {
            this.names = strs;
            this.currentIndex = 0;
        }

        public boolean hasNext() {
            return this.currentIndex < this.names.length;
        }

        public Object next() {
            if (this.currentIndex < this.names.length) {
                return CharsetProviderICU.this.charsetForName(this.names[this.currentIndex++]);
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            if (this.currentIndex == 0) {
                throw new IllegalStateException();
            }
            this.names = null;
            this.currentIndex = 0;
        }
    }
}

