/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.agl.text;

import com.adobe.agl.impl.UCharacterProperty;
import com.adobe.agl.text.Replaceable;
import com.adobe.agl.text.Transliterator;
import com.adobe.agl.text.UCharacterIterator;
import com.adobe.agl.text.UTF16;
import com.adobe.agl.text.UnicodeSet;
import com.adobe.agl.util.ULocale;

class TitlecaseTransliterator
extends Transliterator {
    static final String _ID = "Any-Title";
    private ULocale loc;
    static UnicodeSet SKIP = null;
    static UnicodeSet CASED = null;
    private char[] buffer = new char[10];
    private static final UCharacterProperty m_charppty_ = UCharacterProperty.getInstance();

    private static final void initStatics() {
        SKIP = new UnicodeSet("[\u00ad \u2019 \\' [:Mn:] [:Me:] [:Cf:] [:Lm:] [:Sk:]]");
        CASED = new UnicodeSet("[[:Lu:] [:Ll:] [:Lt:]]");
    }

    static void register() {
        Transliterator.registerFactory(_ID, new Transliterator.Factory(){

            public Transliterator getInstance(String ID) {
                return new TitlecaseTransliterator(ULocale.US);
            }
        });
        TitlecaseTransliterator.registerSpecialInverse("Title", "Lower", false);
    }

    public TitlecaseTransliterator(ULocale loc) {
        super(_ID, null);
        this.loc = loc;
        this.setMaximumContextLength(2);
    }

    protected void handleTransliterate(Replaceable text, Transliterator.Position offsets, boolean incremental) {
        int textPos;
        int c;
        if (SKIP == null) {
            TitlecaseTransliterator.initStatics();
        }
        boolean doTitle = true;
        for (int start = offsets.start - 1; start >= offsets.contextStart; start -= UTF16.getCharCount(c)) {
            c = text.char32At(start);
            if (SKIP.contains(c)) continue;
            doTitle = !CASED.contains(c);
            break;
        }
        if ((textPos = offsets.start) >= offsets.limit) {
            return;
        }
        UCharacterIterator original = UCharacterIterator.getInstance(text);
        int limit = offsets.limit;
        while (textPos < limit) {
            original.setIndex(textPos);
            int cp = original.currentCodePoint();
            int oldLen = UTF16.getCharCount(cp);
            if (!SKIP.contains(cp)) {
                int newLen = doTitle ? m_charppty_.toUpperOrTitleCase(this.loc, cp, original, false, this.buffer) : m_charppty_.toLowerCase(this.loc, cp, original, this.buffer);
                boolean bl = doTitle = !CASED.contains(cp);
                if (newLen >= 0) {
                    text.replace(textPos, textPos + oldLen, this.buffer, 0, newLen);
                    if (newLen != oldLen) {
                        textPos += newLen;
                        offsets.limit += newLen - oldLen;
                        offsets.contextLimit += newLen - oldLen;
                        continue;
                    }
                }
            }
            textPos += oldLen;
        }
        offsets.start = offsets.limit;
    }
}

