/* Copyright 2008 we-lab-doc! (http://www.we-lab-doc.com/)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.we_lab_doc.spacecard.model

import com.we_lab_doc.spacecard.model.abstracts.*
import com.we_lab_doc.spacecard.utils.*

/**
 * @author Shigeru GOUGI
 * @since 0.1
 *        <p/>
 *        Created: March 24, 2008
 */ 
final class WorkCardAttachedFile extends AttachedFile {
	 boolean remove() {
		 this.workCard?.removeFromAttachedFiles(this);
		 return super.remove() 
	 }
	 ////////////////////////////////////////////
	 static WorkCardAttachedFile create(def params, String fileName, InputStream inputStream) {
		 params.fileName = fileName
		 return create(params, inputStream)
	 }
	 static WorkCardAttachedFile create(def params, String fileName, InputStream inputStream, String description) {
		 assert StringUtils.isNotBlank(fileName)
		 params.fileName = fileName
		 params.description = description
		 return create(params, inputStream)
	 }
	 static WorkCardAttachedFile create(def params, InputStream inputStream) {
		 assert params != null && StringUtils.isNotBlank(params.fileName)
		 if(!params.creator) {
			 def acs = SpaceCardModel.accessControlService
			 assert acs != null
			 params.creator = acs.getLoggedInUser()
		 }
		 def attachedFile = new WorkCardAttachedFile(params)
		 attachedFile.fileName = params.fileName
		 attachedFile.contentType = attachedFile.makeContentType(params.fileName)		 
		 attachedFile.attachedFileManager.upload(attachedFile, inputStream)
		 return attachedFile
	 }
	 ////////////////////////////////////////////
	 static belongsTo   = [workCard:WorkCard]
	 static constraints = {
		 workCard(nullable:false)	
	 }
	 ////////////////////////////////////////////
}
