/* Copyright 2008 we-lab-doc! (http://www.we-lab-doc.com/)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.we_lab_doc.spacecard.plugin.utils

import org.codehaus.groovy.grails.commons.GrailsClass

/**
 * @author Shigeru GOUGI
 * @since 0.1
 *        <p/>
 *        Created: March 5, 2008
 * 
 * memo: mapping で auto-import=true が設定できるようになれば削除。
 */
final class DomainClassNameConverter {
	private nameMap = [:]
	public DomainClassNameConverter(GrailsClass[] domainClasses) {
		domainClasses?.each { clazz ->
			nameMap.put(clazz.shortName, clazz.fullName)
		}
	}
	public Object convert(Object example) {
		assert example != null
		example = example.replaceAll(',', ' , ')
		def tokens = example.toString().tokenize(' ')
		def strbuf = new StringBuffer()
		tokens.each {
			def cnv = nameMap.get(it)
			strbuf.append(cnv ? cnv : it)
			strbuf.append(' ')
		}
		return strbuf.toString()
	}
}