/* Copyright 2008 we-lab-doc! (http://www.we-lab-doc.com/)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.we_lab_doc.spacecard.bean;

import org.codehaus.groovy.grails.commons.AbstractInjectableGrailsClass;
import org.codehaus.groovy.grails.commons.GrailsClassUtils;
import com.we_lab_doc.spacecard.bean.annotation.SpaceCardBean;
import com.we_lab_doc.spacecard.bean.annotation.SpaceCardCustomBean;

/**
 * @author Shigeru GOUGI
 * @since 0.1
 *        <p/>
 *        Created: March 7, 2008
 *        
 */
public class DefaultSpaceCardBeanClass extends AbstractInjectableGrailsClass
	implements SpaceCardBeanClass {
	public static final String BEAN = "SpaceCardBean";
	private String name  = null;
	private String scope = null;
	
	public DefaultSpaceCardBeanClass(Class clazz) {
		super(clazz, BEAN);
		initializeNameAndScope();
	}
	
	public String getPropertyName() {
		return this.name;
	}
	public String getScope() {
		return this.scope;
	}
	///////////////////////////////////////////////////////////////////////////////////
	private void initializeNameAndScope() {
		SpaceCardBean anno = BeanHelper.getSpaceCardBeanAnnotation(this.getClazz());
		if(anno!=null){
			if(anno.name().length() > 0)
				this.name = anno.name();
			if(anno.scope().length() > 0)
				this.scope = anno.scope();
		} else {
			SpaceCardCustomBean canno = BeanHelper.getSpaceCardCustomBeanAnnotation(this.getClazz());
			if(canno != null ){
				String name = BeanHelper.getCustomBeanName(this.getClazz());
				assert name != null; 
				this.name = name;
				if(canno.scope().length() > 0) {
					this.scope = canno.scope();
				}
			}
		}
		if(this.name == null || this.name.length() == 0)
			this.name =  GrailsClassUtils.getPropertyNameRepresentation(getShortName());
		assert this.name.length() > 0;
		if(this.scope == null || this.scope.length() == 0) {
			this.scope = (String)this.getPropertyValue("scope");
			if(this.scope == null || this.scope.length() == 0) {
				this.scope = "singleton";
			}
		}
		assert this.scope.length() > 0;		
	}
	
}
