import com.we_lab_doc.spacecard.model.*
import com.we_lab_doc.spacecard.utils.*

class RelatedWorkTests extends SpaceCardModelTestCase {
	def spaceCardService
	def organizationService
	
    void testCreateDelete() {
		def sv = User.getActiveUserByAccount(spaceCardModelProperties.supervisorAccount)
		assertNotNull sv
		def svc = Organization.getSupervisorCommunity()
		assertNotNull svc
		def p1 = Project.create(
				[
				 title:"hoge1",
				 creator:sv
				]
				,svc)
		assertTrue ModelUtils.flush(p1)
		
		def r1 = RelatedWork.create(
				[
				 description:"hoge",
				 creator:sv
				 ]
				 )
		p1.add(r1)
		assertNotNull "1", r1
		assertTrue "2", ModelUtils.flush(r1)
		assertEquals "4", r1.description,  "hoge"
		assertNotNull "5", r1.createdDate
		assertNull    "6", r1.updatedDate
		println "delete:"
		assertTrue "7", r1.remove()
    }
}
