/*-- Copyright 2008 we-lab-doc! (http://www.we-lab-doc.com/)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package scripts
{
	import mx.rpc.remoting.RemoteObject;
	
	public final class RemotingManager
	{
		import mx.messaging.ChannelSet;
		import mx.messaging.Channel;
		import mx.messaging.channels.AMFChannel;
		private static var portNumber:String = "8080";
		private static var serverName:String = "localhost";
		private static var protocol:String = "http";
		private static var channelSet:ChannelSet = new ChannelSet();
		private static var spaceCardAfmChannel:AMFChannel = null;
		private static const SPACECARD_AMF_ID:String = "SpaceCard-amf";
		/////
		private static function getEndpoint():String {
			return protocol +  "://" + serverName + ":" + portNumber + "/SpaceCard/messagebroker/amf";
		}
		public static function setPortNumber(aPortNumber:String):void {
			portNumber = aPortNumber
		}
		public static function getPortNumber() : String {
			return portNumber;
		}		
		public static function setServerName(aServerName:String): void {
			serverName = aServerName; 
		}
		public static function getServerName() : String {
			return serverName;
		}
		public  static function setProtocol(aProtocol:String): void {
			protocol = aProtocol;
		}
		public static function getProtocol() : String {
			return protocol;
		}
		/////////////////
		public static function getChannelSet() : ChannelSet {
			return channelSet;
		}
		public static function getSpaceCardAmfChannel() : Channel {
			for ( var i:int = 0; i < channelSet.channels.length; i++ ) {
				var ch:Channel = channelSet[i];
				if ( ch.id == SPACECARD_AMF_ID) {
					return ch;
				}
			} 
			return null;
		}
		public static function setupSpaceCardAmfChannel(protocol:String = "http", serverName:String = "localhost", portNumber:String = "8080") : ChannelSet {
			setServerName(serverName);
			setPortNumber(portNumber);
			setProtocol(protocol);
			var cs:ChannelSet = RemotingManager.getChannelSet();
			if(cs == null) {
           		cs = new ChannelSet();
   			}
   			if(spaceCardAfmChannel != null) {
   				cs.removeChannel(spaceCardAfmChannel);
   			}
           	spaceCardAfmChannel = new AMFChannel(SPACECARD_AMF_ID, RemotingManager.getEndpoint());
           	cs.addChannel(spaceCardAfmChannel);
           	return channelSet;			
		}
		public static function createSuperviseService():RemoteObject {
           	var ro:RemoteObject = new RemoteObject();
			ro.destination = "flexSuperviseService"
			ro.channelSet = channelSet;			
			return ro;			
		}
		public static function createAccessControlService():RemoteObject {
           	var ro:RemoteObject = new RemoteObject();
			ro.destination = "flexAccessControlService"
			ro.channelSet = channelSet;			
			return ro;
		}
		public static function createUserService():RemoteObject {
           	var ro:RemoteObject = new RemoteObject();
			ro.destination = "flexUserService"
			ro.channelSet = channelSet;			
			return ro;
		}
		public static function createPrivateWorkspaceService():RemoteObject {
           	var ro:RemoteObject = new RemoteObject();
			ro.destination = "flexPrivateWorkspaceService"
			ro.channelSet = channelSet;			
			return ro;
		}
	}
}