import com.we_lab_doc.spacecard.controller.AbstractACController
import com.we_lab_doc.spacecard.model.*
import com.we_lab_doc.spacecard.utils.*

class SimpleCardController extends AbstractACController {
    
	def authorize() {
		if (accessControlService.isLogin()) {
			return true
		}
		super.unauthorizedAction()
		return false
	}
	
    def index = { redirect(action:list,params:params) }

    // the delete, save and update actions only accept POST requests
    def allowedMethods = [delete:'POST', save:'POST', update:'POST']

    def list = {
   		def user = accessControlService.loginUser
   		def cardHolder = user.getCardHolder('simpleCard')
   		if(! cardHolder) {
   			cardHolder = user.createCardHolder('simpleCard')
   			cardHolder.save()
   		}
   		def cards = cardHolder.cards? cardHolder.cards : [] 
        [ simpleCardList: cards ]
    }

    def show = {
        def simpleCard = SimpleCard.get( params.id )

        if(!simpleCard) {
            flash.message = "SimpleCard not found with id ${params.id}"
            redirect(action:list)
        }
        else { return [ simpleCard : simpleCard ] }
    }

    def delete = {
        def simpleCard = SimpleCard.get( params.id )
        if(simpleCard) {
            simpleCard.delete()
            flash.message = "SimpleCard ${params.id} deleted"
            redirect(action:list)
        }
        else {
            flash.message = "SimpleCard not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def edit = {
        def simpleCard = SimpleCard.get( params.id )

        if(!simpleCard) {
            flash.message = "SimpleCard not found with id ${params.id}"
            redirect(action:list)
        }
        else {
            return [ simpleCard : simpleCard ]
        }
    }

    def update = {
        def simpleCard = SimpleCard.get( params.id )
        if(simpleCard) {
            simpleCard.properties = params
            if(!simpleCard.hasErrors() && simpleCard.save()) {
                flash.message = "SimpleCard ${params.id} updated"
                redirect(action:show,id:simpleCard.id)
            }
            else {
                render(view:'edit',model:[simpleCard:simpleCard])
            }
        }
        else {
            flash.message = "SimpleCard not found with id ${params.id}"
            redirect(action:edit,id:params.id)
        }
    }

    def create = {
        def simpleCard = new SimpleCard()
        simpleCard.properties = params
        return ['simpleCard':simpleCard]
    }

    def save = {
   		def user = accessControlService.loginUser
   		def cardHolder = user.getCardHolder('simpleCard')
   		if(! cardHolder) {
   			cardHolder = user.createCardHolder('simpleCard')
   			cardHolder.save()
   		}
        def simpleCard = new SimpleCard(params)
        cardHolder.addToCards(simpleCard)
        if(!simpleCard.hasErrors() && simpleCard.save()) {
            flash.message = "SimpleCard ${simpleCard.id} created"
            redirect(action:show,id:simpleCard.id)
        }
        else {
            render(view:'create',model:[simpleCard:simpleCard])
        }
    }
}