﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Text.RegularExpressions;

namespace SpeechCast
{
    public partial class FormSettings : Form
    {
        public FormSettings()
        {
            InitializeComponent();

            System.Drawing.Text.InstalledFontCollection ifc =
                 new System.Drawing.Text.InstalledFontCollection();

            FontFamily[] ffs = ifc.Families;
            int i = 0;
            int index = 0;
            foreach (FontFamily ff in ffs)
            {
                ComboBoxFontName.Items.Add(ff.Name);
                if (ff.Name == "MS UI Gothic")
                {
                    index = i;
                }
                i++;
            }

            ComboBoxFontName.SelectedIndex = index;
        }

        public static string StringsToText(IEnumerable<string> strings)
        {
            StringBuilder sb = new StringBuilder();

            foreach (string line in strings)
            {
                sb.AppendLine(line);
            }
            return sb.ToString();
        }

        public void SetUserConfig(UserConfig userConfig)
        {
            this.NumericUpDownSpeakingInvervalMillsec.Value = userConfig.SpeakingInvervalMillsec;
            this.TrackBarSpeakingRate.Value = userConfig.SpeakingRate;
            this.TextBoxNGWords.Text = StringsToText(userConfig.NGWords);
            this.TextBoxPronounciations.Text = StringsToText(userConfig.Pronounciations);
            this.checkBoxSpeaksResNumber.Checked = userConfig.SpeaksResNumber;
        }

        private Regex regexAllSpaces = new Regex(@"^\s*$");

        public void GetUserConfig(UserConfig userConfig)
        {
            userConfig.SpeakingInvervalMillsec = System.Convert.ToInt32(this.NumericUpDownSpeakingInvervalMillsec.Value);
            userConfig.SpeakingRate = this.TrackBarSpeakingRate.Value;
            userConfig.MaxSpeakingCharacterCount = System.Convert.ToInt32(this.NumericUpDownMaxSpeakingCharacterCount.Value);
            userConfig.CaptionFont = this.CaptionFont;
            userConfig.AutoGettingWebInvervalMillsec = System.Convert.ToInt32(this.NumericUpDownAutoGettingWebInverval.Value);
            userConfig.SpeaksResNumber = this.checkBoxSpeaksResNumber.Checked;
            userConfig.NGWords.Clear();
            foreach (string ngword in this.TextBoxNGWords.Lines)
            {
                if (!regexAllSpaces.IsMatch(ngword))
                {
                    userConfig.NGWords.Add(ngword);
                }
            }
            userConfig.Pronounciations.Clear();
            foreach (string ngword in this.TextBoxPronounciations.Lines)
            {
                if (!regexAllSpaces.IsMatch(ngword))
                {
                    userConfig.Pronounciations.Add(ngword);
                }
            }
        }
        
        public CaptionFont CaptionFont
        {
            get
            {
                CaptionFont captionFont = new CaptionFont();

                captionFont.Name = ComboBoxFontName.Text;

                try
                {
                    captionFont.Size = System.Convert.ToSingle(ComboBoxFontSize.Text);
                }
                catch //(Exception e)
                {
                }
                captionFont.Bold = CheckBoxFontBold.Checked;
                captionFont.Italic = CheckBoxFontItalic.Checked;
                captionFont.BorderSize = System.Convert.ToInt32(NumericUpDownFontBorderSize.Value);
                return captionFont;
            }

            set
            {
                int idx = ComboBoxFontName.Items.IndexOf(value.Name);

                if (idx >= 0)
                {
                    ComboBoxFontName.SelectedIndex = idx;
                }

                ComboBoxFontSize.Text = value.Size.ToString();

                idx = ComboBoxFontSize.Items.IndexOf(value.Size.ToString());
                if (idx >= 0)
                {
                    ComboBoxFontSize.SelectedIndex = idx;
                }
                CheckBoxFontBold.Checked = value.Bold;
                CheckBoxFontItalic.Checked = value.Italic;
                NumericUpDownFontBorderSize.Value = value.BorderSize;
            }
        }

        private void buttonOK_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.OK;
            Close();
        }

        private void trackBarSpeakingRate_ValueChanged(object sender, EventArgs e)
        {
            labelSpeakingRate.Text = TrackBarSpeakingRate.Value.ToString();
        }

        private void panelPreview_Paint(object sender, PaintEventArgs e)
        {
            Rectangle rect = panelPreview.ClientRectangle;

            rect.Inflate(-10, -10);

            FormCaption.DrawCaption(e.Graphics, rect, "プレビュー 123 ABC", CaptionFont);
        }

        private void ComboBoxFontName_SelectedIndexChanged(object sender, EventArgs e)
        {
            panelPreview.Refresh();
        }
    }
}
