﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Diagnostics;
using System.Linq;
using System.Windows.Forms;

namespace FDK
{
	/// <summary>
	/// アプリケーションフォームの基礎クラス。デバイスリソースを持つ。
	/// </summary>
	public class ApplicationBase
	{
		public System.Windows.Forms.Form Window => ( this.bs_Window );
		public bool 全画面モードである
		{
			get;
			protected set;
		} = false;
		public bool ウィンドウモードである
		{
			get { return !this.全画面モードである; }
			protected set { this.全画面モードである = !value; }
		}

		public ApplicationBase()
		{
			this.bs_Window = new Form();
			this.bs_Window.Load += OnLoad;
			this.bs_Window.FormClosing += OnClosing;
			this.bs_Window.ClientSizeChanged += OnClientSizeChanged;
		}
		public void 全画面モードとウィンドウモードを切り替える()
		{
			this.スレッド排他領域.ReadLock( () => {

				if( false == this.スレッド排他領域.アプリを終了せよ )
				{
					if( this.全画面モードである )
					{
						this.スレッド排他領域.デバイスリソース.SwapChain.SetFullscreenState( false, null );  // ウィンドウモードへ。
						this.ウィンドウモードである = true;
					}
					else
					{
						this.スレッド排他領域.デバイスリソース.SwapChain.SetFullscreenState( true, null );    // 全画面モードへ。
						this.全画面モードである = true;
					}
				}

			} );
		}

		protected SharpDX.Size2F 設計画面サイズdpx = SharpDX.Size2F.Empty;

		/// <summary>
		/// GUIスレッドと進行描画スレッド(Main) とで排他が必要なデータを集めたクラス。
		/// </summary>
		protected class Cスレッド排他領域 : FDK.同期.RWLockAction
		{
			public bool アプリを終了せよ
			{
				get { return this.ReadLock( () => this.bs_アプリを終了せよ ); }
				set { this.WriteLock( () => { this.bs_アプリを終了せよ = value; } ); }
			}
			public FDK.メディア.デバイスリソース デバイスリソース
			{
				get { return this.ReadLock( () => this.bs_デバイスリソース ); }
				set { this.WriteLock( () => { this.bs_デバイスリソース = value; } ); }
			}
			public FDK.同期.TriStateEvent 進行描画スレッド生存中
			{
				get { return this.ReadLock( () => this.bs_進行描画スレッド生存中 ); }
				set { this.WriteLock( () => { this.bs_進行描画スレッド生存中 = value; } ); }
			}

			#region " バックストア。"
			//----------------
			protected bool bs_アプリを終了せよ = false;
			protected FDK.メディア.デバイスリソース bs_デバイスリソース = null;
			protected FDK.同期.TriStateEvent bs_進行描画スレッド生存中 = new 同期.TriStateEvent( 同期.TriStateEvent.状態種別.OFF );
			//----------------
			#endregion
		};
		protected Cスレッド排他領域 スレッド排他領域 = new Cスレッド排他領域();

		protected virtual void 初期化する()
		{
			//----------------
			// 以下は実装例。
			//----------------
			Debug.Assert( null == this.スレッド排他領域.デバイスリソース, "デバイスリソースの作成前であること。" );
			this.設計画面サイズdpx = new SharpDX.Size2F( 640, 480 );   // 例。
		}
		protected virtual void 終了する()
		{
			//----------------
			// 以下は実装例。
			//----------------
			Debug.Assert( null != this.スレッド排他領域.デバイスリソース, "デバイスリソースが解放される前であること。" );
		}
		protected virtual void シーンを描画する()
		{
			//----------------
			// 以下は実装例。
			// なお、このメソッドはGUIスレッドではなく進行描画スレッドから呼び出されるので注意。
			//----------------

			this.スレッド排他領域.WriteLock( () => {

				// ここで、描画を行う。
				// ...


				// ここで、入力を行う。
				// ...

			} );

			// 表示する。垂直帰線待ちなどで時間がかかるのでロックしないこと。
			if( false == this.スレッド排他領域.アプリを終了せよ )
				this.スレッド排他領域.デバイスリソース.SwapChain.Present( 0, SharpDX.DXGI.PresentFlags.None );
		}
		protected virtual void デバイス依存リソースを解放する()
		{
			// デバイスリソースはまだ解放されていない。
		}
		protected virtual void デバイス依存リソースを再構築する()
		{
			// デバイスリソースはまだ再構築されていない。
		}

		#region " バックストア。"
		//----------------
		protected System.Windows.Forms.Form bs_Window = null;
		//----------------
		#endregion

		protected System.Threading.Thread 進行描画スレッド = null;

		private void OnLoad( object sender, EventArgs e )
		{
			FDK.Log.現在のスレッドに名前をつける( "GUI" );
			FDK.Log.BeginInfo( $"{FDK.Utilities.現在のメソッド名}" );

			FDK.Log.BeginInfo( "派生クラスを初期化します。" );
			this.初期化する();
			Debug.Assert( SharpDX.Size2F.Empty != this.設計画面サイズdpx, "初期化メソッド内で設計画面サイズを設定してあること。" );
			FDK.Log.Info( $"設計画面サイズ: {this.設計画面サイズdpx}" );
			FDK.Log.Info( $"物理画面サイズ: {this.Window.ClientSize}" );
			FDK.Log.EndInfo( "派生クラスを初期化しました。" );

			FDK.Log.BeginInfo( "デバイスリソースを作成します。" );
			this.スレッド排他領域.WriteLock( () => {
				this.スレッド排他領域.デバイスリソース = new メディア.デバイスリソース();
				this.スレッド排他領域.デバイスリソース.設計画面サイズdpx = this.設計画面サイズdpx;
				this.スレッド排他領域.デバイスリソース.すべてのリソースを作成する( this.Window.ClientSize, this.Window.Handle );
			} );
			FDK.Log.EndInfo( "デバイスリソースを作成しました。" );

			FDK.Log.BeginInfo( "進行描画スレッドを開始します。" );
			this.進行描画スレッド = new System.Threading.Thread( this.進行描画スレッド処理 ) {
				Name = "進行描画スレッド",
				Priority = System.Threading.ThreadPriority.AboveNormal,	// 優先度: やや高
			};
			this.進行描画スレッド.Start();
			this.スレッド排他領域.進行描画スレッド生存中.ONになるまでブロックする();
			FDK.Log.EndInfo( "進行描画スレッドを開始しました。" );

			FDK.Log.EndInfo( $"{FDK.Utilities.現在のメソッド名}" );
		}
		private void OnClosing( object sender, FormClosingEventArgs e )
		{
			FDK.Log.BeginInfo( $"{FDK.Utilities.現在のメソッド名}" );

			// 終了フラグを立てる。
			this.スレッド排他領域.アプリを終了せよ = true;

			// 派生クラスの終了処理を呼び出す。
			this.終了する();

			// 終了フラグをチェックした進行描画スレッドが終了し、このトライステートに OFF を通知してくるまで待つ。
			this.スレッド排他領域.進行描画スレッド生存中.OFFになるまでブロックする();

			// デバイスリソースを解放する。
			this.スレッド排他領域.デバイスリソース?.Dispose();
			this.スレッド排他領域.デバイスリソース = null;

			FDK.Log.EndInfo( $"{FDK.Utilities.現在のメソッド名}" );
		}
		private void OnClientSizeChanged( object sender, EventArgs e )
		{
			try
			{
				FDK.Log.BeginInfo( $"{FDK.Utilities.現在のメソッド名}" );
				FDK.Log.Info( $"新しいクライアントサイズ = {this.Window.ClientSize}" );

				if( null == this.スレッド排他領域.デバイスリソース )
				{
					FDK.Log.Info( " まだ初期化されてないので、何もしません。" );
					return;
				}
				if( this.Window.WindowState == FormWindowState.Minimized )
				{
					FDK.Log.Info( "最小化されました。" );
					return; // 何もしない
				}

				this.スレッド排他領域.ReadLock( () => {

					var dr = this.スレッド排他領域.ReadLock( () => this.スレッド排他領域.デバイスリソース );
					Debug.Assert( null != dr, "デバイスリソースが作成済みであること。" );

					// 現在の画面モードを取得しておく。（Alt+TABなど、勝手に全画面を解除されることもあるので。）
					SharpDX.Mathematics.Interop.RawBool fullscreen;
					SharpDX.DXGI.Output outputTarget;
					dr.SwapChain.GetFullscreenState( out fullscreen, out outputTarget );
					this.全画面モードである = fullscreen;
					outputTarget?.Dispose();
					FDK.Log.Info( $"現在、全画面モードである = {this.全画面モードである}" );

					// (1) リソースを解放して、
					this.デバイス依存リソースを解放する();
					dr.サイズに依存するリソースを解放する();

					// (2) 物理画面サイズを変更して、
					dr.物理画面サイズpx = new SharpDX.Size2F( this.Window.ClientSize.Width, this.Window.ClientSize.Height );

					// (3) リソースを再構築する。
					dr.サイズに依存するリソースを作成する();
					this.デバイス依存リソースを再構築する();

				} );
			}
			finally
			{
				FDK.Log.EndInfo( $"{FDK.Utilities.現在のメソッド名}" );
			}
		}
		private void 進行描画スレッド処理()
		{
			this.スレッド排他領域.進行描画スレッド生存中.状態 = 同期.TriStateEvent.状態種別.ON;

			FDK.Log.現在のスレッドに名前をつける( "Main" );
			FDK.Log.Info( "進行描画スレッドを起動しました。" );

			while( true )
			{
				// デバイスロストに対応する。
				this.スレッド排他領域.ReadLock( () => {
					bool 異常発生 = false;
					this.スレッド排他領域.デバイスリソース.D3Dデバイスが消失していれば再構築する( out 異常発生 );
					if( 異常発生 )
						this.スレッド排他領域.アプリを終了せよ = true;
				} );

				// フラグがセットされていれば、ループを抜けてスレッドを終了する。
				if( this.スレッド排他領域.アプリを終了せよ )
					break;

				// それ以外なら、シーンを進行・描画する。
				this.シーンを描画する();
			}

			this.スレッド排他領域.進行描画スレッド生存中.状態 = 同期.TriStateEvent.状態種別.OFF;
			FDK.Log.Info( "進行描画スレッドを終了します。" );
		}
	};
}
