﻿using System;
using System.Collections.Generic;

namespace FDK.入力
{
	public class Keyboard : FDK.入力.IInputDevice, IDisposable
	{
		public InputDeviceType 入力デバイス種別 => InputDeviceType.Keyboard;

		public Keyboard( IntPtr hWindow )
		{
			FDK.Log.BeginInfo( $"{FDK.Utilities.現在のメソッド名}" );

			this.Window = hWindow;

			#region " キーの押下状態配列を初期化する。"
			//-----------------
			for( int i = 0; i < 256; i++ )
				this.現在のキーの押下状態[ i ] = false;
			//-----------------
			#endregion

			// DirectInput を生成する。
			var di = new SharpDX.DirectInput.DirectInput();

			#region " キーボードが接続されていないなら、this.Device = null のままとする。"
			//-----------------
			if( 0 == di.GetDevices( SharpDX.DirectInput.DeviceType.Keyboard, SharpDX.DirectInput.DeviceEnumerationFlags.AttachedOnly ).Count )
			{
				this.Device = null; // これは、エラーではない。
				return;
			}
			//-----------------
			#endregion

			// デバイスを生成する。
			this.Device = new SharpDX.DirectInput.Keyboard( di );

			// デバイスの協調モードを設定する。
			this.Device.SetCooperativeLevel(
				this.Window,
				SharpDX.DirectInput.CooperativeLevel.NoWinKey |
				SharpDX.DirectInput.CooperativeLevel.Foreground |
				SharpDX.DirectInput.CooperativeLevel.NonExclusive );

			// デバイスの入力バッファサイズを設定する。
			this.Device.Properties.BufferSize = Keyboard.デバイスの入力バッファサイズ;

			FDK.Log.EndInfo( $"{FDK.Utilities.現在のメソッド名}" );
		}
		public void Dispose()
		{
			FDK.Log.BeginInfo( $"{FDK.Utilities.現在のメソッド名}" );

			FDK.Utilities.解放する( ref this.Device );

			FDK.Log.EndInfo( $"{FDK.Utilities.現在のメソッド名}" );
		}

		public void ポーリングする()
		{
			if( null == this.Device )
				return; // 準正常。

			this.入力イベントリスト.Clear(); // Acquire 前にクリアしておく（Acquire の失敗時にリストが空であるように）。

			#region " Acquire する。失敗（非アクティブ、ウィンドウ終了時など）したら、何もしない。 "
			//-----------------
			try
			{
				this.Device.Acquire();
			}
			catch
			{
				//Log.WARNING( "キーボードデバイスの Acquire に失敗しました。" );
				return;
			}
			//-----------------
			#endregion

			try
			{
				// ポーリングを行う。
				this.Device.Poll();

				// ポーリング結果から状態配列を更新する。
				var timeStamp = FDK.カウンタ.QPCTimer.生カウント;    // なるべく早くに取得しておく。
				foreach( var k in this.Device.GetBufferedData() )
				{
					if( k.IsPressed )
					{
						#region " (a) 押された "
						//-----------------
						this.入力イベントリスト.Add(
							new InputEvent() {
								Key = (int) k.Key,
								Velocity = 255,
								TimeStamp = timeStamp,    // DirectInput の TimeStamp は使わない。
								押された = true,
								離された = false,
							} );

						this.現在のキーの押下状態[ (int) k.Key ] = true;
						//-----------------
						#endregion
					}
					else if( k.IsReleased )
					{
						#region " (b) 離された "
						//-----------------
						this.入力イベントリスト.Add(
							new InputEvent() {
								Key = (int) k.Key,
								Velocity = 255,
								TimeStamp = timeStamp,    // DirectInput の TimeStamp は使わない。
								押された = false,
								離された = true,
							} );

						this.現在のキーの押下状態[ (int) k.Key ] = true;
						//-----------------
						#endregion
					}
				}
			}
			catch( SharpDX.SharpDXException )
			{
				// たまに DIERR_INPUTLOST が発生するが、再度 Acquire すればいいだけなので無視する。
			}
		}

		public bool キーが押された( int key )
		{
			InputEvent dummy;
			return this.キーが押された( key, out dummy );
		}
		public bool キーが押された( int key, out InputEvent ev )
		{
			ev = null;

			if( null == this.Device )
				return false;   // 準正常。

			// 検索 ＆ 戻り値格納。
			ev = this.入力イベントリスト.Find( ( item ) => { return ( item.Key == key ) && ( item.押された ); } );

			// 非 null なら見つかった。
			return ( null != ev ) ? true : false;
		}
		public bool キーが押された( SharpDX.DirectInput.Key key )
		{
			InputEvent dummy;
			return this.キーが押された( (int) key, out dummy );
		}
		public bool キーが押された( SharpDX.DirectInput.Key key, out InputEvent ev )
		{
			return this.キーが押された( (int) key, out ev );
		}

		public bool キーが押されている( int key )
		{
			if( null == this.Device )   // 準正常。
				return false;

			return this.現在のキーの押下状態[ key ];
		}
		public bool キーが押されている( SharpDX.DirectInput.Key key )
		{
			return this.キーが押されている( (int) key );
		}

		public bool キーが離された( int key )
		{
			InputEvent dummy;
			return this.キーが離された( key, out dummy );
		}
		public bool キーが離された( int key, out InputEvent ev )
		{
			ev = null;

			if( null == this.Device )
				return false;   // 準正常。

			// 検索 ＆ 戻り値格納。
			ev = this.入力イベントリスト.Find( ( item ) => { return ( item.Key == key ) && ( item.離された ); } );

			// 非 null なら見つかった。
			return ( null != ev ) ? true : false;
		}
		public bool キーが離された( SharpDX.DirectInput.Key key )
		{
			InputEvent dummy;
			return this.キーが離された( (int) key, out dummy );
		}
		public bool キーが離された( SharpDX.DirectInput.Key key, out InputEvent ev )
		{
			return this.キーが離された( (int) key, out ev );
		}

		public bool キーが離されている( int key )
		{
			if( null == this.Device )   // 準正常。
				return false;

			return !( this.現在のキーの押下状態[ key ] );
		}
		public bool キーが離されている( SharpDX.DirectInput.Key key )
		{
			return this.キーが離されている( (int) key );
		}

		private SharpDX.DirectInput.Keyboard Device = null; // キーボードがアタッチされていない場合は null 。
		private IntPtr Window = IntPtr.Zero;
		private const int デバイスの入力バッファサイズ = 32;

		/// <summary>
		/// ポーリングごとに累積更新された最終の結果。
		/// </summary>
		private readonly bool[] 現在のキーの押下状態 = new bool[ 256 ];

		private readonly List<InputEvent> 入力イベントリスト = new List<InputEvent>();
	}
}
