﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace FDK.同期
{
	/// <summary>
	/// ON, OFF, 無効 の３状態を持つイベント。
	/// </summary>
	/// <remarks>
	/// 状態が 無効 にされると、ON待ち／OFF待ちスレッドのブロックは解除され、また、それ以降状態を変更することはできなくなる。
	/// </remarks>
	public class TriStateEvent
	{
		public enum 状態種別 { ON, OFF, 無効 }
		public 状態種別 状態
		{
			get
			{
				lock( this.排他用 )
				{
					return this.bs_状態;
				}
			}
			set
			{
				lock( this.排他用 )
				{
					switch( this.bs_状態 )
					{
						case 状態種別.ON:
							this.bs_状態 = value;
							this.無効イベント.Reset();
							this.OFFイベント.Reset();
							this.ONイベント.Set();
							break;

						case 状態種別.OFF:
							this.bs_状態 = value;
							this.無効イベント.Reset();
							this.ONイベント.Reset();
							this.OFFイベント.Set();
							break;

						default:    // 無効
							this.bs_状態 = 状態種別.無効;   // 変更不可
							this.ONイベント.Set();
							this.OFFイベント.Set();
							this.無効イベント.Set();
							break;
					}
				}
			}
		}

		public TriStateEvent( 状態種別 初期状態 = 状態種別.OFF )
		{
			this.状態 = 初期状態;
		}

		/// <summary>
		/// 状態が ON または 無効 になるまでブロックする。
		/// </summary>
		/// <returns>解除後の状態（ON または 無効）。</returns>
		public 状態種別 ONになるまでブロックする()
		{
			if( 状態種別.無効 == this.状態 || 状態種別.ON == this.状態 )
				return this.状態;

			// 上の if から 下の WaitOne までの間に ON になった場合に備えて、定期的に状態をチェックする。
			while( false == this.ONイベント.WaitOne( 100 ) )
			{
				if( 状態種別.ON == this.状態 )
					break;
			}
			return this.状態;
		}
		/// <summary>
		/// 状態が OFF または 無効 になるまでブロックする。
		/// </summary>
		/// <returns>解除後の状態（OFF または 無効）。</returns>
		public 状態種別 OFFになるまでブロックする()
		{
			if( 状態種別.無効 == this.状態 || 状態種別.OFF == this.状態 )
				return this.状態;

			// 上の if から 下の WaitOne までの間に OFF になった場合に備えて、定期的に状態をチェックする。
			while( false == this.OFFイベント.WaitOne( 100 ) )
			{
				if( 状態種別.OFF == this.状態 )
					break;
			}
			return this.状態;
		}
		/// <summary>
		/// 状態が 無効 になるまでブロックする。
		/// </summary>
		public void 無効になるまでブロックする()
		{
			if( 状態種別.無効 == this.状態 )
				return;

			// 上の if から 下の WaitOne までの間に無効になった場合に備えて、定期的に状態をチェックする。
			while( false == this.無効イベント.WaitOne( 100 ) )
			{
				if( 状態種別.無効 == this.状態 )
					break;
			}
		}

		protected 状態種別 bs_状態 = 状態種別.OFF;
		protected readonly System.Threading.ManualResetEvent 無効イベント = new System.Threading.ManualResetEvent( false );
		protected readonly System.Threading.ManualResetEvent ONイベント = new System.Threading.ManualResetEvent( false );
		protected readonly System.Threading.ManualResetEvent OFFイベント = new System.Threading.ManualResetEvent( true );
		protected readonly object 排他用 = new object();
	}
}
