﻿using System;
using System.Collections.Generic;
using System.Text;

namespace SSTFEditor.UndoRedo
{
	class 管理
	{
		public static bool UndoRedoした直後である { get; set; } = false;
		public int Redo可能な回数 => ( this.現在の総ノード数 - this.Undo可能な回数 );
		public int Undo可能な回数 => this.ルート.Undo可能な回数;
		public int 現在の総ノード数 => this.ルート.現在の総セル数;

		public 管理()
		{
			this.現在のセル = this.ルート;
		}
		public セルBase Redoするセルを取得して返す()
		{
			this.現在のセル = this.ルート;

			if( 0 >= this.ルート.Redo可能な回数 )
				return null;

			this.ルート.次にセルが追加される位置0to++;
			return this.ルート.セルs[ this.ルート.次にセルが追加される位置0to - 1 ];
		}
		public セルBase Undoするセルを取得して返す()
		{
			this.現在のセル = this.ルート;

			if( 0 >= this.ルート.Undo可能な回数 )
				return null;

			this.ルート.次にセルが追加される位置0to--;
			return this.ルート.セルs[ this.ルート.次にセルが追加される位置0to ];
		}
		public セルBase Undoするセルを取得して返す_見るだけ()
		{
			this.現在のセル = this.ルート;

			if( 0 >= this.ルート.Undo可能な回数 )
				return null;

			return this.ルート.セルs[ this.ルート.次にセルが追加される位置0to - 1 ];
		}
		public void セルを追加する( セルBase 単独セル )
		{
			#region " 追加するセルの後方にあるセルをすべて削除する。"
			//----------------
			int index = this.現在のセル.次にセルが追加される位置0to;
			int count = this.現在のセル.現在の総セル数 - this.現在のセル.次にセルが追加される位置0to;
			if( 0 < count )
				this.現在のセル.セルs.RemoveRange( index, count );
			//----------------
			#endregion

			this.現在のセル.セルs.Add( 単独セル );
			this.現在のセル.次にセルが追加される位置0to++;
		}
		public void トランザクション記録を開始する()
		{
			#region " 追加するセルの後方にあるセルをすべて削除する。"
			//----------------
			int index = this.現在のセル.次にセルが追加される位置0to;
			int count = this.現在のセル.現在の総セル数 - this.現在のセル.次にセルが追加される位置0to;
			if( 0 < count )
				this.現在のセル.セルs.RemoveRange( index, count );
			//----------------
			#endregion

			// リストセルを追加して開く。
			var セルリスト = new セルリスト( this.現在のセル );	// 現在のセルが親セル。
			this.現在のセル.セルs.Add( セルリスト );
			this.現在のセル.次にセルが追加される位置0to++;
			this.現在のセル = セルリスト;
		}
		public void トランザクション記録を終了する()
		{
			// リストセルを閉じる。
			if( null != this.現在のセル.親リスト )
			{
				var list = this.現在のセル;
				this.現在のセル = this.現在のセル.親リスト;
				
				if( 0 == list.セルs.Count )
				{
					this.現在のセル.セルs.Remove( list );
					this.現在のセル.次にセルが追加される位置0to--;
				}
			}
		}
		public void UndoRedoリストをすべて空にする()
		{
			this.ルート = new セルリスト( null );
			this.現在のセル = this.ルート;
		}

		protected セルリスト ルート = new セルリスト( null );
		protected セルリスト 現在のセル;
	}
}
