﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Diagnostics;
using System.Linq;
using System.Windows.Forms;

namespace SST
{
	class StrokeStyleT : FDK.ApplicationBase
	{
		// グローバルリソース (static) 
		public static SST.フォルダ フォルダ => StrokeStyleT.bs_フォルダ;
		public static FDK.入力.Keyboard キーボード入力 => StrokeStyleT.bs_キーボード入力;
		public static FDK.入力.MidiIn MIDI入力 => StrokeStyleT.bs_MIDI入力;
		public static FDK.メディア.サウンド.WASAPI排他.ExclusiveDevice Wasapiデバイス => StrokeStyleT.bs_Wasapiデバイス;
		public static Random 乱数 => StrokeStyleT.bs_乱数;
		public static SST.ユーザ.ユーザ管理 ユーザ管理 => StrokeStyleT.bs_ユーザ管理;
		public static SST.曲.曲ツリー管理 曲ツリー管理 => StrokeStyleT.bs_曲ツリー管理;
		public static SSTFormat.スコア 演奏スコア { get; set; } = null;
		public static SST.設定.Config Config => StrokeStyleT.bs_Config;

		public static void すべての入力デバイスをポーリングする()
		{
			// hack: 追加の入力デバイスができたら、ここにポーリングコードを追加すること。
			StrokeStyleT.キーボード入力?.ポーリングする();
			StrokeStyleT.MIDI入力?.ポーリングする();
		}

		// get only static property の初期化。
		static StrokeStyleT()
		{
			// フォルダ変数を真っ先に登録する。（ほかのメンバのコンストラクタでフォルダ変数を利用できるようにするため。）
			StrokeStyleT.bs_フォルダ = new SST.フォルダ();
			SST.フォルダ.フォルダ変数を追加する( "Static", StrokeStyleT.フォルダ.StaticFolder );
			SST.フォルダ.フォルダ変数を追加する( "AppData", StrokeStyleT.フォルダ.AppDataFolder );
			SST.フォルダ.フォルダ変数を追加する( "User", null );

			// その他の static の生成。
			StrokeStyleT.bs_ユーザ管理 = new ユーザ.ユーザ管理();
			StrokeStyleT.bs_曲ツリー管理 = new 曲.曲ツリー管理();
		}

		protected override void 初期化する()
		{
			FDK.Log.BeginInfo( $"{FDK.Utilities.現在のメソッド名}" );

			Debug.Assert( null == this.スレッド排他領域.デバイスリソース, "デバイスリソースの作成前であること。" );
			
			this.Window.Text = $"StrokeStyle<T> {System.Reflection.Assembly.GetExecutingAssembly().GetName().Version.ToString()}";
			this.設計画面サイズdpx = new SharpDX.Size2F( 1920, 1080 );     // 設計画面サイズdpx

			#region " コンフィグ を初期化する。"
			//----------------
			FDK.Log.Info( "コンフィグを初期化します。" );
			StrokeStyleT.bs_Config = new 設定.Config();
			StrokeStyleT.bs_Config.ConfigXmlを読み込む();
			//----------------
			#endregion

			this.Window.ClientSize = new System.Drawing.Size( StrokeStyleT.Config.物理画面サイズpx.Width, StrokeStyleT.Config.物理画面サイズpx.Height );

			#region " System.Stopwatch が高解像度タイマを使わないならエラー。"
			//-----------------
			if( false == System.Diagnostics.Stopwatch.IsHighResolution )
				throw new SSTException( "このシステムは、高解像度タイマをサポートしていません。" );
			//-----------------
			#endregion
			#region " MediaFoundation を起動する。"
			//-----------------
			SharpDX.MediaFoundation.MediaManager.Startup();
			//-----------------
			#endregion
			#region " Sleep 精度を上げる。"
			//-----------------
			StrokeStyleT.timeBeginPeriod( 1 );
			//-----------------
			#endregion

			#region " ユーザを初期化する。"
			//-----------------
			FDK.Log.Info( "ユーザ情報を初期化します。" );
			StrokeStyleT.ユーザ管理.UsersXmlを読み込む();

			// ユーザ別の初期化。
			foreach( var ユーザ in StrokeStyleT.ユーザ管理.ユーザリスト )
				ユーザ.SourcesXmlを読み込む();
			//-----------------
			#endregion
			#region " WASAPI デバイスを初期化する。"
			//----------------
			StrokeStyleT.bs_Wasapiデバイス = new FDK.メディア.サウンド.WASAPI排他.ExclusiveDevice();
			StrokeStyleT.bs_Wasapiデバイス.初期化する( 15.0f );
			//----------------
			#endregion
			#region " キーボード入力 を初期化する。"
			//-----------------
			FDK.Log.Info( "キーボード入力デバイスを初期化します。" );
			StrokeStyleT.bs_キーボード入力 = new FDK.入力.Keyboard( this.Window.Handle );
			//-----------------
			#endregion
			#region " MIDI入力 を初期化する。"
			//-----------------
			FDK.Log.Info( "MIDI入力デバイスを初期化します。" );
			StrokeStyleT.bs_MIDI入力 = new FDK.入力.MidiIn();
			//-----------------
			#endregion

			this.現在のステージ = this.最初のダミーステージ;

//#warning 全画面モード切替えを KeyDown で仮実装。
			this.Window.KeyDown += ( target, arg ) => {
				// Alt+Enter → 画面モードの切り替え
//				if( ( arg.KeyCode == System.Windows.Forms.Keys.Return ) && ( arg.Modifiers == Keys.Alt ) )
//					this.全画面モードとウィンドウモードを切り替える();
			};

			FDK.Log.EndInfo( $"{FDK.Utilities.現在のメソッド名}" );
		}
		protected override void 終了する()
		{
			FDK.Log.BeginInfo( $"{FDK.Utilities.現在のメソッド名}" );

			Debug.Assert( null != this.スレッド排他領域.デバイスリソース, "デバイスリソースが解放される前であること。" );

			#region " ステージを終了し、解放する。"
			//----------------
			if( ( null != this.現在のステージ ) && ( this.現在のステージ.活性化している ) )
				this.現在のステージ.非活性化する( this.スレッド排他領域.デバイスリソース );

			this.最初のダミーステージ  = null;
			this.起動ステージ = null;
			this.タイトルステージ = null;
			this.ログインステージ = null;
			this.選曲ステージ = null;
			this.曲読込ステージ = null;
			this.演奏ステージ = null;
			this.結果ステージ = null;
			//----------------
			#endregion
			#region " MIDI入力 を解放する。"
			//-----------------
			FDK.Log.Info( "MIDI入力デバイスを解放します。" );
			FDK.Utilities.解放する( ref StrokeStyleT.bs_MIDI入力 );
			//-----------------
			#endregion
			#region " キーボード入力 を解放する。"
			//-----------------
			FDK.Log.Info( "キーボード入力デバイスを解放します。" );
			FDK.Utilities.解放する( ref StrokeStyleT.bs_キーボード入力 );
			//-----------------
			#endregion
			#region " WASAPIデバイスを解放する。"
			//----------------
			FDK.Utilities.解放する( ref StrokeStyleT.bs_Wasapiデバイス );
			//----------------
			#endregion
			#region " コンフィグを解放する。"
			//----------------
			StrokeStyleT.bs_Config = null;
			//----------------
			#endregion
			#region " MediaFoundation を終了する。"
			//-----------------
			SharpDX.MediaFoundation.MediaManager.Shutdown();
			//-----------------
			#endregion

			FDK.Log.EndInfo( $"{FDK.Utilities.現在のメソッド名}" );
		}
		protected override void シーンを描画する()
		{
			// このメソッドは、GUIスレッドではなく進行描画スレッドから呼び出されるので注意。

			this.スレッド排他領域.WriteLock( () => {

				#region " 描画を準備する。"
				//----------------
				var dr = this.スレッド排他領域.デバイスリソース;
				var d3dDevice = (SharpDX.Direct3D11.Device) null;
				using( var d3dLock = new FDK.同期.AutoD3DDeviceLock( dr.DXGIDeviceManager, out d3dDevice ) )
				using( d3dDevice )
				using( var d3dContext = d3dDevice.ImmediateContext )
				{
					// 既定のD3Dレンダーターゲットビューを黒でクリアする。
					d3dContext.ClearRenderTargetView( dr.D3DRenderTargetView, SharpDX.Color4.Black );

					// 深度バッファを 1.0f でクリアする。
					d3dContext.ClearDepthStencilView(
						dr.D3DDepthStencilView,
						SharpDX.Direct3D11.DepthStencilClearFlags.Depth,
						depth: 1.0f,
						stencil: 0 );
				}
				//----------------
				#endregion

				// 現在のステージを進行描画する。
				this.現在のステージ?.進行描画する( this.スレッド排他領域.デバイスリソース );

			} );

			// 表示する。垂直帰線待ちなどで時間がかかるのでロックしないこと。
			if( false == this.スレッド排他領域.アプリを終了せよ )
			{
				this.スレッド排他領域.デバイスリソース.SwapChain.Present(
					( StrokeStyleT.Config.垂直帰線待ちを行う ) ? 1 : 0,
					SharpDX.DXGI.PresentFlags.None );
			}

			this.スレッド排他領域.WriteLock( () => {

				if( null != this.現在のステージ )
				{
					// ステージの状態チェックを行い、必要あれば遷移、またはアプリを終了する。
					switch( this.現在のステージ.GetType().Name )
					{
						case nameof( ステージ.ステージ ):
							#region " 最初のダミーステージ "
							//----------------
							// 起動ステージへ遷移する。
							this.起動ステージ.活性化する( this.スレッド排他領域.デバイスリソース );
							this.現在のステージ = this.起動ステージ;
							//----------------
							#endregion
							break;

						case nameof( ステージ.起動.起動ステージ ):
							#region " 終了 → タイトルステージへ。"
							//---------------
							if( this.起動ステージ.現在のフェーズ == ステージ.起動.起動ステージ.フェーズ.終了 )
							{
								this.現在のステージ.非活性化する( this.スレッド排他領域.デバイスリソース );
								this.現在のステージ = this.タイトルステージ;
								this.現在のステージ.活性化する( this.スレッド排他領域.デバイスリソース );
							}
							//---------------
							#endregion
							break;

						case nameof( ステージ.タイトル.タイトルステージ ):
							#region " 確定 → ログインステージへ。"
							//---------------
							if( this.タイトルステージ.現在のフェーズ == ステージ.タイトル.タイトルステージ.フェーズ.確定 )
							{
								this.現在のステージ.非活性化する( this.スレッド排他領域.デバイスリソース );
								this.現在のステージ = this.ログインステージ;
								this.現在のステージ.活性化する( this.スレッド排他領域.デバイスリソース );
							}
							//---------------
							#endregion
							#region " キャンセル → アプリを終了する。"
							//---------------
							else if( this.タイトルステージ.現在のフェーズ == ステージ.タイトル.タイトルステージ.フェーズ.キャンセル )
							{
								this.現在のステージ.非活性化する( this.スレッド排他領域.デバイスリソース );
								this.現在のステージ = null;
								this.スレッド排他領域.アプリを終了せよ = true;
							}
							//---------------
							#endregion
							break;

						case nameof( ステージ.ログイン.ログインステージ ):
							#region " 確定 → ログイン処理を行って、選曲ステージへ。"
							//---------------
							if( this.ログインステージ.現在のフェーズ == ステージ.ログイン.ログインステージ.フェーズ.確定 )
							{
								// ログイン処理(1) ユーザリストに対してユーザを選択する。
								StrokeStyleT.ユーザ管理.ユーザを選択する( this.ログインステージ.ユーザインデックス );
								FDK.Log.Info( $"ユーザが選択されました。[{StrokeStyleT.ユーザ管理.現在選択されているユーザ.名前}]" );

								// ログイン処理(2) 選択ユーザの曲ツリーを構築する。
								StrokeStyleT.ユーザ管理.現在選択されているユーザ.曲を検索して曲ツリーを構築する();

								// ログイン処理(3) 構築した曲ツリーを曲リスト管理に登録する。
								StrokeStyleT.曲ツリー管理.現在の管理対象ツリー = StrokeStyleT.ユーザ管理.現在選択されているユーザ.曲ツリーのルートノード;

								// 選曲ステージへ。
								this.現在のステージ.非活性化する( this.スレッド排他領域.デバイスリソース );
								this.現在のステージ = this.選曲ステージ;
								this.現在のステージ.活性化する( this.スレッド排他領域.デバイスリソース );
							}
							//---------------
							#endregion
							#region " キャンセル → タイトルステージへ。"
							//---------------
							else if( this.ログインステージ.現在のフェーズ == ステージ.ログイン.ログインステージ.フェーズ.キャンセル )
							{
								this.現在のステージ.非活性化する( this.スレッド排他領域.デバイスリソース );
								this.現在のステージ = this.タイトルステージ;
								this.現在のステージ.活性化する( this.スレッド排他領域.デバイスリソース );
							}
							//---------------
							#endregion
							break;

						case nameof( ステージ.選曲.選曲ステージ ):
							#region " 曲確定 → 曲読込ステージへ。"
							//---------------
							if( this.選曲ステージ.現在のフェーズ == ステージ.選曲.選曲ステージ.フェーズ.曲確定 )
							{
								// 曲ノードが選択されていることを確認。
								Trace.Assert( null != StrokeStyleT.曲ツリー管理.現在選択されているノード, "[バグあり] 選択曲が null です。" );
								this.現在のステージ.非活性化する( this.スレッド排他領域.デバイスリソース );
								this.現在のステージ = this.曲読込ステージ;
								this.現在のステージ.活性化する( this.スレッド排他領域.デバイスリソース );
							}
							//---------------
							#endregion
							#region " キャンセル → アプリを終了する。"
							//---------------
							else if( this.選曲ステージ.現在のフェーズ == ステージ.選曲.選曲ステージ.フェーズ.キャンセル )
							{
								this.現在のステージ.非活性化する( this.スレッド排他領域.デバイスリソース );
								this.現在のステージ = null;
								this.スレッド排他領域.アプリを終了せよ = true;
							}
							//---------------
							#endregion
							break;

						case nameof( ステージ.曲読込.曲読込ステージ ):
							#region " 終了 → 演奏ステージへ。"
							//--------------------
							if( this.曲読込ステージ.現在のフェーズ == ステージ.曲読込.曲読込ステージ.フェーズ.終了 )
							{
								// 演奏スコアインスタンスが作成されていることを確認。
								Debug.Assert( null != StrokeStyleT.演奏スコア );

								this.現在のステージ.非活性化する( this.スレッド排他領域.デバイスリソース );
								this.現在のステージ = this.演奏ステージ;
								this.現在のステージ.活性化する( this.スレッド排他領域.デバイスリソース );
							}
							//--------------------
							#endregion
							break;

						case nameof( ステージ.演奏.演奏ステージ ):
							#region " 演奏終了 → 結果ステージへ。"
							//--------------------
							if( this.演奏ステージ.現在のフェーズ == ステージ.演奏.演奏ステージ.フェーズ.クリアor失敗 )
							{
								this.現在のステージ.非活性化する( this.スレッド排他領域.デバイスリソース );
								this.現在のステージ = this.結果ステージ;
								this.現在のステージ.活性化する( this.スレッド排他領域.デバイスリソース );
							}
							//--------------------
							#endregion
							#region " キャンセル → 選曲ステージへ。"
							//--------------------
							if( this.演奏ステージ.現在のフェーズ == ステージ.演奏.演奏ステージ.フェーズ.キャンセル )
							{
								this.現在のステージ.非活性化する( this.スレッド排他領域.デバイスリソース );
								this.現在のステージ = this.選曲ステージ;
								this.現在のステージ.活性化する( this.スレッド排他領域.デバイスリソース );
							}
							//--------------------
							#endregion
							break;

						case nameof( ステージ.結果.結果ステージ ):
							#region " 終了 → 選曲ステージへ。"
							//--------------------
							if( this.結果ステージ.現在のフェーズ == ステージ.結果.結果ステージ.フェーズ.終了 )
							{
								this.現在のステージ.非活性化する( this.スレッド排他領域.デバイスリソース );
								this.現在のステージ = this.選曲ステージ;
								this.現在のステージ.活性化する( this.スレッド排他領域.デバイスリソース );
							}
							//--------------------
							#endregion
							break;
					}
				}

			} );
		}
		protected override void デバイス依存リソースを再構築する()
		{
			FDK.Log.BeginInfo( $"{FDK.Utilities.現在のメソッド名}" );

			this.現在のステージ?.デバイス依存リソースを作成する( this.スレッド排他領域.デバイスリソース );

			FDK.Log.EndInfo( $"{FDK.Utilities.現在のメソッド名}" );
		}
		protected override void デバイス依存リソースを解放する()
		{
			FDK.Log.BeginInfo( $"{FDK.Utilities.現在のメソッド名}" );

			this.現在のステージ?.デバイス依存リソースを解放する( this.スレッド排他領域.デバイスリソース );

			FDK.Log.EndInfo( $"{FDK.Utilities.現在のメソッド名}" );
		}

		// 各ステージの、唯一のインスタンス。
		protected SST.ステージ.ステージ 最初のダミーステージ = new ステージ.ステージ();
		protected SST.ステージ.起動.起動ステージ 起動ステージ = new ステージ.起動.起動ステージ();
		protected SST.ステージ.タイトル.タイトルステージ タイトルステージ = new ステージ.タイトル.タイトルステージ();
		protected SST.ステージ.ログイン.ログインステージ ログインステージ = new ステージ.ログイン.ログインステージ();
		protected SST.ステージ.選曲.選曲ステージ 選曲ステージ = new ステージ.選曲.選曲ステージ();
		protected SST.ステージ.曲読込.曲読込ステージ 曲読込ステージ = new ステージ.曲読込.曲読込ステージ();
		protected SST.ステージ.演奏.演奏ステージ 演奏ステージ = new ステージ.演奏.演奏ステージ();
		protected SST.ステージ.結果.結果ステージ 結果ステージ = new ステージ.結果.結果ステージ();

		private SST.ステージ.ステージ 現在のステージ = null;

		#region " バックストア。"
		//----------------
		private static SST.フォルダ bs_フォルダ = null;
		private static FDK.入力.Keyboard bs_キーボード入力 = null;
		private static FDK.入力.MidiIn bs_MIDI入力 = null;
		private static FDK.メディア.サウンド.WASAPI排他.ExclusiveDevice bs_Wasapiデバイス = null;
		private static readonly Random bs_乱数 = new Random( DateTime.Now.Millisecond );
		private static SST.ユーザ.ユーザ管理 bs_ユーザ管理 = null;
		private static SST.曲.曲ツリー管理 bs_曲ツリー管理 = null;
		public static SST.設定.Config bs_Config = null;
		//----------------
		#endregion

		#region " Win32 API "
		//-----------------
		[ System.Runtime.InteropServices.DllImport( "winmm.dll", EntryPoint = "timeBeginPeriod" )]
		private static extern uint timeBeginPeriod( uint uMilliseconds );

		[System.Runtime.InteropServices.DllImport( "winmm.dll", EntryPoint = "timeEndPeriod" )]
		private static extern uint timeEndPeriod( uint uMilliseconds );
		//-----------------
		#endregion
	}
}
