﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using FDK.メディア;

namespace SST.ステージ.曲読込
{
	class 曲読込ステージ : SST.ステージ.ステージ
	{
		public enum フェーズ
		{
			初期状態,
			読込中,
			終了,
		}
		public フェーズ 現在のフェーズ { get; protected set; } = フェーズ.初期状態;

		protected override void On活性化( デバイスリソース dr )
		{
			FDK.Log.Info( "曲読込ステージを開始します。" );
			Trace.Assert( null != StrokeStyleT.曲ツリー管理.現在選択されているノード, "[バグあり] 選択曲が null です。" );
			this.現在のフェーズ = フェーズ.読込中;
			var 選択曲 = (SST.曲.MusicNode) StrokeStyleT.曲ツリー管理.現在選択されているノード;
			FDK.Log.Info( $"選択曲「{選択曲.タイトル}」({FDK.フォルダ.絶対パスをフォルダ変数付き絶対パスに変換して返す( 選択曲.sstfファイルパス )})" );
		}
		protected override void On非活性化( デバイスリソース dr )
		{
			FDK.Log.Info( "曲読込ステージを終了します。" );
		}
		public override void 進行描画する( デバイスリソース dr )
		{
			var 選択曲 = (SST.曲.MusicNode) StrokeStyleT.曲ツリー管理.現在選択されているノード;

			switch( this.現在のフェーズ )
			{
				case フェーズ.読込中:
					// 未解放なら解放する。念のため。
					StrokeStyleT.演奏スコア?.Dispose();

					// SSTFファイルを読み込んでスコアを構築。
					var user = StrokeStyleT.ユーザ管理.現在選択されているユーザ;
					StrokeStyleT.演奏スコア = new SSTFormat.スコア(
						選択曲.sstfファイルパス,
						user.Rideは左,
						user.Chinaは左,
						user.Splashは左 );
					this.現在のフェーズ = フェーズ.終了;
					break;
			}
		}
	}
}
