﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;

namespace SST.ステージ.演奏
{
	/// <summary>
	/// SSTFormat.チップ種別 の拡張メソッド。
	/// </summary>
	static class チップ種別Extensions
	{
		/// <summary>
		/// チップ種別に対応するヒットレーン種別を、ユーザ設定も参照して、決定して返す。
		/// </summary>
		/// <param name="チップ種別">調べるチップ種別。</param>
		/// <returns>対応するヒットレーン種別。</returns>
		public static ヒットレーン種別 対応するヒットレーン種別を返す( this SSTFormat.チップ種別 チップ種別 )
		{
			var レーン種別 = ヒットレーン種別.Unknown;    // ヒット判定しないレーンなら Unknown。
			var ユーザ設定 = StrokeStyleT.ユーザ管理.現在選択されているユーザ;

			switch( チップ種別 )
			{
				case SSTFormat.チップ種別.LeftCrash:
					レーン種別 = ヒットレーン種別.LeftCrash;
					break;

				case SSTFormat.チップ種別.Ride:
				case SSTFormat.チップ種別.Ride_Cup:
					レーン種別 = ( ユーザ設定.Rideは左 ) ? ヒットレーン種別.LeftCrash : ヒットレーン種別.RightCrash;
					break;

				case SSTFormat.チップ種別.China:
					レーン種別 = ( ユーザ設定.Chinaは左 ) ? ヒットレーン種別.LeftCrash : ヒットレーン種別.RightCrash;
					break;

				case SSTFormat.チップ種別.Splash:
					レーン種別 = ( ユーザ設定.Splashは左 ) ? ヒットレーン種別.LeftCrash : ヒットレーン種別.RightCrash;
					break;

				case SSTFormat.チップ種別.HiHat_Open:
				case SSTFormat.チップ種別.HiHat_HalfOpen:
				case SSTFormat.チップ種別.HiHat_Close:
					//case SSTFormat.チップ種別.HiHat_Foot:	 → 判定なし。
					レーン種別 = ヒットレーン種別.HiHat;
					break;

				case SSTFormat.チップ種別.Snare:
				case SSTFormat.チップ種別.Snare_OpenRim:
				case SSTFormat.チップ種別.Snare_ClosedRim:
					//case SSTFormat.チップ種別.Snare_Ghost: → 判定なし。
					レーン種別 = ヒットレーン種別.Snare;
					break;

				case SSTFormat.チップ種別.Bass:
					レーン種別 = ヒットレーン種別.Bass;
					break;

				case SSTFormat.チップ種別.Tom1:
				case SSTFormat.チップ種別.Tom1_Rim:
					レーン種別 = ヒットレーン種別.Tom1;
					break;

				case SSTFormat.チップ種別.Tom2:
				case SSTFormat.チップ種別.Tom2_Rim:
					レーン種別 = ヒットレーン種別.Tom2;
					break;

				case SSTFormat.チップ種別.Tom3:
				case SSTFormat.チップ種別.Tom3_Rim:
					レーン種別 = ヒットレーン種別.Tom3;
					break;

				case SSTFormat.チップ種別.RightCrash:
					レーン種別 = ヒットレーン種別.RightCrash;
					break;

				case SSTFormat.チップ種別.LeftCymbal_Mute:
					レーン種別 = ヒットレーン種別.LeftCrash;
					break;

				case SSTFormat.チップ種別.RightCymbal_Mute:
					レーン種別 = ヒットレーン種別.RightCrash;
					break;
			}

			return レーン種別;
		}

		/// <summary>
		/// チップの排他発声グループID を表す。
		/// ただし、グループID 0 は排他発声にはしないことを意味する。
		/// </summary>
		/// <remarks>
		/// このグループIDを 0 以外に設定すると、チップの発声時に、そのチップ種別に対応する排他発声グループIDを参照して
		/// それと同じ値を持つチップ種別のサウンドがすべて再生停止されてから発声されるようなる。
		/// なお、同一かどうかだけを見るので、グループIDに設定する数値は（0を除いて）どんな値でもいい。
		/// </remarks>
		/// <param name="チップ種別">調べるチップ種別。</param>
		/// <returns>チップ種別に対応する排他発声グループID。</returns>
		public static int 排他発声グループID( this SSTFormat.チップ種別 チップ種別 )
		{
			// 今のところ、排他発声を行うのはハイハット系のみ。
			switch( チップ種別 )
			{
				case SSTFormat.チップ種別.HiHat_Close:
				case SSTFormat.チップ種別.HiHat_Foot:
				case SSTFormat.チップ種別.HiHat_HalfOpen:
				case SSTFormat.チップ種別.HiHat_Open:
					return 1;
			}
			return 0;
		}
	}
}
