﻿using System;

namespace SST.ステージ.演奏
{
	/// <summary>
	/// 判定文字列のレーン種別。SSTFormat.レーン種別とは独立に定義する。
	/// </summary>
	enum ヒットレーン種別
	{
		Unknown,
		LeftCrash,
		HiHat,
		Snare,
		Bass,
		Tom1,
		Tom2,
		Tom3,
		RightCrash,
	}

	// 拡張メソッド。
	static class ヒットレーン種別Extensions
	{
		public static float レーンの中央X位置dpx( this ヒットレーン種別 laneType )
		{
			switch( laneType )
			{
				case ヒットレーン種別.LeftCrash:
					return 座標.レーンフレーム左端のX座標dpx + 36f;

				case ヒットレーン種別.HiHat:
					return 座標.レーンフレーム左端のX座標dpx + 105f;

				case ヒットレーン種別.Snare:
					return 座標.レーンフレーム左端のX座標dpx + 214f;

				case ヒットレーン種別.Tom1:
					return 座標.レーンフレーム左端のX座標dpx + 310f;

				case ヒットレーン種別.Bass:
					return 座標.レーンフレーム左端のX座標dpx + 381f;

				case ヒットレーン種別.Tom2:
					return 座標.レーンフレーム左端のX座標dpx + 448f;

				case ヒットレーン種別.Tom3:
					return 座標.レーンフレーム左端のX座標dpx + 544f;

				case ヒットレーン種別.RightCrash:
					return 座標.レーンフレーム左端のX座標dpx + 632f;
			}
			return 0;
		}
		public static float ヒット文字列の中央Y位置dpx( this ヒットレーン種別 laneType )
		{
			switch( laneType )
			{
				case ヒットレーン種別.LeftCrash:
					return 469f;

				case ヒットレーン種別.HiHat:
					return 562f;

				case ヒットレーン種別.Snare:
					return 641f;

				case ヒットレーン種別.Tom1:
					return 495f;

				case ヒットレーン種別.Bass:
					return 716f;

				case ヒットレーン種別.Tom2:
					return 558f;

				case ヒットレーン種別.Tom3:
					return 798f;

				case ヒットレーン種別.RightCrash:
					return 633f;
			}
			return 0;
		}
	}
}
