﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using FDK.メディア;

namespace SST.ステージ.選曲
{
	class 選曲ステージ : SST.ステージ.ステージ
	{
		public enum フェーズ
		{
			初期状態,
			表示中,
			曲確定,
			キャンセル,
		}
		public フェーズ 現在のフェーズ { get; protected set; } = フェーズ.初期状態;

		public 選曲ステージ()
		{
			this.子リスト.Add( this.背景動画 = new 動画( @"$(Static)\images\選曲画面BGV.mp4" ) );
			this.子リスト.Add( this.ステージ台 = new 画像( @"$(Static)\images\ステージ台.png" ) );
			this.子リスト.Add( this.ドラムセット = new 汎用.ドラムセット() );
			this.子リスト.Add( this.曲パネルビュー = new 曲パネルビュー() );
		}
		protected override void On活性化( デバイスリソース dr )
		{
			FDK.Log.Info( "選曲ステージを開始します。" );

			this.背景動画.ループ再生する = true;
			this.現在のフェーズ = フェーズ.表示中;

			this.子リスト.Add( StrokeStyleT.曲ツリー管理 );	// コンストラクタで追加したら static への直接参照がずっと子リストに残る。
		}
		protected override void On非活性化( デバイスリソース dr )
		{
			FDK.Log.Info( "選曲ステージを終了します。" );

			this.子リスト.Remove( StrokeStyleT.曲ツリー管理 );
		}
		public override void 進行描画する( デバイスリソース dr )
		{
			if( this.現在のフェーズ != フェーズ.表示中 )
				return;

			// 描画。
			this.背景動画.進行描画する( dr, new SharpDX.RectangleF( 0f, 0f, dr.設計画面サイズdpx.Width, dr.設計画面サイズdpx.Height ) );
			switch( this.現在のフェーズ )
			{
				case フェーズ.表示中:
					this.現在のフェーズ = フェーズ.表示中;
					this.曲パネルビュー.進行描画する( dr );
					this.ステージ台.進行描画する( dr, 0.0f, 0.0f );
					this.ドラムセット.進行描画する( dr );
					break;
			}

			// 入力。

			StrokeStyleT.すべての入力デバイスをポーリングする();

			// Enter 押下
			if( StrokeStyleT.キーボード入力.キーが押された( SharpDX.DirectInput.Key.Return ) )
			{
				if( StrokeStyleT.曲ツリー管理.現在選択されているノード is 曲.MusicNode )
				{
					FDK.Log.Info( "MusicNode が選択されました。" );
					this.現在のフェーズ = フェーズ.曲確定;
				}
				else if( StrokeStyleT.曲ツリー管理.現在選択されているノード is 曲.BoxNode )
				{
					FDK.Log.Info( "BoxNode が選択されました。" );
					// todo: BOX が選択された場合の実装。
				}
				else if( StrokeStyleT.曲ツリー管理.現在選択されているノード is 曲.BackNode )
				{
					FDK.Log.Info( "BackNode が選択されました。" );
					// todo: 戻る が選択された場合の実装。
				}
				else if( null == StrokeStyleT.曲ツリー管理.現在選択されているノード )
				{
					FDK.Log.Info( "曲リストが空です。何もしません。" );
				}
				else
				{
					Trace.Fail( "確定された曲が、曲でも BOX でも 戻る でも null でもありません。" );   // バグあり。
				}
			}
			// Esc 押下 → 戻る
			else if( StrokeStyleT.キーボード入力.キーが押された( SharpDX.DirectInput.Key.Escape ) )
			{
				this.現在のフェーズ = フェーズ.キャンセル;
			}

			// カーソルキー（キーバインドに寄らず固定）→ 選曲カーソル移動
			else if( StrokeStyleT.キーボード入力.キーが押された( SharpDX.DirectInput.Key.Left ) )
			{
				this.曲パネルビュー.カーソルを左に移動する();
			}
			else if( StrokeStyleT.キーボード入力.キーが押された( SharpDX.DirectInput.Key.Right ) )
			{
				this.曲パネルビュー.カーソルを右に移動する();
			}
			else if( StrokeStyleT.キーボード入力.キーが押された( SharpDX.DirectInput.Key.Up ) )
			{
				this.曲パネルビュー.カーソルを上に移動する();
			}
			else if( StrokeStyleT.キーボード入力.キーが押された( SharpDX.DirectInput.Key.Down ) )
			{
				this.曲パネルビュー.カーソルを下に移動する();
			}
		}

		protected FDK.メディア.動画 背景動画 = null;
		protected FDK.メディア.画像 ステージ台 = null;
		protected SST.ステージ.汎用.ドラムセット ドラムセット = null;
		protected 曲パネルビュー 曲パネルビュー = null;
	}
}
