﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.IO;
using System.Linq;
using FDK.メディア;

namespace SST.曲
{
	/// <summary>
	/// 曲ツリーで「曲」を表すノード。
	/// </summary>
	public class MusicNode : Node
	{
		public string sstfファイルパス { get; protected set; } = null;
//		public override SharpDX.Size2F ノード画像サイズdpx => this.サムネイル画像?.サイズdpx ?? base.ノード画像サイズdpx;
		public string 動画ファイルパス { get; protected set; } = null;

		public MusicNode( string sstfファイルパス )
		{
			this.sstfファイルパス = FDK.フォルダ.絶対パスに含まれるフォルダ変数を展開して返す( sstfファイルパス );

			// sstf と同じ場所に対応するサムネイル画像ファイルがあるなら、それをサムネイル画像として採用する。
			var サムネイル画像ファイルパス =
				( from ファイル名 in Directory.GetFiles( Path.GetDirectoryName( this.sstfファイルパス ) )
				  where 対応するサムネイル画像名.Any( thumbファイル名 => ( Path.GetFileName( ファイル名 ).ToLower() == thumbファイル名 ) )
				  select ファイル名 ).FirstOrDefault();  // 複数あったら、最初に見つけたほうを採用。1つも見つからなければ null。
			if( null != サムネイル画像ファイルパス )
			{
				// サムネイル画像ファイルがあるならインスタンスを生成。
				this.サムネイル画像 = new テクスチャ( サムネイル画像ファイルパス );
			}

			// sstf と同じ場所に（対応する拡張子を持った）動画ファイルがあるなら、それを背景動画として採用する。
			this.動画ファイルパス =
				( from ファイル名 in Directory.GetFiles( Path.GetDirectoryName( this.sstfファイルパス ) )
				  where 対応する動画の拡張子.Any( 拡張子名 => ( Path.GetExtension( ファイル名 ).ToLower() == 拡張子名 ) )
				  select ファイル名 ).FirstOrDefault();  // 複数あったら、最初に見つけたほうを採用。1つも見つからなければ null。
		}
		protected override void On活性化( デバイスリソース dr )
		{
			if( null != this.サムネイル画像 )
				this.子リスト.Add( this.サムネイル画像 );  // 子リストに追加。

			base.On活性化( dr );	// Node の活性化
		}
		protected override void On非活性化( デバイスリソース dr )
		{
			if( null != this.サムネイル画像 )
				this.子リスト.Remove( this.サムネイル画像 );	// 子リストから削除。

			base.On非活性化( dr );   // Node の非活性化
		}
		public override void ノード画像を描画する( デバイスリソース dr, SharpDX.Matrix ワールド変換行列 )
		{
			if( null != this.サムネイル画像 )
			{
				// (A) 自前のサムネイル画像があるなら、それを表示する。
				this.サムネイル画像.進行描画する( dr, ワールド変換行列 );
			}
			else
			{
				// (B) サムネイル画像がないなら、既定の曲画像を表示する。
				base.ノード画像を描画する( dr, ワールド変換行列 );
			}
		}

		protected FDK.メディア.テクスチャ サムネイル画像 = null;
		protected readonly string[] 対応する動画の拡張子 = { ".mp4", ".avi" };
		protected readonly string[] 対応するサムネイル画像名 = { "thumb.png", "thumb.bmp", "thumb.jpg", "thumb.jpeg" };
	}
}
