﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using FDK.メディア;

namespace SST.曲
{
	/// <summary>
	/// 曲ツリーを構成するノードの抽象クラス。
	/// </summary>
	public abstract class Node : FDK.Activity
	{
		public string タイトル { set; get; } = "(no title)";

		/// <summary>
		/// 自身の親のノード。
		/// </summary>
		/// <remarks>
		/// これが 非null の場合は、親ノードの子ノードリストに自身が含まれていることを意味する。
		/// これが null の場合は、ルートノードであるか、または曲ツリーにまだ登録されていないノードであることを意味する。
		/// ルートノード以外のノードは、基本的に null にはならない。
		/// </remarks>
		public Node 親ノード { get; set; } = null;
		
		/// <summary>
		/// 自身の子となるノードのリスト。
		/// 原則として、ルートノード/BOX ノード以外は 空リスト である。（一応、null にはしない。）
		/// </summary>
		public List<Node> 子ノードリスト { get; } = new List<Node>();

		public Node 前のノード
		{
			get
			{
				var 兄弟リスト = this.親ノード.子ノードリスト;
				Trace.Assert( 0 < 兄弟リスト.Count, "[バグあり] 兄弟リストの要素数がゼロです。兄弟リストには最低でも自分がいるはず。" );

				var index = 兄弟リスト.IndexOf( this );
				Trace.Assert( 0 <= index, "[バグあり] 自分が兄弟リストに存在していません。" );

				index = index - 1;
				if( 0 > index ) // 先頭なら
					index = 兄弟リスト.Count - 1;    // 末尾へ。

				return 兄弟リスト[ index ];
			}
		}
		public Node 次のノード
		{
			get
			{
				var 兄弟リスト = this.親ノード.子ノードリスト;
				if( 0 == 兄弟リスト.Count )
					throw new SSTException( "兄弟リストの Count が 0 です。" );

				var index = 兄弟リスト.IndexOf( this );
				if( 0 > index )
					throw new SSTException( "兄弟リストに this が存在していません。" );

				index = index + 1;
				if( 兄弟リスト.Count <= index )  // 末尾なら
					index = 0;  // 先頭へ。

				return 兄弟リスト[ index ];
			}
		}

		public virtual SharpDX.Size2F ノード画像サイズdpx => new SharpDX.Size2F( 314f, 220f );   // 規定の設計値[dpx]
		public virtual SharpDX.Size2F タイトル画像サイズdpx => new SharpDX.Size2F( 314f, 220f ); // 規定の設計値[dpx]（暫定）
														//=> new SharpDX.Size2F( 314f, 82f ); }	// 規定の設計値[dpx]（最終）
		protected override void On活性化( デバイスリソース dr )
		{
			// タイトル部の文字画像を作成する。
			this.子リスト.Add( this.タイトル文画像 = new 文字列画像( this.タイトル, 20.0f, "メイリオ" ) {
				レイアウトサイズdpx = new SharpDX.Size2F( 314f, 220f ),
				下詰め = true,
			} );
		}
		protected override void On非活性化( デバイスリソース dr )
		{
			this.子リスト.Remove( this.タイトル文画像 );
		}
		protected override void Onデバイス依存リソースの作成( デバイスリソース dr )
		{
			// まだ既定の曲画像が生成されてなかったら生成する。
			if( null == Node.既定の曲画像 )
			{
				Node.既定の曲画像 = new テクスチャ( @"$(Static)\images\選曲パネル.png" );
				Node.既定の曲画像.活性化する( dr );    // 既定の曲画像には子Activityはないので、ここで活性化してよい。
			}
		}
		protected override void Onデバイス依存リソースの解放( デバイスリソース dr )
		{
			// まだ既定の曲画像が解放されてなかったら解放する。
			if( null != Node.既定の曲画像 )
			{
				Node.既定の曲画像.非活性化する( dr );   // 既定の曲画像には子Activityはないので、ここで非活性化してよい。
				Node.既定の曲画像 = null;
			}
		}

		public virtual void ノード画像を描画する( デバイスリソース dr, SharpDX.Matrix ワールド変換行列 )
		{
			if( Node.既定の曲画像.活性化している )
				Node.既定の曲画像.進行描画する( dr, ワールド変換行列 );
		}
		public virtual void タイトル画像を描画する( デバイスリソース dr, SharpDX.Matrix3x2 変換行列2Dpx, SharpDX.Matrix 変換行列3Dpx, float 不透明度0to1 = 1.0f )
		{
			this.タイトル文画像.進行描画する( dr, 変換行列2Dpx, 変換行列3Dpx, 不透明度0to1 );
		}

		protected FDK.メディア.文字列画像 タイトル文画像 = null;

		protected static FDK.メディア.テクスチャ 既定の曲画像 = null;   // 全インスタンスで共有
	}
}
