﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.IO;
using System.Linq;
using FDK.メディア;

namespace SST.曲
{
	/// <summary>
	/// 曲ツリーへの参照を受け取り、その曲ツリーに対する様々な操作を提供する。
	/// </summary>
	public class 曲ツリー管理 : FDK.Activity
	{
		public RootNode 現在の管理対象ツリー
		{
			get
			{
				return this.bs_現在の管理対象ツリー;
			}
			set
			{
				this.bs_現在の管理対象ツリー = value;

				// 選択ノードを子リストの先頭にリセット。
				this.現在選択されているノード = ( 0 < value.子ノードリスト.Count ) ? value.子ノードリスト[ 0 ] : null;
			}
		}
		public Node 現在選択されているノード { get; protected set; } = null;

		public void 前のノードを選択する()
		{
			this.現在選択されているノード = this.現在選択されているノード?.前のノード;
		}
		public void 次のノードを選択する()
		{
			this.現在選択されているノード = this.現在選択されているノード?.次のノード;
		}

		public static void フォルダから曲を検索して子ノードリストに追加する( Node 追加対象ノード, string フォルダパス )
		{
			// フォルダが存在しないなら何もしない。
			if( false == Directory.Exists( フォルダパス ) )
			{
				FDK.Log.WARNING( $"指定されたフォルダが存在しません。無視します。[{FDK.フォルダ.絶対パスをフォルダ変数付き絶対パスに変換して返す( フォルダパス )}]" );
				return;
			}
			var dirInfo = new DirectoryInfo( フォルダパス );

			// (1) このフォルダにあるすべてのsstfファイルから、曲ノードを作成する。
			foreach( var fileInfo in dirInfo.GetFiles( "*.sstf", SearchOption.TopDirectoryOnly ) )
			{
				var score = new SSTFormat.スコア();
				score.t曲データファイルを読み込む_ヘッダだけ( fileInfo.FullName );
				追加対象ノード.子ノードリスト.Add( new MusicNode( fileInfo.FullName ) {
					タイトル = score.Header.str曲名,
					親ノード = 追加対象ノード,
				} );
			}

			// (2) このフォルダのすべてのサブフォルダについて……
			foreach( var subDirInfo in dirInfo.GetDirectories() )
			{
				// box.def を含むフォルダの場合 → BOX ノードを作成する。
				var boxファイルパス = Path.Combine( subDirInfo.FullName, @"box.def" );
				if( File.Exists( boxファイルパス ) )
				{
					var box = new BoxDef( boxファイルパス );
					追加対象ノード.子ノードリスト.Add( new BoxNode() {
						タイトル = box.Title,
						親ノード = 追加対象ノード,
					} );
				}

				// サブフォルダへ再帰。（通常フォルダでもBOXフォルダでも。）
				曲ツリー管理.フォルダから曲を検索して子ノードリストに追加する( 追加対象ノード, subDirInfo.FullName );
			}
		}

		protected override void On活性化( デバイスリソース dr )
		{
			if( null != this.bs_現在の管理対象ツリー )
			{
				// 子リストに含まれる全ノードを子Activityリストに追加する。
				foreach( var node in this.bs_現在の管理対象ツリー.子ノードリスト )
					this.子リスト.Add( node );
			}
		}
		protected override void On非活性化( デバイスリソース dr )
		{
			if( null != this.bs_現在の管理対象ツリー )
			{
				// 子リストに含まれる全ノードを子Activityリストから削除する。
				foreach( var node in this.bs_現在の管理対象ツリー.子ノードリスト )
					this.子リスト.Remove( node );
			}
		}

		#region " バックストア。"
		//-------------------------
		private RootNode bs_現在の管理対象ツリー = null;
		//-------------------------
		#endregion
	}
}
