﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.IO;
using System.Linq;
using System.ServiceModel;
using System.Threading.Tasks;
using System.Windows.Forms;
using FDK;
using SST.Viewer;

namespace SST
{
	static class Program
	{
		/// <summary>
		/// アプリケーションのメイン エントリ ポイントです。
		/// </summary>
		[STAThread]
		static void Main( string[] args )
		{
			Application.EnableVisualStyles();
			Application.SetCompatibleTextRenderingDefault( false );

			// Trace/Debug 出力をログファイルに出力する。
			var ログの最大保存期間 = new TimeSpan( 30, 0, 0, 0 );		// 最大30日保存。
			((DefaultTraceListener) Trace.Listeners["Default"]).LogFileName = 
				Log.ログファイル名を生成する( Path.Combine( SST.IO.Folder.AppData, "Logs" ), "StrokeStyleTLog", ログの最大保存期間 );

			Log.現在のスレッドに名前をつける( "描画" );
			Log.Header( "アプリケーションを起動します。" );

			using( var app = new App( args ) )
			{
				if( App.ビュアーモードである )
				{
					#region " (A) ビュアーモードでの起動（WCFサービスあり）"
					//----------------
					Log.Header( "ビュアーモード で起動します。" );

					string serviceUri = "net.pipe://localhost/StrokeStyleT";
					string endPointName = "Viewer";
					string endPointUri = $"{serviceUri}/{endPointName}";

					// アプリのサービスホストを生成する。
					var serviceHost = new ServiceHost( app, new Uri( serviceUri ) );

					// 名前付きパイプにバインドしたエンドポイントをサービスホストへ追加する。
					serviceHost.AddServiceEndpoint(
						typeof( IStrokeStyleTService ),
						new NetNamedPipeBinding( NetNamedPipeSecurityMode.None ),
						endPointName );

					// サービスの受付を開始する。
					try
					{
						serviceHost.Open();
					}
					catch( AddressAlreadyInUseException )
					{
						MessageBox.Show( "同じアプリがすでに起動しています。多重起動はできません。", "SST Error", MessageBoxButtons.OK );
						return;
					}

					// アプリを実行する。
					try
					{
						app.Run();
					}
					finally
					{
						// サービスの受付を終了する。
						serviceHost.Close( new TimeSpan( 0, 0, 2 ) );   // 最大2sec待つ
					}
					//----------------
					#endregion
				}
				else
				{
					#region " (B) 通常の起動（WCFサービスなし）"
					//----------------
					Log.Header( "通常モード で起動します。" );
					app.Run();
					//----------------
					#endregion
				}

				Log.Header( "アプリケーションを終了します。" );
			}

			Log.Header( "アプリケーションを終了しました。" );
		}
	}
}
