#pragma once

#include "\CritSec.h"
#include "\AutoLock.h"
#include "refIInputDevice.h"

namespace FDK
{
	
	// III@WCXeBbNɊւĂ͖B@III


	public ref class CInputǗ
	{
	public:
		static int nʏ퉹 = 110;

		// ǂ̃EBhE͊ǗsĂ邩́ÃvpeBŊmFB
		property IntPtr hWnd
		{
			IntPtr get() { return this->_hWnd; }
		protected:
			void set( IntPtr value ) { this->_hWnd = value; }
		}
		property List<IInputDevice^>^ list̓foCX
		{
			List<IInputDevice^>^ get() { return this->_list̓foCX; }
		protected:
			void set( List<IInputDevice^>^ value ) { this->_list̓foCX = value; }
		}
		property IInputDevice^ Keyboard
		{
			IInputDevice^ get()
			{
				if( this->_Keyboard != nullptr )
				{
					return this->_Keyboard;
				}
				for each( IInputDevice^ device in this->list̓foCX )
				{
					if( device->e̓foCX == E̓foCX::L[{[h )
					{
						this->_Keyboard = device;
						return device;
					}
				}
				return nullptr;
			}
		}
		property IInputDevice^ Mouse
		{
			IInputDevice^ get()
			{
				if( this->_Mouse != nullptr )
				{
					return this->_Mouse;
				}
				for each( IInputDevice^ device in this->list̓foCX )
				{
					if( device->e̓foCX == E̓foCX::}EX )
					{
						this->_Mouse = device;
						return device;
					}
				}
				return nullptr;
			}
		}
		property UInt32 nMidiIn
		{
			UInt32 get() { return this->_nMIDIfoCX; }
		protected:
			void set( UInt32 value ) { this->_nMIDIfoCX = value; }
		}
		IInputDevice^ MidiIn( int ID );

		delegate void MidiInProcDelegate( HMIDIIN hMidiIn, UINT wMsg, DWORD_PTR dwInstance, DWORD_PTR dwParam1, DWORD_PTR dwParam2 );

		CInputǗ( IntPtr hWnd );
		~CInputǗ();

		void t|[O( bool bWindowANeBu, bool bobt@͂gp )
		{
			AutoLock lock( *CInputǗ::pcsCallback );

			for( int i = this->list̓foCX->Count - 1; i >= 0; i-- )
			{
				IInputDevice^ device = this->list̓foCX[ i ];
				try
				{
					device->t|[O( bWindowANeBu, bobt@͂gp );
				}
				catch( Exception^ )
				{
					// |[OɎŝŁÃfoCXOB

					delete device;
					this->list̓foCX->RemoveAt( i );
				}
			}
		}

	protected:
		IDirectInput8		*pDI;
		CTimer^				timer;
		static CritSec		*pcsCallback;
		GCHandle			gchMidiInProc;
		MidiInProcDelegate^	dgMidiInProc;

		// MIDI̓R[obN
		void midiInProc( HMIDIIN hMidiIn, UINT wMsg, DWORD_PTR dwInstance, DWORD_PTR dwParam1, DWORD_PTR dwParam2 );

	private:
		IntPtr _hWnd;
		List<IInputDevice^>^ _list̓foCX;
		IInputDevice^ _Keyboard;
		IInputDevice^ _Mouse;
		UInt32 _nMIDIfoCX;
	};
}
