#include "Stdafx.h"
#include "CTvv[.h"
#include "\AutoLock.h"

namespace FDK
{
// public:

	CTvv[::CTvv[()
	{
		m_bInitialized = FALSE;
		m_ñ݂Tv = 0;
	}
	CTvv[::~CTvv[()
	{
	}

	HRESULT	CTvv[::t( CVideoSampleList& samples )
	{
		AutoLock lock( m_lock );

		if( m_bInitialized )
			return MF_E_INVALIDREQUEST;

		HRESULT hr = S_OK;
		IMFSample *pSample = NULL;

		// samples Ɋ܂܂TvAS m_VideoSampleQuere Ɋi[B

		CVideoSampleList::POSITION pos = samples.FrontPosition();

		while( pos != samples.EndPosition() )
		{
			hr = samples.GetItemPos( pos, &pSample );
					
			if( FAILED( hr ) )
			{
				Trace::TraceError( "GetItemPos() Ɏs܂B" );
				goto failed;
			}
					
			hr = m_VideoSampleQueue.InsertBack( pSample );
					
			if( FAILED( hr ) )
			{
				Trace::TraceError( "InsertBack() Ɏs܂B" );
				goto failed;
			}

			pos = samples.Next( pos );
			COM_SAFE_RELEASE( pSample );
		}
		m_bInitialized = TRUE;

	failed:
		samples.Clear();
		COM_SAFE_RELEASE( pSample );

		return hr;
	}
	HRESULT CTvv[::Clear()
	{
		HRESULT hr = S_OK;
		AutoLock lock( m_lock );

		m_VideoSampleQueue.Clear();
		m_bInitialized = FALSE;
		m_ñ݂Tv = 0;
		return S_OK;
	}

	HRESULT	CTvv[::tv[Tvo( IMFSample **ppSample )
	{
		AutoLock lock( m_lock );

		if( !m_bInitialized )
			return MF_E_NOT_INITIALIZED;	// ĂȂ

		if( m_VideoSampleQueue.IsEmpty() )
			return MF_E_SAMPLEALLOCATOR_EMPTY;	// L[ł

    
		// L[Tv擾B

		HRESULT hr = S_OK;
		IMFSample *pSample = NULL;

		// Xg̐擪܂͖̂ǂ炩oɂĂ͋CɂKv͂ȂA
		// ߂ꍇɂ́A𔽑Α̒[ɑ}B
			
		if( SUCCEEDED( hr = m_VideoSampleQueue.RemoveFront( &pSample ) ) ) 
		{
			m_ñ݂Tv++;

			// ĂяoɃTvԂB
			*ppSample = pSample;
			(*ppSample)->AddRef();
		}

		COM_SAFE_RELEASE( pSample );
		return hr;
	}
	HRESULT	CTvv[::tTvv[ɖ߂( IMFSample *pSample )
	{
		AutoLock lock( m_lock );

		if( !m_bInitialized )
			return MF_E_NOT_INITIALIZED;

		HRESULT hr = S_OK;

		if( SUCCEEDED( hr = m_VideoSampleQueue.InsertBack( pSample ) ) )
			m_ñ݂Tv--;

		return hr;
	}
	BOOL	CTvv[::bTv݂Ă()
	{
		AutoLock lock( m_lock );

		if( !m_bInitialized )
			return FALSE;	// ĂȂ

		return ( m_ñ݂Tv > 0 );
	}
}
