﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Diagnostics;
using System.IO;
using FDK;

namespace StrokeStyleT
{
	class CPlayerMode : IDisposable
	{
		public bool bプレイヤーモードである
		{
			get;
			set;	// 起動直後、Program.Main() 内で設定される。
		}
		public bool bプレイヤーモードではない
		{
			get { return !bプレイヤーモードである; }
			set { bプレイヤーモードである = !value; }
		}

		/// <summary>
		/// <para>プレイヤーモード時のコマンドライン。</para>
		/// <para>引数ありで起動されたり WM_COPYDATA を受けたりした場合はこのプロパティにコマンドライン配列が格納される。</para>
		/// <para>通常は null である。アプリではこれを定期的にポーリングし、非 null になればアクションを実行してまた null に戻すこと。</para>
		/// </summary>
		public volatile string[] arrayコマンドライン = null;
		public volatile string stg演奏ファイル名 = null;
		public volatile bool b仮想ドラムあり = true;
		public volatile int n演奏開始小節番号 = 0;

		public E進行結果 tアクション解析・指示( string[] args )
		{
			// コマンドラインオプションを初期化。

			bool b演奏開始 = false;
			bool b演奏停止 = false;
			this.b仮想ドラムあり = true;
			this.n演奏開始小節番号 = 0;
			//this.strプレイヤーモードの演奏ファイル名 = null;		前回の値を維持する。


			// コマンドライン解析

			for( int i = 0; i < args.Length; i++ )
			{
				#region [ -p : 演奏開始 ]
				//-----------------
				if( args[ i ].Equals( "-p", StringComparison.CurrentCultureIgnoreCase ) )
				{
					b演奏開始 = true;

					int num;
					if( ( i + 1 ) < args.Length && int.TryParse( args[ i + 1 ], out num ) )
					{
						if( num < 0 ) num = 0;
						this.n演奏開始小節番号 = num;
						i++;
					}
					continue;
				}
				//-----------------
				#endregion
				#region [ -s : 演奏停止 ]
				//-----------------
				else if( args[ i ].Equals( "-s", StringComparison.CurrentCultureIgnoreCase ) )
				{
					b演奏停止 = true;
					continue;
				}
				//-----------------
				#endregion
				#region [ -h : 仮想ドラム有り ]
				//-----------------
				else if( args[ i ].Equals( "-h", StringComparison.CurrentCultureIgnoreCase ) )
				{
					this.b仮想ドラムあり = true;
					continue;
				}
				//-----------------
				#endregion
				#region [ ファイルとして存在するその他文字列：ファイル名 ]
				//-----------------
				else if( File.Exists( args[ i ] ) )
				{
					this.stg演奏ファイル名 = args[ i ];
					continue;
				}
				//-----------------
				#endregion
				#region [ その他：無効なオプション ]
				//-----------------
				else
				{
					continue;
				}
				//-----------------
				#endregion
			}


			// オプションに従いアクションを実行

			if( b演奏停止 )
				return E進行結果.GUI割込・演奏停止;

			if( b演奏開始 && !string.IsNullOrEmpty( this.stg演奏ファイル名 ) )
			{
				return E進行結果.GUI割込・演奏開始;

				/*
				// （現在演奏中なら）演奏を終了する。

				Global.Stage.m演奏ステージ.On非活性化();
				C共通.tDisposeする( ref Global.Song.r現在演奏中のスコアのBGM );
				C共通.tDisposeする( ref Global.Song.r現在演奏中のスコアの背景動画 );
				C共通.tDisposeする( ref Global.Song.r現在演奏中の曲のスコア );


				// 新しいスコアを読み込み、演奏を開始。

				Global.Song.r現在演奏中の曲のスコア = Global.Song.tスコアを読み込む( Global.PlayerMode.str演奏ファイル名 );
				if( Global.Song.r現在演奏中の曲のスコア == null )
					return;


				// 再生遅延の反映……は行わない。


				// 演奏開始。

				Global.Users.Config.HitSound = b仮想ドラムあり;
				Global.Stage.m演奏ステージ.On活性化( Global.App.D3D9Device );	// スタンバイOK、演奏（進行）処理開始。
				// Global.Misc.Act背景動画.On活性化();	// 演奏ステージの活性化の中で Act背景動画 が活性化されるので、ここでは何もしない。



				// 指定された演奏位置へ移動。

				if( Global.Song.r現在演奏中の曲のスコア != null )	// 読み込み成功時のみ
					Global.Stage.m演奏ステージ.t演奏位置指定( n演奏開始小節番号 );


				// ウィンドウを最前面へ。

				Global.App.Window.Activate();

				*/
			}

			return E進行結果.完了;
		}

		#region [ IDisposable 実装 …… 特になし ]
		//-----------------
		public void Dispose()
		{
		}
		//-----------------
		#endregion
	}
}
