﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Text;
using System.Drawing;
using System.Threading.Tasks;

namespace StrokeStyleT
{
	class Theme
	{
		public static void t初期化()
		{
			Theme.演奏.dicパッドの中心スクリーン座標px = new Dictionary<E演奏レーン, Point>();
			Theme.演奏.dicパッドの左上スクリーン座標px = new Dictionary<E演奏レーン, Point>();
			Theme.演奏.dic判定文字列の中心スクリーン座標px = new Dictionary<E演奏レーン, Point>();

			int FrameX = Theme.演奏.n画面左端からフレーム左までの距離px;
			int ScreenBottom = Theme.szウィンドウ.Height;
			var szPadHalf = new Size( 60, 60 );		// １つのパッド画像サイズは 120x120（固定）。

			// すべての演奏レーンについて……

			foreach( var obj in Enum.GetValues( typeof( E演奏レーン ) ) )
			{
				var eレーン = (E演奏レーン) obj;

				#region [ Unknown は無視。]
				//-----------------
				if( eレーン == E演奏レーン.Unknown )
					continue;
				//-----------------
				#endregion

				Theme.演奏.dicパッドの中心スクリーン座標px.Add(
					eレーン,
					new Point(
						FrameX + Theme.演奏.dicパッドの中央位置[ eレーン ].X,
						ScreenBottom - Theme.演奏.dicパッドの中央位置[ eレーン ].Y ) );

				Theme.演奏.dicパッドの左上スクリーン座標px.Add(
					eレーン,
					Point.Subtract( Theme.演奏.dicパッドの中心スクリーン座標px[ eレーン ], szPadHalf ) );

				Theme.演奏.dic判定文字列の中心スクリーン座標px.Add(
					eレーン,
					new Point(
						Theme.演奏.dicパッドの中心スクリーン座標px[ eレーン ].X,
						ScreenBottom - Theme.演奏.dic画面下端から判定文字列中心までの距離[ eレーン ] ) );
			}
		}

		public static Size szウィンドウ = new Size( 1280, 720 );

		public static class 選曲
		{
			public static Size szサムネイルパネル = new Size( 140, 105 );
			public static Size szサムネイルプロパティパネル = new Size( 146, 50 );
		}
		public static class 演奏
		{
			public static int n画面下端からヒットバー中央までの距離px = (int) ( 720 * ( 1 - 0.88125 ) );	// 0.88125 は DTXMania のヒットバーの中心Ｙ座標の位置の割合(423÷480）
			public static int n画面左端からフレーム左までの距離px = 20;

			public static Rectangle rcBGVサムネイル = new Rectangle( 826 + 24, 720 - 225 - 32, 400, 225 );

			public static Dictionary<E演奏レーン, Point> dicパッドの中心スクリーン座標px;
			public static Dictionary<E演奏レーン, Point> dicパッドの左上スクリーン座標px;
			public static Dictionary<E演奏レーン, Point> dic判定文字列の中心スクリーン座標px;

			/// <summary>Xはフレームの左端、Yはフレームの下端からの相対処理[px]。（Yは正数が上方向）</summary>
			internal static Dictionary<E演奏レーン, Point> dicパッドの中央位置 = new Dictionary<E演奏レーン, Point>(){
				{ E演奏レーン.LeftCymbal, new Point( 29, 60 ) },
				{ E演奏レーン.FootPedal, new Point( 79, 0 ) },
				{ E演奏レーン.HiHat, new Point( 79, 37 ) },
				{ E演奏レーン.Snare, new Point( 133, 8 ) },
				{ E演奏レーン.Tom1, new Point( 189, 47 ) },
				{ E演奏レーン.Bass, new Point( 231, -3 ) },
				{ E演奏レーン.Tom2, new Point( 269, 47 ) },
				{ E演奏レーン.Tom3, new Point( 334, 7 ) },
				{ E演奏レーン.RightCymbal, new Point( 394, 58 ) },
			};

			internal static Dictionary<E演奏レーン, int> dic画面下端から判定文字列中心までの距離 = new Dictionary<E演奏レーン, int>() {
				{ E演奏レーン.LeftCymbal, 276 },
				{ E演奏レーン.FootPedal, 164 },
				{ E演奏レーン.HiHat, 239 },
				{ E演奏レーン.Snare, 197 },
				{ E演奏レーン.Tom1, 262 },
				{ E演奏レーン.Bass, 162 },
				{ E演奏レーン.Tom2, 221 },
				{ E演奏レーン.Tom3, 180 },
				{ E演奏レーン.RightCymbal, 270 },
			};
		}
	}
}
