﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Diagnostics;
using System.Text;
using System.Windows.Forms;
using System.IO;

namespace StrokeStyleT
{
	public partial class Cコンフィグウィンドウ : CDrumsControlableFormBase
	{
		public Cコンフィグウィンドウ( Form owner )
			: base( owner )
		{
			InitializeComponent();

			// 自動演奏

			this.checkBox一括切替え.Checked = false;
			this.checkBoxLeftCymbal.Checked = Global.User.Config.AutoPlayLeftCymbal;
			this.checkBoxFootPedal.Checked = Global.User.Config.AutoPlayFootPedal;
			this.checkBoxHiHat.Checked = Global.User.Config.AutoPlayHiHat;
			this.checkBoxSnare.Checked = Global.User.Config.AutoPlaySnare;
			this.checkBoxTom1.Checked = Global.User.Config.AutoPlayTom1;
			this.checkBoxBass.Checked = Global.User.Config.AutoPlayBass;
			this.checkBoxTom2.Checked = Global.User.Config.AutoPlayTom2;
			this.checkBoxTom3.Checked = Global.User.Config.AutoPlayTom3;
			this.checkBoxRightCymbal.Checked = Global.User.Config.AutoPlayRightCymbal;

			// ヒット範囲

			this.numericUpDownPerfecrRange.Value = (decimal) Global.User.Config.PerfectRange;
			this.numericUpDownGreatRange.Value = (decimal) Global.User.Config.GreatRange;
			this.numericUpDownGoodRange.Value = (decimal) Global.User.Config.GoodRange;
			this.numericUpDownPoorRange.Value = (decimal) Global.User.Config.PoorRange;

			// 画面モード

			this.radioButtonウィンドウモード.Checked = Global.User.Config.Windowed;
			this.labelテーマサイズ.Text = string.Format( "{0}×{1} ）", Theme.szウィンドウ.Width, Theme.szウィンドウ.Height );

			this.radioButtonウィンドウモード.Enabled = false;	// いまは変更不可
			this.comboBoxウィンドウモード.Enabled = false;		//

			// 描画

			this.checkBoxVSyncWait.Checked = Global.User.Config.VSyncWait;
			this.numericUpDownSpeed.Value = (decimal) Global.User.Config.ScrollSpeed;
			this.numericUpDownフレーム背景の不透明度.Value = (decimal) Global.User.Config.PlayFrameOpacity;

			// レーン

			this.radioButtonLeftChina_Left.Checked = Global.User.Config.ChinaLeft;
			this.radioButtonLeftChina_Right.Checked = !Global.User.Config.ChinaLeft;
			this.radioButtonLeftRide_Left.Checked = Global.User.Config.RideLeft;
			this.radioButtonLeftRide_Right.Checked = !Global.User.Config.RideLeft;
			this.radioButtonLeftSplash_Left.Checked = Global.User.Config.SplashLeft;
			this.radioButtonLeftSplash_Right.Checked = !Global.User.Config.SplashLeft;

			// COMBO位置

			this.radioButtonComboLeft.Checked = ( Global.User.Config.ComboPosition == Eコンボ表示位置.LEFT );
			this.radioButtonComboCenter.Checked = ( Global.User.Config.ComboPosition == Eコンボ表示位置.CENTER );
			this.radioButtonComboRight.Checked = ( Global.User.Config.ComboPosition == Eコンボ表示位置.RIGHT );
			this.radioButtonComboOff.Checked = ( Global.User.Config.ComboPosition == Eコンボ表示位置.OFF );

			// その他

			this.checkBoxHitSound.Checked = Global.User.Config.HitSound;
		}

		bool b自動演奏がすべてONである
		{
			get
			{
				return
					this.checkBoxLeftCymbal.Checked &&
					this.checkBoxFootPedal.Checked &&
					this.checkBoxHiHat.Checked &&
					this.checkBoxSnare.Checked &&
					this.checkBoxTom1.Checked &&
					this.checkBoxBass.Checked &&
					this.checkBoxTom2.Checked &&
					this.checkBoxTom3.Checked &&
					this.checkBoxRightCymbal.Checked;
			}
		}
		void t自動演奏がすべてONである場合は仮想ドラムを強制的にONにする()
		{
			if( this.b自動演奏がすべてONである )
				this.checkBoxHitSound.Checked = true;
		}

		private void checkBox一括切替え_CheckedChanged( object sender, EventArgs e )
		{
			this.checkBoxLeftCymbal.Checked =
			this.checkBoxFootPedal.Checked =
			this.checkBoxHiHat.Checked =
			this.checkBoxSnare.Checked =
			this.checkBoxTom1.Checked =
			this.checkBoxBass.Checked =
			this.checkBoxTom2.Checked =
			this.checkBoxTom3.Checked =
			this.checkBoxRightCymbal.Checked =
				this.checkBox一括切替え.Checked;

			this.t自動演奏がすべてONである場合は仮想ドラムを強制的にONにする();
		}
		private void checkBoxHitSound_CheckedChanged( object sender, EventArgs e )
		{
			// 自動演奏がすべて ON の場合はチェックを強制 OFF にする。

			if( !this.checkBoxHitSound.Checked && this.b自動演奏がすべてONである )
			{
				MessageBox.Show( "自動演奏がすべて ON の場合、仮想ドラムは強制的に ON になります。", "確認", MessageBoxButtons.OK );
				this.checkBoxHitSound.Checked = true;
			}
		}
		private void checkBoxLeftCymbal_CheckedChanged( object sender, EventArgs e )
		{
			this.t自動演奏がすべてONである場合は仮想ドラムを強制的にONにする();
		}
		private void checkBoxFootPedal_CheckedChanged( object sender, EventArgs e )
		{
			this.t自動演奏がすべてONである場合は仮想ドラムを強制的にONにする();
		}
		private void checkBoxHiHat_CheckedChanged( object sender, EventArgs e )
		{
			this.t自動演奏がすべてONである場合は仮想ドラムを強制的にONにする();
		}
		private void checkBoxSnare_CheckedChanged( object sender, EventArgs e )
		{
			this.t自動演奏がすべてONである場合は仮想ドラムを強制的にONにする();
		}
		private void checkBoxTom1_CheckedChanged( object sender, EventArgs e )
		{
			this.t自動演奏がすべてONである場合は仮想ドラムを強制的にONにする();
		}
		private void checkBoxBass_CheckedChanged( object sender, EventArgs e )
		{
			this.t自動演奏がすべてONである場合は仮想ドラムを強制的にONにする();
		}
		private void checkBoxTom2_CheckedChanged( object sender, EventArgs e )
		{
			this.t自動演奏がすべてONである場合は仮想ドラムを強制的にONにする();
		}
		private void checkBoxTom3_CheckedChanged( object sender, EventArgs e )
		{
			this.t自動演奏がすべてONである場合は仮想ドラムを強制的にONにする();
		}
		private void checkBoxRightCymbal_CheckedChanged( object sender, EventArgs e )
		{
			this.t自動演奏がすべてONである場合は仮想ドラムを強制的にONにする();
		}
		private void button確定_Click( object sender, EventArgs e )
		{
			// 自動演奏

			Global.User.Config.AutoPlayLeftCymbal = this.checkBoxLeftCymbal.Checked;
			Global.User.Config.AutoPlayFootPedal = this.checkBoxFootPedal.Checked;
			Global.User.Config.AutoPlayHiHat = this.checkBoxHiHat.Checked;
			Global.User.Config.AutoPlaySnare = this.checkBoxSnare.Checked;
			Global.User.Config.AutoPlayTom1 = this.checkBoxTom1.Checked;
			Global.User.Config.AutoPlayBass = this.checkBoxBass.Checked;
			Global.User.Config.AutoPlayTom2 = this.checkBoxTom2.Checked;
			Global.User.Config.AutoPlayTom3 = this.checkBoxTom3.Checked;
			Global.User.Config.AutoPlayRightCymbal = this.checkBoxRightCymbal.Checked;

			// ヒット範囲

			Global.User.Config.PerfectRange = (int) this.numericUpDownPerfecrRange.Value;
			Global.User.Config.GreatRange = (int) this.numericUpDownGreatRange.Value;
			Global.User.Config.GoodRange = (int) this.numericUpDownGoodRange.Value;
			Global.User.Config.PoorRange = (int) this.numericUpDownPoorRange.Value;

			// 画面モード


			// 描画

			Global.User.Config.VSyncWait = this.checkBoxVSyncWait.Checked;
			Global.User.Config.ScrollSpeed = (float) this.numericUpDownSpeed.Value;
			Global.User.Config.PlayFrameOpacity = (int) this.numericUpDownフレーム背景の不透明度.Value;

			// レーン

			Global.User.Config.ChinaLeft = this.radioButtonLeftChina_Left.Checked;
			Global.User.Config.RideLeft = this.radioButtonLeftRide_Left.Checked;
			Global.User.Config.SplashLeft = this.radioButtonLeftSplash_Left.Checked;

			// COMBO位置

			if( this.radioButtonComboLeft.Checked )
				Global.User.Config.ComboPosition = Eコンボ表示位置.LEFT;
			else if( this.radioButtonComboCenter.Checked )
				Global.User.Config.ComboPosition = Eコンボ表示位置.CENTER;
			else if( this.radioButtonComboRight.Checked )
				Global.User.Config.ComboPosition = Eコンボ表示位置.RIGHT;
			else
				Global.User.Config.ComboPosition = Eコンボ表示位置.OFF;

			// その他

			Global.User.Config.HitSound = this.checkBoxHitSound.Checked;


			// Config.xml の保存

			Global.User.Config.t保存する( Path.Combine( Folder.stgユーザ個別フォルダ, Properties.Resources.XMLNAME_CONFIG ) );
		}
	}
}
