﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Diagnostics;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.IO;
using FDK;

namespace StrokeStyleT
{
	/// <summary>
	/// <para>確定後、「tGUIツリーからSongツリーを再帰的に構築する」で確定後の SongListFiles を得る。</para>
	/// </summary>
	public partial class Cユーザ別曲リスト管理ウィンドウ : CDrumsControlableFormBase
	{
		public Cユーザ別曲リスト管理ウィンドウ( Form owner, List<string> SongListFiles )
			: base( owner )
		{
			InitializeComponent();

			#region [ すべてのSongListについてツリーと対応表に追加 ]
			//-----------------
			this.dicノードSong対応表 = new Dictionary<TreeNode, SongNode>();

			this.treeView曲ツリー.Nodes.Clear();
			foreach( var stgマクロ付きSongListファイル名 in SongListFiles )
				this.tSongListファイルを追加する( Folder.tファイルパス内のマクロを展開する( stgマクロ付きSongListファイル名 ) );
			//-----------------
			#endregion

			this.tGUIのEnableを設定する();
		}

		public void tGUIツリーからSongツリーを再帰的に構築する( TreeNodeCollection nodes, List<SongNode> listSong )
		{
			foreach( TreeNode node in nodes )
			{
				// 自身をSongツリーに登録する。

				var song = this.dicノードSong対応表[ node ];
				listSong.Add( song );


				// BOX なら子Songを再帰的に登録する。

				if( song.e種別 == SongNode.E種別.BOX )
					this.tGUIツリーからSongツリーを再帰的に構築する( node.Nodes, song.childlen );
			}
		}

		Dictionary<TreeNode, SongNode> dicノードSong対応表;
		string stg最後に開いたフォルダ = Folder.stgユーザ個別フォルダ;

		void tGUIのEnableを設定する()
		{
			#region [ SongListが１つ以上あるときのみ有効になるGUI。]
			//-----------------
			bool bSongListが１つ以上ある = false;
			foreach( TreeNode node in this.treeView曲ツリー.Nodes )
			{
				if( !this.dicノードSong対応表.ContainsKey( node ) )		// SongListノードは対応表には入れない仕様。
				{
					bSongListが１つ以上ある = true;
					break;
				}
			}
			this.button曲を追加.Enabled = 
				this.buttonフォルダ内指定して曲を追加.Enabled = 
				this.buttonBOXを作成.Enabled = bSongListが１つ以上ある;
			//-----------------
			#endregion
			#region [ ノード選択中であるときのみ有効になるGUI。]
			//-----------------
			bool bノード選択中 = (
				this.treeView曲ツリー.Nodes.Count > 0 &&
				this.treeView曲ツリー.SelectedNode != null );

			this.buttonSongList上へ.Enabled = 
				this.buttonSongList下へ.Enabled = 
				this.button選択項目をリストから除去.Enabled = bノード選択中;
			//-----------------
			#endregion
			#region [ ノードが BOX 内にあるときのみ有効になるGUI。]
			//-----------------
			bool bノードがBOX内にある = (
				this.treeView曲ツリー.Nodes.Count > 0 &&
				this.treeView曲ツリー.SelectedNode != null &&
				this.treeView曲ツリー.SelectedNode.Parent != null &&
				this.dicノードSong対応表.ContainsKey( this.treeView曲ツリー.SelectedNode.Parent ) );	// SongListノードは対応表には入れない仕様。


			this.button選択項目をBOXから出す.Enabled = bノードがBOX内にある;
			//-----------------
			#endregion
			#region [ Song の同一層１つ上が BOX ノードであるときのみ有効になるGUI。]
			//-----------------
			bool bノードがBOXノードの直下にある = (
				this.treeView曲ツリー.Nodes.Count > 0 &&
				this.treeView曲ツリー.SelectedNode != null &&
				this.treeView曲ツリー.SelectedNode.PrevNode != null &&
				this.dicノードSong対応表.ContainsKey( this.treeView曲ツリー.SelectedNode.PrevNode ) &&	// SongListノードは対応表には入れない仕様。
				this.dicノードSong対応表[ this.treeView曲ツリー.SelectedNode.PrevNode ].e種別 == SongNode.E種別.BOX );

			this.button選択項目をBOXに入れる.Enabled = bノードがBOXノードの直下にある;
			//-----------------
			#endregion
		}
		bool bSongListノードである( TreeNode node )
		{
			return !this.dicノードSong対応表.ContainsKey( node );
		}
		int nImageIndexを返す( string key )
		{
			return 0;// this.imageListツリーノード.Images.IndexOfKey( key );
		}
		void tSongListファイルを追加する( string stg生SongListファイル名 )
		{
			var strマクロ付きSongListファイル名 = Folder.tファイルパスをマクロ付きパスに変換する( stg生SongListファイル名 );

			SongList songList = null;

			#region [ SongListファイルの読み込み ]
			//-----------------
			songList = SongList.t読み込む( stg生SongListファイル名 );

			if( songList == null )
				return;	// 読み込みに失敗したら無視。
			//-----------------
			#endregion

			#region [ SongListの内容をツリーならびに対応表にすべて追加 ]
			//-----------------

			// ツリー修正開始。

			this.treeView曲ツリー.BeginUpdate();


			// SongList ノードを追加。（SongListノードは対応表には追加しないものとする。）

			int imageIndex = this.nImageIndexを返す( "SongList_Opened" );
			var node = new TreeNode() {
				Text = strマクロ付きSongListファイル名,
				ImageIndex = imageIndex,
				SelectedImageIndex = imageIndex,
			};

			this.treeView曲ツリー.Nodes.Add( node );


			// SongList 配下の Songs をツリー＆対応表に追加。

			this.tツリーに再帰的にアイテムを追加する( node.Nodes, songList.Songs );


			// SongListノードにフォーカス。

			node.Expand();	// ツリーは開く
			this.treeView曲ツリー.SelectedNode = node;
			this.treeView曲ツリー.Select();


			// ツリー修正終了。

			this.treeView曲ツリー.EndUpdate();
			//-----------------
			#endregion
		}
		void t曲ファイルを追加する( string str生曲ファイル名, TreeNodeCollection parentNodes, int n挿入位置 )
		{
			// ファイルをヘッダだけ読み込んでスコアを構築。

			var score = new Cスコア();
			score.t曲データファイルを読み込む・ヘッダだけ( str生曲ファイル名 );


			// スコアからタイトルを抽出し、GUIツリーに追加。

			var node = new TreeNode( score.Header.str曲名 );
			parentNodes.Insert( n挿入位置, node );


			// 対応表にも追加。

			this.dicノードSong対応表.Add(
				node,
				new SongNode() {
					Title = score.Header.str曲名,
					Description = score.Header.str説明文,
					ScoreFile = str生曲ファイル名,
					childlen = new List<SongNode>(),
				} );
		}
		void t曲ファイルを追加する( string[] arr生曲ファイル名 )
		{
			// 挿入位置を取得。

			TreeNodeCollection parentNodes = null;
			int n挿入位置 = 0;
			this.t現在の選択曲から挿入すべき親ノード集合と位置を返す( out parentNodes, out n挿入位置 );


			// すべての選択ファイルについて、ツリーと対応表に追加する。

			this.treeView曲ツリー.BeginUpdate();

			foreach( string str生ファイル名 in arr生曲ファイル名 )
			{
				this.t曲ファイルを追加する( str生ファイル名, parentNodes, n挿入位置 );
				n挿入位置++;
			}

			this.treeView曲ツリー.EndUpdate();
		}
		void tツリーに再帰的にアイテムを追加する( TreeNodeCollection nodes, List<SongNode> songs )
		{
			foreach( var song in songs )
			{
				// ノードを生成。

				var stg生ファイル名 = Folder.tファイルパスをマクロ付きパスに変換する( song.ScoreFile );
				var imageIndex = ( song.e種別 == SongNode.E種別.BOX ) ? this.nImageIndexを返す( "BOX_Opened" ) : this.nImageIndexを返す( "Node" );
				var node = new TreeNode( song.Title ) {
					ImageIndex = imageIndex,
					SelectedImageIndex = imageIndex,
				};


				// ツリーと対応表にノードを登録。

				nodes.Add( node );
				this.dicノードSong対応表.Add( node, song );


				// ノードに対応する Song が BOX であれば、再帰する。

				if( song.e種別 == SongNode.E種別.BOX && song.childlen != null )
				{
					this.tツリーに再帰的にアイテムを追加する( node.Nodes, song.childlen );
					node.Expand();
				}
			}
		}
		void tノードと子ノードを再帰的にツリーと対応表から除去する( TreeNodeCollection parent, TreeNode node )
		{
			// どちらかが null の場合は何もしない。

			if( parent == null || node == null )
				return;

			
			// 子ノードがあれば先に再帰的に除去する。

			if( node.Nodes != null && node.Nodes.Count > 0 )
			{
				while( node.Nodes.Count > 0 )	// node.Nodes の内容を変えるので foreach は使えない。
					this.tノードと子ノードを再帰的にツリーと対応表から除去する( node.Nodes, node.Nodes[ 0 ] );
			}


			// ノード自身を除去(1) 対応表から削除する。

			if( this.dicノードSong対応表.ContainsKey( node ) )
				this.dicノードSong対応表.Remove( node );


			// ノード自身を除去(2) ツリーから削除する。

			parent.Remove( node );
		}
		void t現在の選択曲から挿入すべき親ノード集合と位置を返す( out TreeNodeCollection parentNodes, out int n挿入位置 )
		{
			parentNodes = null;
			n挿入位置 = 0;

			if( this.treeView曲ツリー.SelectedNode == null )
			{
				// (A) 選択されてない場合 → 最後のSongListの末尾から挿入開始。

				parentNodes = this.treeView曲ツリー.Nodes[ this.treeView曲ツリー.Nodes.Count - 1 ].Nodes;
				n挿入位置 = parentNodes.Count;
			}

			else if( this.treeView曲ツリー.SelectedNode.Parent == null )
			{
				// (B) SongListノードが選択されている → そのSongListノードの末尾から挿入開始。

				parentNodes = this.treeView曲ツリー.SelectedNode.Nodes;
				n挿入位置 = parentNodes.Count;
			}

			else
			{
				// (C) 曲ノードが選択されている → その曲の次行から挿入開始。

				parentNodes = this.treeView曲ツリー.SelectedNode.Parent.Nodes;
				n挿入位置 = parentNodes.IndexOf( this.treeView曲ツリー.SelectedNode ) + 1;
			}
		}

		private void treeView曲ツリー_AfterSelect( object sender, TreeViewEventArgs e )
		{
			this.tGUIのEnableを設定する();
		}
		private void treeView曲ツリー_AfterExpand( object sender, TreeViewEventArgs e )
		{
			// ノードアイコンを変更する。

			if( this.bSongListノードである( e.Node ) )
			{
				e.Node.ImageIndex =
					e.Node.SelectedImageIndex = this.nImageIndexを返す( "SongList_Opened" );
			}
			else if( this.dicノードSong対応表[ e.Node ].e種別 == SongNode.E種別.BOX )
			{
				e.Node.ImageIndex =
					e.Node.SelectedImageIndex = this.nImageIndexを返す( "BOX_Opened" );
			}
			else
			{
				e.Node.ImageIndex =
					e.Node.SelectedImageIndex = this.nImageIndexを返す( "Node" );
			}
		}
		private void treeView曲ツリー_AfterCollapse( object sender, TreeViewEventArgs e )
		{
			// ノードアイコンを変更する。

			if( this.bSongListノードである( e.Node ) )
			{
				e.Node.ImageIndex =
					e.Node.SelectedImageIndex = this.nImageIndexを返す( "SongList_Closed" );
			}
			else if( this.dicノードSong対応表[ e.Node ].e種別 == SongNode.E種別.BOX )
			{
				e.Node.ImageIndex =
					e.Node.SelectedImageIndex = this.nImageIndexを返す( "BOX_Closed" );
			}
			else
			{
				e.Node.ImageIndex =
					e.Node.SelectedImageIndex = this.nImageIndexを返す( "Node" );
			}
		}
		private void treeView曲ツリー_MouseDoubleClick( object sender, MouseEventArgs e )
		{
			TreeNode node = this.treeView曲ツリー.SelectedNode;

			if( this.bSongListノードである( node ) )
				return;		// SongList ノードでは何もしない。

			var song = this.dicノードSong対応表[ node ];


			// Song編集ダイアログを表示する。

			var dialog = new C曲情報の編集ウィンドウ( this );
			dialog.textBoxノード種別.Text = ( song.e種別 == SongNode.E種別.BOX ) ? "BOX" : "Song";
			dialog.textBox曲名.Text = song.Title;
			dialog.textBox説明文.Text = song.Description;
			dialog.textBoxファイルパス.Text = Folder.tファイルパスをマクロ付きパスに変換する( song.ScoreFile );
			dialog.textBoxファイルパス.Enabled = false;

			var dr = dialog.ShowDialog( this );
			
			if( dr == DialogResult.Cancel )
				return;		// キャンセル


			// ダイアログの内容にあわせて Song の情報を更新する。

			song.Title = dialog.textBox曲名.Text;
			song.Description = dialog.textBox説明文.Text;


			// ノードの情報を更新する。

			node.Text = song.Title;


			// 再描画。

			this.Refresh();
		}
		private void treeView曲ツリー_DragEnter( object sender, DragEventArgs e )
		{
			// 送られてくるデータの型から、受入判定結果を e.Effect に格納する。

			if( e.Data.GetDataPresent( DataFormats.FileDrop ) )
				e.Effect = DragDropEffects.Copy;					// ファイルはOK
			else
				e.Effect = DragDropEffects.None;					// その他はNG
		}
		private void treeView曲ツリー_DragDrop( object sender, DragEventArgs e )
		{
			// フォーマットチェック。

			if( !e.Data.GetDataPresent( DataFormats.FileDrop ) )
				return;		// ファイル以外は無視。


			// ファイルのリストを取得。

			string[] files = (string[]) e.Data.GetData( DataFormats.FileDrop );


			// すべての選択ファイルについて、ツリーと対応表に追加する。

			this.t曲ファイルを追加する( files );
		}
		private void buttonSongListファイルを新規作成_Click( object sender, EventArgs e )
		{
			SaveFileDialog dialog;

			#region [ 保存ダイアログでファイルパスを取得。 ]
			//-----------------
			bool bTopMost控え = this.TopMost;
			this.TopMost = false;

			while( true )	// 正しいファイルパスを得るまで
			{
				dialog = new SaveFileDialog() {
					Title = "SongListファイルの新規作成",
					Filter = "SongList files (*.xml)|*.xml|All files(*.*)|*.*",
					FilterIndex = 1,
					InitialDirectory = Folder.stgユーザ個別フォルダ,
				};

				var dr = dialog.ShowDialog( Global.App.Window );	// ダイアログの表示、終了。
				this.Refresh();					// フォームを再描画してダイアログを完全に消す。

				if( dr != DialogResult.OK || string.IsNullOrEmpty( dialog.FileName ) )
					return;


				// パスをチェック。

				if( !dialog.FileName.Contains( Folder.stgユーザ個別フォルダ ) )
				{
					MessageBox.Show( "ユーザ個別フォルダの外側にはファイルを作成できません。", "警告", MessageBoxButtons.OK );
					continue;
				}
				break;
			}

			this.TopMost = bTopMost控え;
			//-----------------
			#endregion
			#region [ 既に存在しているファイルなら削除する。削除に失敗したらそこまで。]
			//-----------------
			if( File.Exists( dialog.FileName ) )
			{
				try
				{
					File.Delete( dialog.FileName );
				}
				catch( Exception ex )
				{
					Utils.t例外の詳細をログに出力する( ex );
					return;
				}
			}
			//-----------------
			#endregion


			// 空の SongList を作成し、保存する。

			var songList = new SongList();
			songList.t保存する( dialog.FileName );


			// SongList をツリーに追加する。

			this.tSongListファイルを追加する( dialog.FileName );
		}
		private void buttonSongListファイルを追加_Click( object sender, EventArgs e )
		{
			#region [ ファイルを選択。複数可。]
			//-----------------
			bool bTopMost控え = this.TopMost;
			this.TopMost = false;

			var dialog = new OpenFileDialog() {
				Title = "SongListファイルの選択",
				Filter = "SongList files (*.xml)|*.xml|All files(*.*)|*.*",
				FilterIndex = 1,
				InitialDirectory = this.stg最後に開いたフォルダ,
				Multiselect = true,
			};

			var dr = dialog.ShowDialog( Global.App.Window );	// ダイアログの表示、終了。

			this.Refresh();					// フォームを再描画してダイアログを完全に消す。
			this.TopMost = bTopMost控え;

			if( dr != DialogResult.OK || dialog.FileNames.Length == 0 )
				return;

			this.stg最後に開いたフォルダ = Path.GetDirectoryName( Path.GetFullPath( dialog.FileNames[ 0 ] ) );
			//-----------------
			#endregion

			// すべての選択ファイルについて、内容をツリーに追加する。

			foreach( string str生SongListファイル名 in dialog.FileNames )
				this.tSongListファイルを追加する( str生SongListファイル名 );
		}
		private void button曲を追加_Click( object sender, EventArgs e )
		{
			#region [ ファイルを選択。複数可。]
			//-----------------
			bool bTopMost控え = this.TopMost;
			this.TopMost = false;

			var dialog = new OpenFileDialog() {
				Title = "曲の選択",
				Filter = "SSTF files (*.sstf)|*.sstf",
				FilterIndex = 1,
				InitialDirectory = this.stg最後に開いたフォルダ,
				RestoreDirectory = false,
				Multiselect = true,
			};

			var dr = dialog.ShowDialog( Global.App.Window );	// ダイアログの表示、終了。

			this.Refresh();					// フォームを再描画してダイアログを完全に消す。
			this.TopMost = bTopMost控え;

			if( dr != DialogResult.OK || dialog.FileNames.Length == 0 )
				return;

			this.stg最後に開いたフォルダ = Path.GetDirectoryName( Path.GetFullPath( dialog.FileNames[ 0 ] ) );
			//-----------------
			#endregion

			this.t曲ファイルを追加する( dialog.FileNames );
		}
		private void buttonフォルダ内指定して曲を追加_Click( object sender, EventArgs e )
		{
			#region [ フォルダを選択する。]
			//-----------------
			bool bTopMost控え = this.TopMost;
			this.TopMost = false;

			var dialog = new FolderBrowserDialog() {
				Description = "曲を検索するフォルダを選択して下さい。",
				RootFolder = Environment.SpecialFolder.MyComputer,
				SelectedPath = this.stg最後に開いたフォルダ,
				ShowNewFolderButton = false,
			};

			var dr = dialog.ShowDialog( Global.App.Window );	// ダイアログの表示、終了。

			this.Refresh();					// フォームを再描画してダイアログを完全に消す。
			this.TopMost = bTopMost控え;

			if( dr != DialogResult.OK || string.IsNullOrEmpty( dialog.SelectedPath ) )
				return;

			this.stg最後に開いたフォルダ = dialog.SelectedPath;
			//-----------------
			#endregion


			// 選択されたフォルダとその子フォルダから曲を検索する。

			string[] files = Directory.GetFiles( dialog.SelectedPath, "*.sstf", SearchOption.AllDirectories );


			// すべての選択ファイルについて、ツリーと対応表に追加する。

			this.t曲ファイルを追加する( files );
		}
		private void buttonSongList上へ_Click( object sender, EventArgs e )
		{
			TreeNode node = this.treeView曲ツリー.SelectedNode;
			TreeNodeCollection parentNodes = ( node.Parent == null ) ? this.treeView曲ツリー.Nodes : node.Parent.Nodes;

			int n移動元番号 = parentNodes.IndexOf( node );
			int n移動先番号 = n移動元番号 - 1;

			if( n移動先番号 < 0 )
				return;


			// ツリー内で移動

			TreeNode tmpNode = parentNodes[ n移動元番号 ];
			parentNodes.RemoveAt( n移動元番号 );
			parentNodes.Insert( n移動先番号, tmpNode );

			this.treeView曲ツリー.SelectedNode = parentNodes[ n移動先番号 ];
			this.treeView曲ツリー.Select();
		}
		private void buttonSongList下へ_Click( object sender, EventArgs e )
		{
			TreeNode node = this.treeView曲ツリー.SelectedNode;
			TreeNodeCollection parentNodes = ( node.Parent == null ) ? this.treeView曲ツリー.Nodes : node.Parent.Nodes;

			int n移動元番号 = parentNodes.IndexOf( node );
			int n移動先番号 = n移動元番号 + 1;

			if( n移動先番号 >= parentNodes.Count )
				return;


			// GUIツリー内での移動

			TreeNode tmpNode = parentNodes[ n移動元番号 ];
			parentNodes.RemoveAt( n移動元番号 );
			parentNodes.Insert( n移動先番号, tmpNode );

			this.treeView曲ツリー.SelectedNode = parentNodes[ n移動先番号 ];
			this.treeView曲ツリー.Select();
		}
		private void button選択項目をリストから除去_Click( object sender, EventArgs e )
		{
			var node削除対象 = this.treeView曲ツリー.SelectedNode;
			this.tノードと子ノードを再帰的にツリーと対応表から除去する( this.treeView曲ツリー.Nodes, node削除対象 );

			this.tGUIのEnableを設定する();
		}
		private void buttonBOXを作成_Click( object sender, EventArgs e )
		{
			#region [ Song編集ダイアログを表示し、情報を得る。]
			//-----------------
			var dialog = new C曲情報の編集ウィンドウ( this );
			dialog.textBoxノード種別.Text = "BOX";
			dialog.textBoxファイルパス.Enabled = false;

			var dr = dialog.ShowDialog();
			if( dr == DialogResult.Cancel )
				return;		// キャンセル
			//-----------------
			#endregion

			#region [ BOX 用の Song インスタンスを作成。]
			//-----------------
			var song = new SongNode() {
				Title = dialog.textBox曲名.Text,
				Description = dialog.textBox説明文.Text,
				ScoreFile = "",
				e種別 = SongNode.E種別.BOX,
				childlen = new List<SongNode>(),	// .xml から読み込んだときのデフォルト値は、null ではなく空Listである。ここではそれに合わせる。
			};
			//-----------------
			#endregion

			#region [ BOX をツリーに追加。]
			//-----------------

			// 挿入位置を取得。

			TreeNodeCollection parentNodes = null;
			int n挿入位置 = 0;
			this.t現在の選択曲から挿入すべき親ノード集合と位置を返す( out parentNodes, out n挿入位置 );


			// BOXをツリーに追加。

			this.treeView曲ツリー.BeginUpdate();

			var node = new TreeNode( song.Title ) {
				ImageIndex = this.nImageIndexを返す( "BOX_Opened" ),
				SelectedImageIndex = this.nImageIndexを返す( "BOX_Opened" ),
			};
			parentNodes.Insert( n挿入位置, node );

			this.treeView曲ツリー.EndUpdate();

			node.Expand();
			this.treeView曲ツリー.SelectedNode = node;
			this.treeView曲ツリー.Select();
			//-----------------
			#endregion

			#region [ BOX を対応表に追加する。]
			//-----------------
			this.dicノードSong対応表.Add( node, song );
			//-----------------
			#endregion
		}
		private void button選択項目をBOXに入れる_Click( object sender, EventArgs e )
		{
			TreeNode node = this.treeView曲ツリー.SelectedNode;
			TreeNodeCollection parentNodes = ( node.Parent == null ) ? this.treeView曲ツリー.Nodes : node.Parent.Nodes;
			int nodeIndex = parentNodes.IndexOf( node );
			int boxIndex = nodeIndex - 1;

			if( boxIndex < 0 || this.bSongListノードである( parentNodes[ boxIndex ] ) || this.dicノードSong対応表[ parentNodes[ boxIndex ] ].e種別 != SongNode.E種別.BOX )	// 念のため確認。
				return;


			// ツリー内で移動

			parentNodes.RemoveAt( nodeIndex );
			parentNodes[ boxIndex ].Nodes.Add( node );

			this.treeView曲ツリー.SelectedNode = node;
			this.treeView曲ツリー.Select();
		}
		private void button選択項目をBOXから出す_Click( object sender, EventArgs e )
		{
			TreeNode node = this.treeView曲ツリー.SelectedNode;
			TreeNode boxNode = node.Parent;
			TreeNodeCollection boxNodes = boxNode.Nodes;
			TreeNodeCollection parentNodes = boxNode.Parent.Nodes;
			int boxIndex = parentNodes.IndexOf( boxNode );


			// ツリー内で移動

			boxNodes.Remove( node );
			parentNodes.Insert( boxIndex + 1, node );

			this.treeView曲ツリー.SelectedNode = node;
			this.treeView曲ツリー.Select();
		}
	}
}
