﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Text;
using System.Threading.Tasks;
using System.IO;
using System.Windows.Forms;
using FDK;

namespace StrokeStyleT
{
	/// <summary>
	/// <para>曲リスト。SongList.xml の単位。</para>
	/// </summary>
	[Serializable]
	public class SongList : ISerializableXML		// XML化対象クラスは public であり、StrokeStyleT.ISerializableXML を実装すること。
	{
		public List<SongNode> Songs = new List<SongNode>();

		internal static SongList t読み込む( string strFileName )
		{
			#region [ XMLファイルを読み込む。]
			//-----------------
			SongList songList = null;
			try
			{
				songList = CXMLFile<SongList>.t読み込む( strFileName );
			}
			catch( FileNotFoundException )
			{
				songList = new SongList();
			}
			catch( Exception e )
			{
				Utils.t例外の詳細をログに出力する( e );
				songList = new SongList();
			}
			//-----------------
			#endregion

			#region [ 各 Song のパス文字列にマクロが含まれていれば展開する。]
			//-----------------
			for( int i = 0; i < songList.Songs.Count; i++ )
			{
				if( !string.IsNullOrEmpty( songList.Songs[ i ].ScoreFile ) )
					Folder.tファイルパス内のマクロを展開する( ref songList.Songs[ i ].ScoreFile );
			}
			//-----------------
			#endregion

			SongList.tSongs要素を再帰的に標準化する( songList.Songs );

			return songList;
		}
		internal void t保存する( string strFileName )
		{
			#region [ Songs 要素のシステム/ユーザフォルダパスをマクロに変換する。]
			//-----------------
			for( int i = 0; i < this.Songs.Count; i++ )
			{
				if( !string.IsNullOrEmpty( this.Songs[ i ].ScoreFile ) )
					Folder.tファイルパスをマクロ付きパスに変換する( ref this.Songs[ i ].ScoreFile );
			}
			//-----------------
			#endregion

			#region [ 保存する。]
			//-----------------
			try
			{
				CXMLFile<SongList>.t保存する( this, strFileName ); 
			}
			catch( Exception e )
			{
				MessageBox.Show( "ファイルの保存に失敗しました。[{0}]\n--------\n" + e.ToString(), Folder.tファイルパスをマクロ付きパスに変換する( strFileName ) );
			}
			//-----------------
			#endregion

			#region [ まだ使うので Songs 要素のシステム/ユーザフォルダパスのマクロを元通りに展開する。]
			//-----------------
			for( int i = 0; i < this.Songs.Count; i++ )
			{
				if( !string.IsNullOrEmpty( this.Songs[ i ].ScoreFile ) )
					Folder.tファイルパス内のマクロを展開する( ref this.Songs[ i ].ScoreFile );
			}
			//-----------------
			#endregion
		}

		protected static void tSongs要素を再帰的に標準化する( List<SongNode> songs )
		{
			// 各 Songs について、パラメータを標準化する。
			foreach( SongNode song in songs )
			{
				#region [ Title ]
				//-----------------
				if( string.IsNullOrEmpty( song.Title ) )
					song.Title = "(no title)";
				//-----------------
				#endregion
				#region [ DataFile ]
				//-----------------
				if( string.IsNullOrEmpty( song.ScoreFile ) )
				{
					song.ScoreFile = "";
					continue;
				}

				try
				{
					song.ScoreFile = Folder.tパスの正当性を確認のうえ絶対パスに変換して返す( song.ScoreFile.Trim(), Folder.stgユーザ個別フォルダ );

					if( !File.Exists( song.ScoreFile ) )	// ※ path がフォルダでも false が返る。
						throw new FileNotFoundException();
				}
				catch
				{
					song.ScoreFile = "";
					continue;
				}
				//-----------------
				#endregion

				// BOX であれば再帰的に子 Songs の標準化を行う。
				if( song.e種別 == SongNode.E種別.BOX && song.childlen != null )
					tSongs要素を再帰的に標準化する( song.childlen );
			}

			// Songs 要素のうち、DataFile が無効化されている（空文字列である）アイテムをすべて削除する。
			songs.RemoveAll( ( song ) => { return string.IsNullOrEmpty( song.ScoreFile ); } );
		}

		// ISerializableXML の実装

		public void t規定の初期化()
		{
		}
	}
}
