﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Text;
using System.Threading.Tasks;
using System.Xml;
using System.IO;

namespace StrokeStyleT
{
	/// <summary>
	/// 全ユーザで共通のシステム設定。
	/// </summary>
	class Config : IDisposable
	{
		public int nSoundバッファ長ms = 20;
		public int nSound更新間隔ms = 5;
		public PadAssign PadAssign = new PadAssign();

		#region [ XML ]
		//-----------------
		public void Load( string stgConfigファイルパスマクロ無し )
		{
			if( !File.Exists( stgConfigファイルパスマクロ無し ) )
				return;

			var reader = new XmlTextReader( new StreamReader( stgConfigファイルパスマクロ無し ) );

			try
			{
				string attrib = null;

				while( reader.Read() )
				{
					if( reader.NodeType == XmlNodeType.EndElement && reader.Name.Equals( "Configuration" ) )
						break;

					if( reader.NodeType == XmlNodeType.Element && !reader.IsEmptyElement )
					{
						switch( reader.Name )
						{
							case "Sound":
								attrib = reader.GetAttribute( "Buffer" );
								this.nSoundバッファ長ms = ( string.IsNullOrEmpty( attrib ) ) ? 0 : int.Parse( attrib );
								attrib = reader.GetAttribute( "UpdatePeriod" );
								this.nSound更新間隔ms = ( string.IsNullOrEmpty( attrib ) ) ? 0 : int.Parse( attrib );
								break;

							case "PadAssign":
								this.PadAssign.Load( reader );
								break;
						}
					}
				}
			}
			finally
			{
				reader.Close();
			}
		}
		public void Save( string stgConfigファイルパスマクロ無し )
		{
			var writer = new XmlTextWriter( new StreamWriter( stgConfigファイルパスマクロ無し ) );

			try
			{
				writer.Formatting = Formatting.Indented;

				writer.WriteStartDocument();
				writer.WriteStartElement( null, "Configuration", null );		// <Configuration>

				#region [ <Sound> ]
				//-----------------
				writer.WriteStartElement( null, "Sound", null );
				writer.WriteAttributeString( "Buffer", this.nSoundバッファ長ms.ToString() );
				writer.WriteAttributeString( "UpdatePeriod", this.nSound更新間隔ms.ToString() );
				writer.WriteEndElement();
				//-----------------
				#endregion

				#region [ <PadAssign> ]
				//-----------------
				this.PadAssign.Save( writer );
				//-----------------
				#endregion

				writer.WriteEndElement();										// </Configuration>
				writer.WriteEndDocument();
			}
			finally
			{
				writer.Close();
			}
		}
		//-----------------
		#endregion

		#region [ IDisposable 実装 ]
		//-----------------
		public void Dispose()
		{
			if( this.PadAssign != null )
				this.PadAssign.Dispose();
		}
		//-----------------
		#endregion
	}
}
