﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Text;
using System.Threading.Tasks;
using System.IO;
using System.Drawing;
using System.Drawing.Imaging;
using FDK;

namespace StrokeStyleT
{
	class CActドラムの矢印 : CActivity
	{
		protected override void Onデバイスリソースの作成()
		{
			Global.tデバイスをロックして処理を行う( ( hDevice ) => {
				this.tx上矢印 = new CTexture( hDevice, Path.Combine( Global.Folders.stgシステムフォルダパス, @"Images\Arrow Up.png" ) );
			} );
		}
		protected override void Onデバイスリソースの解放()
		{
			if( this.tx上矢印 != null )
				this.tx上矢印.Dispose();
		}

		protected override int On進行()
		{
			if( this.b初めての進行 )
			{
				this.ct移動 = new CCounter[ n残像数 + 1 ];
				for( int i = 0; i <= n残像数; i++ )	// i=0は本体
				{
					this.ct移動[ i ] = new CCounter( 0, n移動時間ms * 2, 1 );
					this.ct移動[ i ].n現在の値 = -n残像遅延ms * i;
				}
				
				this.b初めての進行 = false;
			}

			for( int i = 0; i <= n残像数; i++ )	// i=0は本体
				this.ct移動[ i ].t進行Loop();

			return (int) E進行結果.継続;
		}
		protected override void On描画( IntPtr hDevice )
		{
			if( this.tx上矢印 == null || this.b初めての進行 )
				return;

			for( int n = 0; n < 4; n++ )	// 上下左右の順。
			{
				for( int i = n残像数; i >= 0; i-- )		// i=0は本体
				{
					int dt = Math.Max( this.ct移動[ i ].n現在の値, 0 );
					float dd = n移動量px * Math.Min( dt, n移動時間ms ) / (float) n移動時間ms;
					PointF pt3D = Theme.t2DXYto3DXY( pt開始座標[ n ] );

					Matrix mat = Matrix.Identity;
					switch( n )
					{
						case 0:	// 上
							mat *= Matrix.RotationZ( (float) Utils.DegreeToRadian( 0.0 ) );
							mat *= Matrix.Translation( pt3D.X, pt3D.Y + dd, 0f );
							break;

						case 1:	// 下
							mat *= Matrix.RotationZ( (float) Utils.DegreeToRadian( 180.0 ) );
							mat *= Matrix.Translation( pt3D.X, pt3D.Y - dd, 0f );
							break;

						case 2:	// 左
							mat *= Matrix.RotationZ( (float) Utils.DegreeToRadian( 90.0 ) );
							mat *= Matrix.Translation( pt3D.X - dd, pt3D.Y, 0f );
							break;

						case 3:	// 右
							mat *= Matrix.RotationZ( (float) Utils.DegreeToRadian( -90.0 ) );
							mat *= Matrix.Translation( pt3D.X + dd, pt3D.Y, 0f );
							break;

					}
					this.tx上矢印.n透明度 = Math.Max( 255 - n透明幅 * i - (int) ( Math.Max( 0, dt - n移動時間ms ) * 255f / n移動時間ms ), 0 );
					this.tx上矢印.t3D描画( hDevice, mat );
				}
			}
		}

		private CTexture tx上矢印;
		private CCounter[] ct移動;

		private readonly Point[] pt開始座標 = new Point[] {
			new Point( 924, 940 ),		// ハイタム（上）
			new Point( 1169, 1031 ),	// フロアタム（下）
			new Point( 833, 1018 ),		// スネア（左）
			new Point( 1072, 940 ),		// ロータム（右）
		};
		private const int n移動量px = 50;
		private const int n移動時間ms = 500;
		private const int n残像数 = 4;
		private const int n残像遅延ms = 200;
		private const int n透明幅 = 60;

	}
}
