/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Alert/AlertSession.cs#16 $
 * $DateTime: 2008/05/14 13:05:12 $
*/
using System;
using System.Collections.Generic;
using System.Text;
using System.Diagnostics;
using System.Drawing;
using System.Windows.Forms;

using Poderosa;
using Poderosa.UI;
using Poderosa.Forms;
using Poderosa.Preferences;
using Poderosa.Commands;
using Poderosa.Plugins;
using Poderosa.Sessions;

using Travis.ORT;
using Sansa.Runtime;

using Bellagio.Environment;
using Bellagio.Data;
using Bellagio.Values;
using Bellagio.Drawing;
using Bellagio.Forms;
using Bellagio.Evaluators;

namespace Bellagio.Alert {

    //A[ǵAVOĩXgPoderosax[X̃ZbVƂē삷B
    //āAAlertDocumentAlertPluginAB̃CX^XƂĂӂ܂
    //ĎƂ뎩̂AlertDocumentDataSubscriberƂē삷邱ƂŎ

    public class AlertSessionSettings {
        public SmartColor backColor;
        public SmartColor evenRowColor;
        public SmartColor oddRowColor;

        public AlertSessionSettings() {
            oddRowColor.Set(Color.White);
            evenRowColor.Set(Color.FromArgb(0xf1, 0xf0, 0xf3));
            backColor.Set(BellagioRoot.FixedPreferences.DefaultBackColor);

        }
    }


    public class AlertContent : BellagioDefaultForm, BellagioListView.IBellagioListViewClient {
        private BellagioListView _listView;
        private AlertSessionSettings _settings;
        private CheckBox _enabledBox;

        public AlertContent(Form owner) {
            FormUtil.AdjustStyleForModelessSizableDialog(this, owner);
            this.Text = "A[g";

            _settings = new AlertSessionSettings();
            _listView = new BellagioListView(this);
            _listView.Dock = DockStyle.Fill;

            _enabledBox = new CheckBox();
            _enabledBox.Text = "Ƀ|bvAbv\(&E)";
            _enabledBox.Dock = DockStyle.Top;
            _enabledBox.CheckedChanged += new EventHandler(OnEnableBoxChanged);
            _enabledBox.Height = 19;

            ReloadPreference();

            BuildColumns();
            this.Controls.Add(_listView);
            this.Controls.Add(_enabledBox);
            this.ClientSize = new Size(400, 200);
            UpdateContent();
        }
        public void ReloadPreference() {
            _enabledBox.Checked = AlertPlugin.Instance.Preference.Enabled;
        }

        protected override void OnFormClosing(FormClosingEventArgs e) {
            base.OnFormClosing(e);
            if(!BellagioPlugin.Instance.PoderosaApplication.IsExitingApplication) {
                e.Cancel = true;
                this.Hide();
            }
        }

        private void OnEnableBoxChanged(object sender, EventArgs args) {
            AlertPlugin.Instance.Preference.Enabled = _enabledBox.Checked;
        }


        private void BuildColumns() {
            _listView.Columns.Clear();

            _listView.AddColumn("", 100, 0, 100);
            _listView.AddColumn("", 150, 0, 200);
            _listView.AddColumn("", 300, 0, 500);
        }

        public void UpdateContent() {
            //TODO VOiƂ̖
            _listView.BeginUpdate();
            _listView.Items.Clear();
            foreach(AlertData ad in AlertPlugin.Instance.Document.Signals) {
                _listView.AddItem(ad);
            }
            _listView.EndUpdate();
        }


        void BellagioListView.IBellagioListViewClient.DrawItemBody(Graphics g, Rectangle r, int[] lefts, ListViewItem item) {
            AlertDocument doc = AlertPlugin.Instance.Document;
            Font font = _listView.Font;
            Brush br = (item.Index % 2)==0? _settings.evenRowColor.B : _settings.oddRowColor.B;
            g.FillRectangle(br, r);
            
            AlertData ad = doc.GetAlertDataAt(item.Index);
            Brush text_br = SystemBrushes.WindowText;
            
            g.DrawString(BTime.FormatHHMM(ad.AlertTime), font, text_br, r.Left+lefts[0], r.Top);
            g.DrawString(ad.Stock.Profile.Name, font, text_br, r.Left+lefts[1], r.Top);
            g.DrawString(ad.SourceCondition.Title, font, text_br, r.Left+lefts[2], r.Top);
        }




        void BellagioListView.IBellagioListViewClient.DrawColumnHeader(Graphics g, Rectangle r, ColumnHeader header) {
        }

        void BellagioListView.IBellagioListViewClient.DrawItemBackground(Graphics g, Rectangle r, ListViewItem item) {
        }

        void BellagioListView.IBellagioListViewClient.OnMouseMoveInListView(MouseEventArgs e) {
        }

        void BellagioListView.IBellagioListViewClient.OnMouseEnterToListView(EventArgs e) {
        }

    }

}
