/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Bookmark/BookmarkPlugin.cs#3 $
 * $DateTime: 2008/05/14 13:05:12 $
 */
using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using System.Diagnostics;
using System.Drawing;

using Poderosa;
using Poderosa.Plugins;
using Poderosa.Commands;
using Poderosa.Forms;
using Poderosa.Sessions;
using Poderosa.View;
using Poderosa.Preferences;

using Sansa.Runtime;
using Bellagio.Forms;
using Bellagio.Data;
using Bellagio.Values;
using Bellagio.Environment;

[assembly: PluginDeclaration(typeof(Bellagio.Bookmark.BookmarkPlugin))]

namespace Bellagio.Bookmark {
    [PluginInfo(ID=BookmarkPlugin.PLUGIN_ID, Version=BellagioVersionInfo.PLUGIN_VERSION, Author=BellagioVersionInfo.AUTHOR_NAME, Dependencies=BellagioPlugin.PLUGIN_ID)]
    public class BookmarkPlugin : PluginBase {
        public const string PLUGIN_ID = "jp.co.lagarto.tactico.bookmark";
        private static BookmarkPlugin _instance;

        private IGeneralCommand _openBookmarkPaneCommand;

        public override void InitializePlugin(IPoderosaWorld poderosa) {
            base.InitializePlugin(poderosa);

            _instance = this;

            ICoreServices cs = (ICoreServices)poderosa.GetAdapter(typeof(ICoreServices));
            ICommandCategory cat = cs.CommandManager.CommandCategories.Dialogs;
            _openBookmarkPaneCommand = new GeneralCommandImpl("tactico.bookmark.openBookmark", "ubN}[N", cat, new ExecuteDelegate(OpenBookmark), null);

            cs.CommandManager.Register(_openBookmarkPaneCommand);

        }
        public static BookmarkPlugin Instance {
            get {
                return _instance;
            }
        }

        public IGeneralCommand OpenBookamrkCommand {
            get {
                return _openBookmarkPaneCommand;
            }
        }

        public override void TerminatePlugin() {
            base.TerminatePlugin();
        }

        private static BookmarkPane _bookmarkPane;
        private static CommandResult OpenBookmark(ICommandTarget target) {
            IPoderosaForm f = (IPoderosaForm)target.GetAdapter(typeof(IPoderosaForm));
            if(_bookmarkPane==null || _bookmarkPane.IsDisposed) 
                _bookmarkPane = new BookmarkPane();
            FormUtil.AdjustStyleForModelessSizableDialog(_bookmarkPane, f.AsForm());

            _bookmarkPane.Show();
            _bookmarkPane.Activate();
            return CommandResult.Succeeded;
        }

    }
}
