/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Chart/ChartPlugin.cs#11 $
 * $DateTime: 2008/05/14 13:05:12 $
 * 
 * `[gƔ̕\R|[lg
 */

using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using System.Diagnostics;

using Poderosa;
using Poderosa.Plugins;
using Poderosa.Commands;
using Poderosa.Forms;
using Poderosa.Sessions;
using Poderosa.View;
using Poderosa.Preferences;

using Sansa.Runtime;
using Bellagio.Forms;
using Bellagio.Environment;
using Bellagio.Values;
using Bellagio.Data;

[assembly: PluginDeclaration(typeof(Bellagio.Chart.ChartPlugin))]

namespace Bellagio.Chart {
    [PluginInfo(ID=ChartPlugin.PLUGIN_ID, Version=BellagioVersionInfo.PLUGIN_VERSION, Author=BellagioVersionInfo.AUTHOR_NAME, Dependencies=BellagioPlugin.PLUGIN_ID+";org.poderosa.optiondialog")]
    public class ChartPlugin : PluginBase {
        public const string PLUGIN_ID = "jp.co.lagarto.tactico.chart";
        private static ChartPlugin _instance;

        private ChartCommands _commands;
        //private ChartOptionPanel _chartOptionPanel;

        public override void InitializePlugin(IPoderosaWorld poderosa) {
            base.InitializePlugin(poderosa);
            _instance = this;

            _commands = new ChartCommands();
            ICoreServices cs = (ICoreServices)poderosa.GetAdapter(typeof(ICoreServices));

            //j[o^
            PoderosaMenuGroupImpl chart_conf = new PoderosaMenuGroupImpl(new ChartPreferenceDialogMenu());
            poderosa.PluginManager.FindExtensionPoint("org.poderosa.menu.tool").RegisterExtension(chart_conf);

            //IvVpl
            IExtensionPoint opt_panel = poderosa.PluginManager.FindExtensionPoint("org.poderosa.optionpanel");
            opt_panel.RegisterExtension(new ChartOptionPanelExtension());
            if(BellagioVersionInfo.EDITION==BellagioEditions.HatchukunTX) {
                opt_panel.RegisterExtension(new ItaPriceOptionPanelExtension());
            }
            opt_panel.RegisterExtension(new MouseKBOptionPanelExtension());

            _commands.Register(cs.CommandManager);
        }

        public ChartCommands ChartCommands {
            get {
                return _commands;
            }
        }

        public static ChartPlugin Instance {
            get {
                return _instance;
            }
        }
    }

    public class ChartPreferenceDialogMenu : IPoderosaMenuFolder {
        private class Group : PoderosaMenuGroupImpl {
            private bool _isStatic;
            public Group(bool isStatic) {
                _isStatic = isStatic;
            }

            public override bool ShowSeparator {
                get {
                    return !_isStatic;
                }
            }
            public override bool IsVolatileContent {
                get {
                    return true;
                }
            }
            public override IPoderosaMenu[] ChildMenus {
                get {
                    List<IPoderosaMenu> mg = new List<IPoderosaMenu>();
                    if(_isStatic) {
                        foreach(ChartSchema sc in CollectStaticChartSchema())
                            mg.Add(CreateMenuItem(sc));
                    }
                    else {
                        foreach(ChartSchema sc in CollectRealTimeChartSchema())
                            mg.Add(CreateMenuItem(sc));
                    }
                    return mg.ToArray();
                }
            }
            private IPoderosaMenu CreateMenuItem(ChartSchema sc) {
                /*
                string t = _isStatic?
                    String.Format("{0}(&{1})", sc.ChartUnitName, UnitNameToAlphabet(sc.ChartUnitName)) :
                    String.Format("{0}{1}(&{2})", sc.ChartScale==1? "" : sc.ChartScale.ToString(), sc.ChartUnitName, sc.ChartScale.ToString());
                */
                return new PoderosaMenuItemImpl(new ChartPreferenceDialogCommand(sc.FullID), sc.description.ParseMandatoryString());
            }
            private static List<ChartSchema> CollectStaticChartSchema() {
                List<ChartSchema> sc = new List<ChartSchema>();
                BellagioRoot.SchemaRoot.CollectStaticChartSchema(sc);
                return sc;
            }
            private static List<ChartSchema> CollectRealTimeChartSchema() {
                List<ChartSchema> sc = new List<ChartSchema>();
                BellagioRoot.SchemaRoot.CollectRealTimeChartSchema(sc);
                return sc;
            }
            private static char UnitNameToAlphabet(string cn) {
                if(cn=="") return 'D';
                else if(cn=="T") return 'W';
                else if(cn=="") return 'M';
                else return ' '; //TODO EnumقX[Y
            }
        }

        //Static`[gpAA^C`[gpłQނ̃O[v
        private Group _forStatic;
        private Group _forRealtime;

        public ChartPreferenceDialogMenu() {
            _forStatic = new Group(true);
            _forRealtime = new Group(false);
        }

        public IPoderosaMenuGroup[] ChildGroups {
            get {
                return new IPoderosaMenuGroup[] { _forStatic, _forRealtime };
            }
        }

        public string Text {
            get {
                return "`[gݒ(&C)";
            }
        }

        public bool IsEnabled(ICommandTarget target) {
            return true;
        }

        public bool IsChecked(ICommandTarget target) {
            return false;
        }

        public IAdaptable GetAdapter(Type adapter) {
            return BUtil.DefaultGetAdapter(this, adapter);
        }
    }

    public class ChartPreferenceDialogCommand : PoderosaCommandImpl {
        private string _chartSchemaName;
        public ChartPreferenceDialogCommand(string schemaName) {
            _chartSchemaName = schemaName;
        }
        public override CommandResult InternalExecute(ICommandTarget target, params IAdaptable[] args) {
            ChartSchema sc = BellagioRoot.SchemaRoot.FindStaticChartSchema(_chartSchemaName);
            if(sc==null) sc = BellagioRoot.SchemaRoot.FindRealTimeChartSchema(_chartSchemaName);
            Debug.Assert(sc!=null);

            MultipleIndicatorEditor dlg = new MultipleIndicatorEditor(sc, BellagioRoot.FixedPreferences.Chart.MultipleIndicatorEditorSettings);
            dlg.ShowDialog();
            dlg.Dispose();
            return CommandResult.Succeeded;
        }
    }

}
