/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Chart/ChartSchema.cs#16 $
 * $DateTime: 2008/05/14 13:05:12 $
 */
using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using System.Diagnostics;
using System.Windows.Forms;

using Travis.ORT;
using Travis.Collections;

using Bellagio.Values;
using Bellagio.Environment;
using Bellagio.Script;
using Poderosa.Util;

#if UNITTEST
using System.IO;
using Bellagio.Chart;
using NUnit.Framework;
#endif

namespace Bellagio.Chart {
    public class IndicatorDefinition : ExtensionKitItem {
        public class Element : OriginReportableObject {
            public ORText id; //ꂾoptional
            public ORText expression;     //]S
            public ORText forward;        //OɊgׂBł邱
            public ORText label;          //\`xBQƂłBȗIndicatorDefinitioñxɂȂ
            public ORText appearance;     //ftHgappearance
            public ORText adjustFigures;   //̂̂Ƃ̒@w
        }

        public ORText location;
        public ORText parameters;   //p[^`Bȗs
        public ORText defaultArgs;  //ftHg
        public ORText parameterDescription; //̐
        public ORText parameterOwnership; //ҏWꍇɂ͂ǂElementɊ֘AĕҏWׂBȗ͑Sp[^擪ElementɊ֘AÂ̈Ӗ

        public ORText appearance;   //\@BGgP̂Ƃ͂ɏ
        public ORText specialPaint; //ȕ`v
        public ORText label;        //xBQƂłB
        public ORText sharesAppearance; //z̃GgappearanceL邩ǂ
        public ORCollectionMember<Element> element;

        private ParameterListDefinition _parsedParameterDefinition;

        public IndicatorDefinition() {
            element = new ORCollectionMember<Element>();
        }

        private void AvoidWarning() {
            Element e = new Element();
            e.id = e.expression = new ORText();
            parameterDescription = location = parameters = label = defaultArgs = appearance = new ORText();
        }

        public ParameterListDefinition ParsedParameterDefinition {
            get {
                if(_parsedParameterDefinition==null) _parsedParameterDefinition = Expression.ParseParameterListDefinition(this.parameters);
                return _parsedParameterDefinition;
            }
        }
        public Element FindElementByID(string id) {
            foreach(Element e in element)
                if(e.id.ParseMandatoryString()==id) return e;
            return null;
        }
    }

    public class IndicatorSchema : OriginReportableObject {
        public ORText name;
        public ORText id;
        public ORText label;
        public ORText args;
        public ORText appearance;

        private ChartSchema _parent;
        private OscillatorGroupSchema _oscillatorGroup; //BIV[^łnull
        private IndicatorDefinition _indicatorDefinition;
        private Expression[] _parsedArguments;
        //appearancePreferenceBgBPenStyle̕񉻁BsharesAppearancêƂPAłȂƂΉIndicatorDefinitionElementB
        private DynamicPreferenceItemImpl[] _appearancePreferences; 
        //p[^̕tɍsBz͈̒̌ƓAg̃Zbg͂͂߂RuntimeIndicatorƂB
        private IndicatorSchemaParameterInfo[] _parameterInfo;

        private void AvoidWarning() {
            name = label = args = new ORText();
        }

        internal void Load(ChartSchema parent, string id) {
            _parent = parent;
            _indicatorDefinition = BellagioRoot.SchemaRoot.FindChartIndicatorDefinition(parent.Owner, name.ParseMandatoryString()); //name͕K{ALȒ`邱
            if(_indicatorDefinition==null)
                throw new BellagioException(String.Format("`[g`{0}ŎQƂĂwW{1}܂", parent.id.ParseMandatoryString(), name.ParseMandatoryString()));

            if(_indicatorDefinition.element.Count==1 || _indicatorDefinition.sharesAppearance.ParseOptionalBool(false)) {
                //appearanceLꍇ͂indicator̖Oō쐬
                IndicatorDefinition.Element e = _indicatorDefinition.element[0];
                //AppearanceAIndDefappearancȅ
                ORText default_appearance = !this.appearance.IsOmitted? this.appearance : !e.appearance.IsOmitted? e.appearance : _indicatorDefinition.appearance;
                DynamicPreferenceItemImpl app = new DynamicPreferenceItemImpl(parent, id, default_appearance.ParseOptionalString("white"));
                _appearancePreferences = new DynamicPreferenceItemImpl[1] { app };
                BellagioRoot.ExtensionKitPreference.RegisterItem(app);
            }
            else { //łȂΌʂElementƂɍ쐬
                List<DynamicPreferenceItemImpl> apps = new List<DynamicPreferenceItemImpl>();
                string[] appearances = this.appearance.IsOmitted? null : this.appearance.ParseMandatoryString().Split(';');
                int i = 0;
                foreach(IndicatorDefinition.Element e in _indicatorDefinition.element) {
                    string local_appearance = (appearances!=null && i<appearances.Length)? appearances[i] : null;
                    ORText default_appearance = e.appearance.IsOmitted? _indicatorDefinition.appearance : e.appearance;
                    DynamicPreferenceItemImpl app = new DynamicPreferenceItemImpl(parent, id + "." + e.id.ParseMandatoryString(), local_appearance!=null? local_appearance : default_appearance.ParseOptionalString("white"));
                    apps.Add(app);
                    BellagioRoot.ExtensionKitPreference.RegisterItem(app);
                    i++;
                }
                _appearancePreferences = apps.ToArray();
            }

            //Element"L"Ăp[^BLƂElementsɕҏWƂAEBhEɃp[^ҏWAƂƁB
            //Element`ɏ̂̓CWP[^̈AExtensionParameterɂ܂ők̂
            //ƕGȂ̂ňȉłĂ邱ƂB
            //ł́Aa-d@܂Ƃ߂ĂindicatorŎĂp[^ƂIndicatorSchemaParameterInfoB
            // (a) O (IndicatorDefinitionR)
            // (b) Description ($unit $lenȂǁBIndicatorDefinitionR)
            // (c) p[^"L"Element͂ǂꂩ
            // (d) p[^̒l (LiteralExpressionParameterExpressionB҂̏ꍇPreferenceƘA)

            List<IndicatorSchemaParameterInfo> param_info = new List<IndicatorSchemaParameterInfo>();
            ParameterListDefinition parameter_definitions = _indicatorDefinition.ParsedParameterDefinition;
            ORText parameter_description_text = _indicatorDefinition.parameterDescription;
            string[] parameter_descriptions = parameter_description_text.IsOmitted? new string[0] : parameter_description_text.ParseMandatoryString().Split(',');
            if(parameter_descriptions.Length!=parameter_definitions.Count)
                throw new BellagioException(ORText.FormatMulformedElementMessage(parameter_description_text, "parameterDescription"));
            Expression[] arguments = this.args.IsOmitted? new Expression[0] : Expression.ParseExpressionList(this.args);
            if(arguments.Length!=parameter_definitions.Count)
                throw new BellagioException(ORText.FormatMulformedElementMessage(args, "args"));
            string[] parameter_ownership = _indicatorDefinition.parameterOwnership.IsOmitted? null : _indicatorDefinition.parameterOwnership.ParseMandatoryString().Split(',');
            if(parameter_ownership!=null && parameter_ownership.Length!=parameter_definitions.Count)
                throw new BellagioException(ORText.FormatMulformedElementMessage(_indicatorDefinition.parameterOwnership, "parameterOwnership"));
            
            for(int i=0; i<parameter_definitions.Count; i++) {
                string arg_name = parameter_definitions.NameAt(i);
                ParameterExpression pex = arguments[i] as ParameterExpression;
                LiteralNumberExpression lex = arguments[i] as LiteralNumberExpression;
                Debug.Assert(pex!=null || lex!=null); //ǂɂ͒l邱
                IndicatorSchemaParameterInfo ispi = new IndicatorSchemaParameterInfo(
                    i, 
                    parameter_ownership==null? _indicatorDefinition.element[0] : _indicatorDefinition.FindElementByID(parameter_ownership[i]),
                    arg_name, parameter_descriptions[i],
                    pex!=null? _parent.FullID+"."+pex.Symbol : null,
                    lex!=null? lex.Value : null);
                param_info.Add(ispi);
            }
            _parameterInfo = param_info.ToArray();
        }

        public void SetOscillatorGroup(OscillatorGroupSchema og) {
            _oscillatorGroup = og;
        }
        
        public OscillatorGroupSchema OscillatorGroup {
            get {
                return _oscillatorGroup;
            }
        }
        public DynamicPreferenceItemImpl[] AppearancePreferences {
            get {
                return _appearancePreferences;
            }
        }
        internal Expression[] ParsedArguments {
            get {
                if(_parsedArguments==null) {
                    ORText raw_arguments = this.args.IsOmitted? _indicatorDefinition.defaultArgs : this.args; //IndicatorSchemâ̂AȗĂDefinition̂
                    _parsedArguments = raw_arguments.IsOmitted? new Expression[0] : Expression.ParseExpressionList(raw_arguments);
                }
                return _parsedArguments;
            }
        }
        internal IndicatorSchemaParameterInfo[] ParemeterInfo {
            get {
                return _parameterInfo; //x쐬Ȃ̂null̏ꍇ
            }
        }
        //w肳ꂽElementɑΉĕҏWׂParameterInfoԂB
        internal IEnumerable<IndicatorSchemaParameterInfo> GetParameterInfoFor(IndicatorDefinition.Element elem) {
            Debug.Assert(_indicatorDefinition.element.Contains(elem));
            if(_indicatorDefinition.sharesAppearance.ParseOptionalBool(false))
                return _parameterInfo; //LĂƂ͑S
            else {
                List<IndicatorSchemaParameterInfo> r = new List<IndicatorSchemaParameterInfo>();
                foreach(IndicatorSchemaParameterInfo pi in _parameterInfo) {
                    if(pi.OwnerElement==elem) r.Add(pi);
                }
                return r;
            }
        }

        public IndicatorDefinition IndicatorDefinition {
            get {
                return _indicatorDefinition;
            }
        }
        public ChartSchema Parent {
            get {
                return _parent;
            }
        }

    }
    //RuntimeIndicatorElementۗLp[^
    //֌Wvf́AindicatorDefinitionparameterDescriptionparameterOwnershipACX^XindicatorargumentB
    public class IndicatorSchemaParameterInfo {
        private int _index; //Ԗڂ̈
        private IndicatorDefinition.Element _associatedIndElemnt;
        private string _localName; //p[^
        private string _description; //parameterDescriptionɏĂ`
        private string _preferenceID; //p[^łƂ͂PreferenceIDBExtensionParameterւ̎QƂɂƃXL[}̃[h̎Qƕێ
        private string _rawValue; //Œl̏ꍇ̒l

        public IndicatorSchemaParameterInfo(int index, IndicatorDefinition.Element assocElem, string localName, string description, string preferenceID, string rawValue) {
            _index = index;
            _associatedIndElemnt = assocElem;
            _localName = localName;
            _description = description;
            _preferenceID = preferenceID;
            _rawValue = rawValue;
        }
        public bool IsAttachedToPreference {
            get {
                return _preferenceID!=null;
            }
        }
        public string PreferenceID {
            get {
                return _preferenceID;
            }
        }
        public IndicatorDefinition.Element OwnerElement {
            get {
                return _associatedIndElemnt;
            }
        }
        public string RawValue {
            get {
                return _rawValue;
            }
        }
        public string RawDescription {
            get {
                return _description;
            }
        }
        public string LocalName {
            get {
                return _localName;
            }
        }
    }


    public class OscillatorGroupSchema : OriginReportableObject {
        public ORText id;
        public ORText description;
        public ORText member;

        private DynamicPreferenceItemImpl _heightInfo;

        private List<IndicatorSchema> _data; //\ƂmF

        public OscillatorGroupSchema() {
        }

        public IEnumerable<IndicatorSchema> Members {
            get {
                return _data;
            }
        }
        public DynamicPreferenceItemImpl HeightInfo {
            get {
                return _heightInfo;
            }
        }

        private void AvoidWarning() {
            description =  new ORText();
        }

        internal void Load(ChartSchema parent) {
            id.ParseMandatoryString();
            _data = new List<IndicatorSchema>();

            string[] member_names = member.ParseMandatoryString().Split(',');
            foreach(string n_ in member_names) {
                string n = n_.Trim();
                IndicatorSchema ii = parent.FindByID(n);
                if(ii==null) throw new BellagioException(String.Format("{0} {1}܂", member.LocationString, n));
                _data.Add(ii);
                ii.SetOscillatorGroup(this);
                //ނ̓IV[^ł邩ǂ́AXL[}̃CX^X쐬Ƀ`FbN
            }

            //W̍ݒ
            _heightInfo = new DynamicPreferenceItemImpl(parent, this.id.ParseMandatoryString() + ".height", "");
            BellagioRoot.ExtensionKitPreference.RegisterItem(_heightInfo);
        }
    }

    public class ChartSchema : ViewSchemaBase {
        public ORText chartsession;
        public ORText shortcutKey;
        public ORCollectionMember<IndicatorSchema> indicator;
        public ORCollectionMember<OscillatorGroupSchema> oscillatorGroup;

        //id񂩂悤
        private Dictionary<string, IndicatorSchema> _idMap;
        private Quote.QuoteUnit _chartUnit; //'','T'Ȃǃ`[g̒P chartsessionӂɌ܂
        private int _chartScale; //Pʂ̑BRł͂RAƂӂB

        private Dictionary<IndicatorSchema, DynamicPreferenceItemImpl> _oscillatorHeightInfoForImplicitGroup; //O[v𖾎ĂȂIV[^O[v
        private DynamicPreferenceItemImpl _volumeHeightInfo; //ݒPreference


        public ChartSchema() {
            indicator = new ORCollectionMember<IndicatorSchema>();
            oscillatorGroup = new ORCollectionMember<OscillatorGroupSchema>();

        }
        internal override void Load(ExtensionKit owner) {
            base.Load(owner);
            _idMap = new Dictionary<string, IndicatorSchema>();
            _oscillatorHeightInfoForImplicitGroup = new Dictionary<IndicatorSchema, DynamicPreferenceItemImpl>();
            
            string s = chartsession.ParseMandatoryString();
            ParseChartUnitAndScale(s);

            foreach(IndicatorSchema ii in indicator) {
                string id_candidate;
                if(!ii.id.IsOmitted) {
                    id_candidate = ii.id.Value;
                    if(_idMap.ContainsKey(id_candidate))
                        throw new BellagioException(String.Format("{0} id {1} Փ˂Ă܂B", ii.id.LocationString, id_candidate));
                }
                else { //O獇
                    int index = 1;
                    do {
                        id_candidate = String.Format("{0}{1}", ii.name.ParseMandatoryString(), index);
                        if(!_idMap.ContainsKey(id_candidate)) break;
                        index++;
                    } while(true);
                }

                ii.Load(this, id_candidate);
                _idMap.Add(id_candidate, ii);

            }

            //p[^Ƃ̖OԂ͋ȂBAppearancePreferenceɏȂႢȂ̂ŁB
            foreach(ExtensionParameter ep in this.parameter) {
                if(_idMap.ContainsKey(ep.id.Value))
                    throw new BellagioException(String.Format("{0} id {1} CWP[^ƏՓ˂Ă܂B", ep.id.LocationString, ep.id.Value));
            }

            foreach(OscillatorGroupSchema gr in oscillatorGroup)
                gr.Load(this);

            //IV[^O[v𖾎ĂȂIV[^ɂẮAPreferenceō쐬Eo^
            Dictionary<string, IndicatorSchema>.Enumerator e = _idMap.GetEnumerator();
            while(e.MoveNext()) {
                IndicatorSchema ii = e.Current.Value;
                if(IndicatorLocation.Parse(ii.IndicatorDefinition.location).IsOscillator && ii.OscillatorGroup==null) {
                    DynamicPreferenceItemImpl hi = new DynamicPreferenceItemImpl(this, e.Current.Key + ".height", "");
                    _oscillatorHeightInfoForImplicitGroup.Add(ii, hi);
                    BellagioRoot.ExtensionKitPreference.RegisterItem(hi);
                }
            }
            //ɏo
            _volumeHeightInfo = new DynamicPreferenceItemImpl(this, "volume.height", "");
            BellagioRoot.ExtensionKitPreference.RegisterItem(_volumeHeightInfo);

            if(BUtil.UnderApplication) {
                string k = shortcutKey.ParseOptionalString(null);
                Keys sk = k==null? Keys.None : WinFormsUtil.ParseKey(k);
                _command = new ChartOpenGeneralCommand( PreferenceUtil.FormatFullID(this), sk, _chartUnit!=Quote.QuoteUnit.Minutely);
            }
        }

        internal override void Unload() {
            //{IɂAppearacnceڂUnloadׂAeExtensionKitUnload_ExtensionPreferenceƂ͐؂藣̂œɉȂĂ悢
            base.Unload();
            
            if(_command!=null) //ExtensionKit[hŝ߃A[h邱ƂA_commandnull
                BellagioPlugin.Instance.CommandManager.Unregister(_command);
        }

        public IndicatorSchema FindByID(string id) {
            IndicatorSchema r;
            return _idMap.TryGetValue(id, out r)? r : null;
        }
        private void AvoidWarning() {
            chartsession = new ORText();
        }
        public Quote.QuoteUnit ChartUnit {
            get {
                return _chartUnit;
            }
        }
        public string ChartUnitName {
            get {
                switch(_chartUnit) {
                    case Quote.QuoteUnit.Daily: return "";
                    case Quote.QuoteUnit.Weekly: return "T";
                    case Quote.QuoteUnit.Monthly: return "";
                    case Quote.QuoteUnit.Minutely: return "";
                    default: return "";
                }
            }
        }
        public int ChartScale {
            get {
                return _chartScale;
            }
        }
        public DynamicPreferenceItemImpl VolumeHeightInfo {
            get {
                return _volumeHeightInfo;
            }
        }
        internal Dictionary<IndicatorSchema, DynamicPreferenceItemImpl> OscillatorHeightInfoForImplicitGroup {
            get {
                return _oscillatorHeightInfoForImplicitGroup;
            }
        }
        private void ParseChartUnitAndScale(string s) {
            _chartScale = 1;

            if(s=="daily")
                _chartUnit = Quote.QuoteUnit.Daily;
            else if(s=="weekly")
                _chartUnit = Quote.QuoteUnit.Weekly;
            else if(s=="monthly")
                _chartUnit = Quote.QuoteUnit.Monthly;
            else if(s=="realtime")
                _chartUnit = Quote.QuoteUnit.Minutely;
            else if(s=="realtime3") {
                _chartUnit = Quote.QuoteUnit.Minutely;
                _chartScale = 3;
            }
            else if(s=="realtime5") {
                _chartUnit = Quote.QuoteUnit.Minutely;
                _chartScale = 5;
            }
            else
                throw new BellagioException(s + " is invalid for chartsession");
            
        }
    }

    public class ChartSchemaCollection : ViewSchemaCollection<ChartSchema> {
        private List<ChartSchema> _data;

        public ChartSchemaCollection() {
            _data = new List<ChartSchema>();
        }
        public ChartSchema Find(string name) {
            foreach(ChartSchema ss in _data)
                if(!ss.id.IsOmitted && ss.id.Value==name) return ss;

            return null;
        }

        public override void Clear() {
            _data.Clear();
        }
        public override int Count {
            get {
                return _data.Count;
            }
        }
        public override void Add(ChartSchema item) {
            _data.Add(item);
        }
        public override ChartSchema this[int index] {
            get {
                return _data[index];
            }
        }
        public override IEnumerator GetEnumerator() {
            return _data.GetEnumerator();
        }
    }

#if UNITTEST
    [TestFixture]
    public class ChartSchemaTest {
        private void LoadConfig(string text) {
            StringReader r = new StringReader(text);
            BellagioRoot.LoadExtensionFileFromStream("Test", r, true);
            r.Close();
        }

        [TestFixtureSetUp]
        public void Setup() {
            try {
                BellagioEnvironmentParam ep = new BellagioEnvironmentParam();
                ep.SetupForUnitTest();
                BellagioRoot.Init(ep);

                //ƒdȂ
                LoadConfig(@"<bellagio-extension id='testkit'>
  <indicatorDef id='ړϐ' location='chart'>
    <parameters>int len</parameters>
    <parameterDescription>$unit $len</parameterDescription>
    <defaultArgs>25</defaultArgs>
    <label>$len$unitړϐ</label>
    <element adjustFigures='price'>
      <expression>ma(len)</expression>
      <appearance>blue 2</appearance>
    </element>
  </indicatorDef>
  <indicatorDef id='' location='os0%s'>
    <parameters>int len</parameters>
    <parameterDescription>$unit $len</parameterDescription>
    <parameterOwnership>KM</parameterOwnership>
    <appearance>red</appearance>
    <element id='KM'>
      <expression>
      let( ( a = close(len).avg() ) (a - close()) / a)
      </expression>
      <label>$len$unitړϘ</label>
    </element>
  </indicatorDef>
  <indicatorDef id='{W[' location='chart' sharesAppearance='true'>
    <parameters>int len</parameters>
    <parameterDescription>$unit $len</parameterDescription>
    <appearance>blue</appearance>
    <defaultArgs>25</defaultArgs>
    <element id='upper' label='$len$unit{W[()'>
      <expression> 0 </expression> <!--֐`͂Ȃ̂expression͂ڂ -->
    </element>
    <element id='lower' label='$len$unit{W[()'>
      <expression> 0 </expression>
    </element>
  </indicatorDef>
  <indicatorDef id='stochastic' location='os100%'>
    <parameters>int k, int d</parameters>
    <parameterDescription>K($unit), D($unit)</parameterDescription>
    <element id='K' label='XgLXK'><expression>
      (close()-min(low(k))) / (max(high(k))-min(low(k)))
    </expression></element>
    <element id='D' label='XgLXD'><expression>
      sum(each(d, lambda((Quote q) q.close()-min(q.low(k))))) / sum(each(d, lambda((Quote q) max(q.high(k))-min(q.low(k)))))
    </expression></element>
  </indicatorDef>
  <staticChart id='testchart' chartsession='daily'>
     <indicator name='ړϐ' args='25'/>
     <indicator name='{W[' args='75'/>
     <indicator name='' args='$ma_length'/>
     <indicator id='deviation2' name='' args='50'/>
     <indicator name='stochastic' args='5,3' appearance='blue;red'/>
     <oscillatorGroup id='o1' member='deviation2'/>
     <parameter id='ma_length' initial='25'/>
  </staticChart>
  </bellagio-extension>");
            }
            catch(Exception ex) {
                Debug.WriteLine(ex.Message);
                Debug.WriteLine(ex.StackTrace);
                throw ex;
            }
        }

        //Oƈ邱ƂmF
        [Test]
        public void SchemaTest() {
            ChartSchema cs = BellagioRoot.SchemaRoot.FindStaticChartSchema("testkit.testchart");
            Assert.IsNotNull(cs);

            Assert.AreEqual(5, cs.indicator.Count);
            //LqɂȂĂ͂
            IndicatorSchema ma = cs.indicator[0];
            Assert.AreSame(ma, cs.FindByID("ړϐ1"));
            IDynamicPreferenceItem ma_appearance = ma.AppearancePreferences[0];
            Assert.AreEqual("blue 2", BellagioRoot.ExtensionKitPreference.InternalGetValue(ma_appearance));
            Assert.AreEqual("testkit.testchart.ړϐ1", PreferenceUtil.FormatFullID(ma_appearance));
            Assert.IsNull(ma.OscillatorGroup);

            IndicatorSchema bol = cs.indicator[1];
            Assert.AreEqual("testkit.testchart.{W[1", PreferenceUtil.FormatFullID(bol.AppearancePreferences[0]));

            IndicatorSchema kairi = cs.indicator[3];
            Assert.AreSame(kairi, cs.FindByID("deviation2"));
            IDynamicPreferenceItem kairi_appearance = kairi.AppearancePreferences[0];
            Assert.AreEqual("red", BellagioRoot.ExtensionKitPreference.InternalGetValue(kairi_appearance));
            Assert.AreEqual("testkit.testchart.deviation2", PreferenceUtil.FormatFullID(kairi_appearance));

            Assert.AreEqual(1, cs.oscillatorGroup.Count);
            Assert.AreSame(cs.oscillatorGroup[0], kairi.OscillatorGroup);

            //XgLXeBbNAppearanceQɂȂ
            IndicatorSchema st = cs.indicator[4];
            Assert.AreEqual("testkit.testchart.stochastic1.K", PreferenceUtil.FormatFullID(st.AppearancePreferences[0]));
            Assert.AreEqual("testkit.testchart.stochastic1.D", PreferenceUtil.FormatFullID(st.AppearancePreferences[1]));
            
            Assert.AreEqual(1, cs.parameter.Count);
            IDynamicPreferenceItem ma_length = cs.parameter[0];
            Assert.AreEqual("25", BellagioRoot.ExtensionKitPreference.InternalGetValue(ma_length));
            Assert.AreEqual("testkit.testchart.ma_length", PreferenceUtil.FormatFullID(ma_length));

            //p[^̂̓r[XL[}Ȃ̂StringWithParameterParser̃eXgɁBƐ肾񂾂
            StringWithParameterParser spp = new StringWithParameterParser(cs);
            Assert.AreEqual("AAA", spp.Parse(new ORText(null, null, 0, 0, "AAA")));
            Assert.AreEqual("A 25 A", spp.Parse(new ORText(null, null, 0, 0, "A $ma_length A")));
            Assert.AreEqual("A 25", spp.Parse(new ORText(null, null, 0, 0, "A $ma_length")));
            Assert.AreEqual("25", spp.Parse(new ORText(null, null, 0, 0, "$ma_length")));
            Assert.AreEqual("25", spp.Parse(new ORText(null, null, 0, 0, "${ma_length}")));
        }


        //XL[}Runtime\zߒRuntimeIndicator, ChartDocumentBase, Evaluator͂߂Ȃ蕪UĂB
        [Test]
        public void ConversionTest() {
            /*
            IndicatorDefinition ma = BellagioRoot.SchemaRoot.FindChartIndicatorDefinition("ړϐ");
            Assert.IsNotNull(ma);
            IndicatorDefinition de = BellagioRoot.SchemaRoot.FindChartIndicatorDefinition("");
            Assert.IsNotNull(de);
            */
            ChartSchema cs = BellagioRoot.SchemaRoot.FindStaticChartSchema("testkit.testchart");
            Assert.IsNotNull(cs);

            StaticChartDocument doc = new StaticChartDocument(Quote.QuoteUnit.Daily);
            doc.ConstructWithSchema(cs);

            Assert.AreEqual(7, doc.Indicators.ElementCount);

            //܂wSȗړϐ IndicatorDef̃ftHg25gĂ͂
            RuntimeIndicatorElement ma = doc.Indicators.GetElementAt(0);
            EvaluatorBuildContextWithArgs args = ma.Container.EvaluatorContext;
            Assert.AreEqual(1, args.ArgCount);
            Assert.AreEqual("25ړϐ", ma.Label); //x⊮Ă邱ƂmF
            Assert.IsFalse(ma.Container.SharesAppearance);
            Assert.AreEqual("2 Blue", ma.BPenStyle.ToString());

            //̓{W[
            RuntimeIndicator bol = doc.Indicators.GetIndicatorAt(1);
            Assert.AreEqual("75{W[()", bol.ElementAt(0).Label);
            Assert.AreEqual("75{W[()", bol.ElementAt(1).Label);
            Assert.IsTrue(bol.SharesAppearance);
            Assert.AreEqual("", FormatHoldingParameterNames(bol.ElementAt(0)));
            Assert.AreEqual("", FormatHoldingParameterNames(bol.ElementAt(1))); //萔Ŏw肵̂Ńp[^̎w݂͑Ȃ
            Assert.AreEqual("Blue", bol.ElementAt(0).BPenStyle.ToString());
            Assert.AreEqual("Blue", bol.ElementAt(1).BPenStyle.ToString()); //appearance`dĂ̂mF
            
            //(p[^)
            RuntimeIndicator dev = doc.Indicators.GetIndicatorAt(2);
            Assert.AreEqual("25ړϘ", dev.ElementAt(0).Label);
            Assert.AreEqual("testkit.testchart.ma_length", FormatHoldingParameterNames(dev.ElementAt(0)));
            //(p[^ڎwł͂Ȃ̂Ńz[hΏۂł͂Ȃ)
            dev = doc.Indicators.GetIndicatorAt(3);
            Assert.AreEqual("50ړϘ", dev.ElementAt(0).Label);
            Assert.AreEqual("", FormatHoldingParameterNames(dev.ElementAt(0)));

            //XgLX(CWP[^̃CX^Xappearancew)
            RuntimeIndicator sto = doc.Indicators.GetIndicatorAt(4);
            Assert.AreEqual("XgLXK", sto.ElementAt(0).Label);
            Assert.AreEqual("XgLXD", sto.ElementAt(1).Label);
            Assert.AreEqual("Blue", sto.ElementAt(0).BPenStyle.ToString());
            Assert.AreEqual("Red", sto.ElementAt(1).BPenStyle.ToString());
        }

        private static string FormatHoldingParameterNames(RuntimeIndicatorElement ie) {
            StringBuilder bld = new StringBuilder();
            foreach(IndicatorSchemaParameterInfo pi in ie.Container.SourceSchema.GetParameterInfoFor(ie.SourceSchema)) {
                if(pi.IsAttachedToPreference) {
                    if(bld.Length > 0) bld.Append(",");
                    bld.Append(pi.PreferenceID);
                }
            }
            return bld.ToString();
                
        }
    }
#endif

}
