﻿/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id$
 * $DateTime$
 * 
 * マウスとキーボード操作
 */
using System;
using System.Collections.Generic;
using System.Text;
using System.Diagnostics;
using System.Windows.Forms;
using System.Drawing;

using Bellagio.Forms;
using Bellagio.Screening;
using Travis.LocationOperation;
using Poderosa;
using Poderosa.Usability;
using Poderosa.Preferences;

namespace Bellagio.Chart {

    //ちょっと邪道だがスクリーニングも同じ扱い
    public class MouseKBOptionPanelExtension : IOptionPanelExtension {
        private MouseKBOptionPanel _panel;

        public string Caption {
            get {
                return "操作";
            }
        }

        public System.Drawing.Image Icon {
            get {
                return BellagioRoot.CommonIcons.LargeSessions.GetBitmap(7);
            }
        }

        public string[] PreferenceFolderIDsToEdit {
            get {
                return new string[] { "tactico.chart", "tactico.screening" };
            }
        }

        public Panel ContentPanel {
            get {
                return _panel;
            }
        }

        public void InitiUI(IPreferenceFolder[] values) {
            if(_panel==null) _panel = new MouseKBOptionPanel();
            _panel.InitUI(values[0], values[1]);
        }

        public bool Commit(IPreferenceFolder[] values) {
            return _panel.Commit(values[0], values[1]);
        }

        public void Dispose() {
            if(_panel!=null) _panel.Dispose();
        }

    }

    public class MouseKBOptionPanel : Panel {
        private Label _wheelOnChartLabel;
        private ComboBox _wheelOnChartBox;
        private Label _upDownKeyChartLabel;
        private ComboBox _upDownKeyChartBox;
        private Label _wheelOnScreeningPaneLabel;
        private ComboBox _wheelOnScreeningPaneBox;

        public MouseKBOptionPanel() {
            int x1 = 8, x2 = 232;
            int w1 = x2 - 8;
            int h1 = 19;
            int y = 8;
            int w2 = 144;

            _wheelOnChartLabel = FormUtil.CreateLabel("チャート上のマウスホイール");
            _wheelOnChartLabel.Location = new Point(x1, y+2);
            _wheelOnChartLabel.Size = new Size(w1, h1);
            _wheelOnChartBox = FormUtil.CreateComboBox("前後の銘柄へ移動", "チャートをスクロール");
            _wheelOnChartBox.Location = new Point(x2, y);
            _wheelOnChartBox.Size = new Size(w2, h1);

            y += 24;
            _upDownKeyChartLabel = FormUtil.CreateLabel("チャート上の上下キー");
            _upDownKeyChartLabel.Location = new Point(x1, y+2);
            _upDownKeyChartLabel.Size = new Size(w1, h1);
            _upDownKeyChartBox = FormUtil.CreateComboBox("前後のタブへ移動", "前後の銘柄へ移動");
            _upDownKeyChartBox.Location = new Point(x2, y);
            _upDownKeyChartBox.Size = new Size(w2, h1);

            y += 24;
            _wheelOnScreeningPaneLabel = FormUtil.CreateLabel("スクリーニング結果上のマウスホイール");
            _wheelOnScreeningPaneLabel.Location = new Point(x1, y+2);
            _wheelOnScreeningPaneLabel.Size = new Size(w1, h1);
            _wheelOnScreeningPaneBox = FormUtil.CreateComboBox("前後の項目へ移動", "結果ビューをスクロール");
            _wheelOnScreeningPaneBox.Location = new Point(x2, y);
            _wheelOnScreeningPaneBox.Size = new Size(w2, h1);


            this.Controls.AddRange(new Control[] {
                _wheelOnChartLabel,_wheelOnChartBox, _upDownKeyChartLabel, _upDownKeyChartBox, _wheelOnScreeningPaneLabel, _wheelOnScreeningPaneBox });
        }

        public void InitUI(IPreferenceFolder ch, IPreferenceFolder sc) {
            ChartPreferences ch_p = BellagioRoot.FixedPreferences.Chart;
            ScreeningPreferences sc_p = ScreeningPlugin.Instance.Preferences;
            _wheelOnChartBox.SelectedIndex = (int)ParseUtil.ParseEnum<MouseWheelAction>(ch.ChildAt(ch_p.MouseWheelOnChartItem.Index).AsItem().AsString().Value, MouseWheelAction.SwitchStock);
            _upDownKeyChartBox.SelectedIndex = (int)ParseUtil.ParseEnum<UpDownKeyAction>(ch.ChildAt(ch_p.UpDownKeyActionItem.Index).AsItem().AsString().Value, UpDownKeyAction.SwitchTab);
            _wheelOnScreeningPaneBox.SelectedIndex = (int)ParseUtil.ParseEnum<MouseWheelAction>(sc.ChildAt(sc_p.MouseWheelOnResultPaneItem.Index).AsItem().AsString().Value, MouseWheelAction.SwitchStock);
        }

        public bool Commit(IPreferenceFolder ch, IPreferenceFolder sc) {
            ChartPreferences ch_p = BellagioRoot.FixedPreferences.Chart;
            ScreeningPreferences sc_p = ScreeningPlugin.Instance.Preferences;

            ch.ChildAt(ch_p.MouseWheelOnChartItem.Index).AsItem().AsString().Value =  ((MouseWheelAction)_wheelOnChartBox.SelectedIndex).ToString();
            ch.ChildAt(ch_p.UpDownKeyActionItem.Index).AsItem().AsString().Value = ((UpDownKeyAction)_upDownKeyChartBox.SelectedIndex).ToString();
            sc.ChildAt(sc_p.MouseWheelOnResultPaneItem.Index).AsItem().AsString().Value = ((MouseWheelAction)_wheelOnScreeningPaneBox.SelectedIndex).ToString();

            return true;
        }
    }

}
