/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Common/Win32.cs#6 $
 * $DateTime: 2007/10/25 12:56:12 $
 * 
 * Win32֐BptH[}X̂߂ɂ͂xg킴Ȃ
 * 
 */
using System;
using System.Drawing;
using System.Runtime.InteropServices;

namespace Bellagio.Common {
    public static class Win32 {
        [DllImport("gdi32.dll")]
        public static extern IntPtr SelectObject(IntPtr hDC, IntPtr hObject);
        [DllImport("gdi32.dll")]
        public static extern int DeleteObject(IntPtr hObject);
        [DllImport("gdi32.dll")]
        public static extern IntPtr CreatePen(int style, int width, uint color);
        [DllImport("gdi32.dll")]
        public static extern int MoveToEx(IntPtr hDC, int x, int y, int must_be_zero); //Ō̈̌^͖{ "POINT*" A\̂ɂrefɂłAoutɂƈȗłAŎg舫̂intBɂOnƁI
        [DllImport("gdi32.dll")]
        public static extern int LineTo(IntPtr hDC, int x, int y);
        [DllImport("gdi32.dll")]
        public static extern int SetBkColor(IntPtr hDC, uint color);
        [DllImport("gdi32.dll")]
        public static extern IntPtr CreateSolidBrush(uint color);
        [DllImport("gdi32.dll")]
        public static extern int FillRgn(IntPtr hdc, IntPtr rgn, IntPtr brush);

        //COLORREFɑΉԂ
        public static uint ToCOLORREF(Color c) {
            uint t = (uint)c.ToArgb();
            //COLORREF0x00BBGGRRAToArgb0xAARRGGBB
            uint r = (t & 0x00FF0000) >> 16;
            uint b = (t & 0x000000FF) << 16;
            t &= 0x0000FF00;
            return t | r | b;
        }

        [StructLayout(LayoutKind.Sequential)]
        public struct POINT {
            public int x;
            public int y;
        }
        [DllImport("gdi32.dll")]
        public static extern IntPtr CreatePolygonRgn(POINT[] points, int count, int mode);

        //pen styles
        public const int PS_SOLID   = 0;
        public const int PS_DASH    = 1;
        public const int PS_DOT     = 2;
        public const int PS_DASHDOT = 3;

    }

}
