/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id$
 * $DateTime$
 * ̃Zbg Xg[󂯂ȊȌ͂Ŏ󂯂
 */
using System;
using System.Collections.Generic;
using System.Text;
using System.Diagnostics;
using System.Windows.Forms;
using System.Drawing;

using Bellagio.Drawing;
using Bellagio.Values;
using Bellagio.Forms;

using Travis.LocationOperation;
using Sansa.Runtime;

#if UNITTEST
using NUnit.Framework;
#endif

namespace Bellagio.Data {

    //A^C̏(EoȂ)́AlωƂɃNNAj[VBȂ̂ŒO̒lƌ݂̒lƂێ
    public abstract class RealtimeInfoStringBase {
        public delegate void SetValueEventDelegate(RealtimeInfoStringBase v);

        public enum MoveT {
            Increasing, Decreasing, FadeIn, FadeOut, Stable
        }
        protected string _currentString; //` null̂Ƃ͒lݒ
        protected string _prevString;
        protected MoveT _move;
        protected SetValueEventDelegate _setValueEvent;

        public RealtimeInfoStringBase() {
            _move = MoveT.Stable;
        }
        public string CurrentString {
            get {
                return _currentString;
            }
        }
        public string PrevString {
            get {
                return _prevString;
            }
        }
        public MoveT Move {
            get {
                return _move;
            }
        }
        public bool IsEmpty {
            get {
                return _currentString==null;
            }
        }
        public SetValueEventDelegate SetValueEvent {
            get {
                return _setValueEvent;
            }
            set {
                _setValueEvent = value;
            }
        }
        public void MakeStable() {
            _move = MoveT.Stable;
        }

        protected void CallSetValueEvent() {
            if(_setValueEvent!=null) _setValueEvent(this);
        }
    }
    public class RealtimeInfoString<T> : RealtimeInfoStringBase where T:IComparable {
        protected T _currentValue;
        protected T _prevValue;

        public void SetValue(T value) {
            SetValue(value, value.ToString());
        }
        public T Value {
            get {
                return _currentValue;
            }
        }
        public T PrevValue {
            get {
                return _prevValue;
            }
        }

        public void SetValue(T value, string expr) {
            if(_currentString==null) //
                _move = MoveT.FadeIn;
            else {
                int c = value.CompareTo(_currentValue);
                _move = c>0? MoveT.Increasing : c==0? MoveT.Stable : MoveT.Decreasing;
            }
            _prevValue = _currentValue;
            _prevString = _currentString;
            _currentValue = value;
            _currentString = expr;
            CallSetValueEvent();
        }
        public void SetEmpty() {
            _prevValue = _currentValue;
            _prevString = _currentString;
            _currentValue = default(T);
            _currentString = null;
            _move = MoveT.FadeOut;
            CallSetValueEvent();
        }
    }
    //BTime 񉻂ɓƎ
    public class RealtimeInfoBTime : RealtimeInfoString<BTime> {
        public new void SetValue(BTime time) {
            int it = time.AsInt();
            if(MarketUtil.GetEveningOpenTime(StockExchange.O).AsInt() <= it && it <= MarketUtil.GetEveningCloseTime(StockExchange.O).AsInt()) {
                it += 12 * 3600;
            }

            base.SetValue(time, BTime.FormatHHMM(it));
        }
    }
    


    //IntraDayTradeɕt
    public class CurrentPriceInfo {
        private RealtimeInfoString<BDate> _lastCloseDate; //ŏI
        private RealtimeInfoString<Int32> _lastClose; //ŏIIl

        private RealtimeInfoString<Int32> _currentPrice; //ݒl
        private RealtimeInfoBTime _currentPriceTime; //ݒl
        private RealtimeInfoString<Int32> _volume; //o
        private RealtimeInfoString<Double> _vwap; //VWAP
        private RealtimeInfoString<Double> _totalAmount; //

        //nlElEl
        private RealtimeInfoBTime _openTime;
        private RealtimeInfoString<Int32> _openPrice;
        private RealtimeInfoBTime _highTime;
        private RealtimeInfoString<Int32> _highPrice;
        private RealtimeInfoBTime _lowTime;
        private RealtimeInfoString<Int32> _lowPrice;

        //㉺P{̋Cz
        private RealtimeInfoString<Int32> _bidPrice;
        private RealtimeInfoString<Int32> _bidVolume;
        private RealtimeInfoString<Int32> _askPrice;
        private RealtimeInfoString<Int32> _askVolume;

        //Mpc
        private RealtimeInfoString<Int32> _creditLongVolume;
        private RealtimeInfoString<Int32> _creditShortVolume;

        //Zbg񐔂̊mF TickAOHLABestBidAsk̂RŎ
        private int _tickMotionCount;
        private int _ohlMotionCount;
        private int _bestBidAskMotionCount;

        public CurrentPriceInfo() {
            Reset();

            //̊Ԃɕω̂Ȃ̓ZbgȂB
            //܂Avolume/vwap/totalamount͏ɓɓ̂łPZbg΂悢B
            RealtimeInfoStringBase.SetValueEventDelegate tick = delegate(RealtimeInfoStringBase v) { _tickMotionCount++; };
            RealtimeInfoStringBase.SetValueEventDelegate ohl = delegate(RealtimeInfoStringBase v) { _ohlMotionCount++; };
            RealtimeInfoStringBase.SetValueEventDelegate bba = delegate(RealtimeInfoStringBase v) { _bestBidAskMotionCount++; };
            _currentPrice.SetValueEvent = tick;
            _currentPrice.SetValueEvent = tick;
            _volume.SetValueEvent = tick;
            _openTime.SetValueEvent = ohl;
            _openPrice.SetValueEvent = ohl;
            _highTime.SetValueEvent = ohl;
            _highPrice.SetValueEvent = ohl;
            _lowTime.SetValueEvent = ohl;
            _lowPrice.SetValueEvent = ohl;
            _bidPrice.SetValueEvent = bba;
            _bidVolume.SetValueEvent = bba;
            _askPrice.SetValueEvent = bba;
            _askVolume.SetValueEvent = bba;
        }
        public void Reset() {
            _lastCloseDate = new RealtimeInfoString<BDate>();
            _lastClose = new RealtimeInfoString<int>();
            _currentPrice = new RealtimeInfoString<int>();
            _currentPriceTime = new RealtimeInfoBTime();
            _volume = new RealtimeInfoString<int>();
            _vwap = new RealtimeInfoString<double>();
            _totalAmount = new RealtimeInfoString<double>();
            _openTime = new RealtimeInfoBTime();
            _openPrice = new RealtimeInfoString<int>();
            _highTime = new RealtimeInfoBTime();
            _highPrice = new RealtimeInfoString<int>();
            _lowTime = new RealtimeInfoBTime();
            _lowPrice = new RealtimeInfoString<int>();
            _bidPrice = new RealtimeInfoString<int>();
            _bidVolume = new RealtimeInfoString<int>();
            _askPrice = new RealtimeInfoString<int>();
            _askVolume = new RealtimeInfoString<int>();
            _creditLongVolume = new RealtimeInfoString<int>();
            _creditShortVolume = new RealtimeInfoString<int>();
            
            _tickMotionCount = 0;
            _ohlMotionCount = 0;
            _bestBidAskMotionCount = 0;

        }
        public int TickMotionCount {
            get {
                return _tickMotionCount;
            }
        }
        public int OHLMotionCount {
            get {
                return _ohlMotionCount;
            }
        }
        public int BestBidAskMotionCount {
            get {
                return _bestBidAskMotionCount;
            }
        }
        public RealtimeInfoString<BDate> LastCloseDate {
            get {
                return _lastCloseDate;
            }
        }
        public RealtimeInfoString<int> LastClose {
            get {
                return _lastClose;
            }
        }
        public RealtimeInfoString<int> CurrentPrice {
            get {
                return _currentPrice;
            }
        }
        public RealtimeInfoBTime CurrentPriceTime {
            get {
                return _currentPriceTime;
            }
        }
        public RealtimeInfoString<int> Volume {
            get {
                return _volume;
            }
        }
        public RealtimeInfoString<double> VWAP {
            get {
                return _vwap;
            }
        }
        public RealtimeInfoString<double> TotalAmount {
            get {
                return _totalAmount;
            }
        }
        public RealtimeInfoBTime OpenTime {
            get {
                return _openTime;
            }
        }
        public RealtimeInfoString<int> OpenPrice {
            get {
                return _openPrice;
            }
        }
        public RealtimeInfoBTime HighTime {
            get {
                return _highTime;
            }
        }
        public RealtimeInfoString<int> HighPrice {
            get {
                return _highPrice;
            }
        }
        public RealtimeInfoBTime LowTime {
            get {
                return _lowTime;
            }
        }
        public RealtimeInfoString<int> LowPrice {
            get {
                return _lowPrice;
            }
        }
        public RealtimeInfoString<int> BidPrice {
            get {
                return _bidPrice;
            }
        }
        public RealtimeInfoString<int> BidVolume {
            get {
                return _bidVolume;
            }
        }
        public RealtimeInfoString<int> AskPrice {
            get {
                return _askPrice;
            }
        }
        public RealtimeInfoString<int> AskVolume {
            get {
                return _askVolume;
            }
        }
        public RealtimeInfoString<int> CreditLongVolume {
            get {
                return _creditLongVolume;
            }
        }
        public RealtimeInfoString<int> CreditShortVolume {
            get {
                return _creditShortVolume;
            }
        }

        public void SetAllMoveToStable() {
            _lastCloseDate.MakeStable();
            _lastClose.MakeStable();

            _currentPrice.MakeStable();
            _currentPriceTime.MakeStable();
            _volume.MakeStable();
            _vwap.MakeStable(); 
            _totalAmount.MakeStable();

            _openTime.MakeStable();
            _openPrice.MakeStable();
            _highTime.MakeStable();
            _highPrice.MakeStable();
            _lowTime.MakeStable();
            _lowPrice.MakeStable();

            _bidPrice.MakeStable();
            _bidVolume.MakeStable();
            _askPrice.MakeStable();
            _askVolume.MakeStable();

            _creditLongVolume.MakeStable();
            _creditShortVolume.MakeStable();
        }
    }


#if UNITTEST
    [TestFixture]
    public class RealtimeInfoStringTest {
        [Test]
        public void IntTest() {
            RealtimeInfoString<int> v = new RealtimeInfoString<int>();
            v.SetValue(1);
            Assert.AreEqual(1, v.Value);
            Assert.IsNull(v.PrevString);
            Assert.AreEqual(RealtimeInfoStringBase.MoveT.FadeIn, v.Move);

            v.SetValue(1);
            Assert.AreEqual(1, v.Value);
            Assert.AreEqual(1, v.PrevValue);
            Assert.AreEqual(RealtimeInfoStringBase.MoveT.Stable, v.Move);

            v.SetValue(2);
            Assert.AreEqual(2, v.Value);
            Assert.AreEqual(1, v.PrevValue);
            Assert.AreEqual(RealtimeInfoStringBase.MoveT.Increasing, v.Move);

            v.SetValue(1);
            Assert.AreEqual(1, v.Value);
            Assert.AreEqual(2, v.PrevValue);
            Assert.AreEqual(RealtimeInfoStringBase.MoveT.Decreasing, v.Move);
        }
    }
#endif
}
