/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Drawing/ColorAndBrush.cs#4 $
 * $DateTime: 2007/12/28 19:23:38 $
 * 
 */
using System;
using System.Collections.Generic;
using System.Text;
using System.Drawing;

namespace Bellagio.Drawing {
    //P񂾂GDIIuWFNg^Cv
    public struct SmartColor {
        public Color col;
        private Brush _brush;
        
        public Brush B {
            get {
                if(_brush==null) _brush = new SolidBrush(col);
                return _brush; //悭QƂ̂ŒZO
            }
        }
        public void Set(Color color) {
            Clear();
            col = color;
        }
        public void Clear() {
            if(_brush!=null) _brush.Dispose();
            _brush = null;
        }
    }

    public struct SmartFont {
        public string name;
        public float size;
        public FontStyle style;

        private Font _font;

        public Font F {
            get {
                if(_font==null) _font = new Font(name, size, style);
                return _font;
            }
        }
        public void Set(string name_, float size_, FontStyle style_) {
            Clear();
            name = name_;
            size = size_;
            style = style_;
        }
        public void Set(SmartFont value) {
            this.Set(value.name, value.size, value.style);
        }
        public void Clear() {
            if(_font!=null) _font.Dispose();
            _font = null;
        }

        public override string ToString() {
            StringBuilder bld = new StringBuilder();
            bld.Append(name).Append(';').Append(size.ToString());
            if((style & FontStyle.Bold)!=FontStyle.Regular) bld.Append(";bold");
            if((style & FontStyle.Italic)!=FontStyle.Regular) bld.Append(";italic");
            return bld.ToString();
        }

        public static SmartFont Parse(string value) {
            string[] es = value.Split(';');
            float size = 10;
            FontStyle fs = FontStyle.Regular;
            for(int i=1; i<es.Length; i++) {
                string e = es[i];
                if(e=="bold") fs |= FontStyle.Bold;
                else if(e=="italic") fs |= FontStyle.Italic;
                else if('0'<=e[0] && e[0]<'9') float.TryParse(e, out size); //G[nhOт
            }
            SmartFont sf = new SmartFont();
            sf.Set(es[0], size, fs);
            return sf;
        }

        public static bool TryParse(string value, out SmartFont result) {
            result = Parse(value);
            return true;
        }

    }


}
