/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Environment/BellagioLog.cs#10 $
 * $DateTime: 2007/12/28 19:23:38 $
 * 
 * BellagioÑO֘ABgt@C̃G[̋L^As̃|[gȂǁB
 */
using System;
using System.Collections.Generic;
using System.Text;
using System.Diagnostics;

using Poderosa;
using Poderosa.Plugins;

namespace Bellagio.Environment {
    public interface IBellagioLoadingLog {
        void Add(string message);
    }

    //[h̃G[L^
    public class BellagioLoadingLog : IPoderosaLogCategory, IBellagioLoadingLog {
        public class Item {
            public string message;
            public string stacktrace; //null̂Ƃ
        }

        private List<Item> _data;
        private IPoderosaLog _poderosaLog; //IvVi
        private bool _debugConsole;

        public BellagioLoadingLog(IPoderosaWorld poderosa) {
            _data = new List<Item>();
            _poderosaLog = poderosa==null? null : (IPoderosaLog)poderosa.GetAdapter(typeof(IPoderosaLog));
            _debugConsole = true;
        }
        public bool IsPoderosaLogAvailable {
            get {
                return _poderosaLog!=null;
            }
        }
        public void Add(Exception ex) {
            Add(ex.Message, ex.StackTrace);
        }
        public void Add(string message) {
            Add(message, null);
        }
        public void Add(string message, string stacktrace) {
            if(_debugConsole)
                Debug.WriteLine(message);

            Item t = new Item();
            t.message = message;
            t.stacktrace = stacktrace;
            lock(this) {
                _data.Add(t);

                if(_poderosaLog!=null) {
                    _poderosaLog.AddItem(this, message);
                }
            }
        }
        public IEnumerable<Item> Items {
            get {
                return _data;
            }
        }
        public string[] GetMessagesAsStringArray() {
            List<string> r = new List<string>();
            foreach(Item i in _data)
                r.Add(i.message);
            return r.ToArray();
        }

        //TODO JeSʁBG[ɂقǂł͂ȂƂ
        public bool HasError {
            get {
                return _data.Count>0;
            }
        }

        public string Name {
            get {
                return BellagioVersionInfo.PUBLIC_PRODUCT_NAME;
            }
        }

        public IAdaptable GetAdapter(Type adapter) {
            return BellagioPlugin.Instance.PoderosaWorld.AdapterManager.GetAdapter(this, adapter);
        }
    }
}
