/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Environment/BellagioSession.cs#12 $
 * $DateTime: 2008/02/22 14:43:07 $
 * 
 */

using System;
using System.Collections.Generic;
using System.Text;
using System.Drawing;
using System.Windows.Forms;
using System.Resources;
using System.Diagnostics;
using System.Drawing.Imaging;

using Poderosa.Sessions;
using Poderosa;

using Sansa.Runtime;
using Bellagio.Forms;
using Bellagio.Data;

namespace Bellagio.Environment {
    //ZbV̊{
    public abstract class BellagioSessionBase : ISession {
        protected ISessionHost _sessionHost;
        private BellagioDefaultControl _viewControl;
        private BellagioViewContent _viewContent;
        private IPoderosaDocument _document;

        protected string _caption;
        protected Image _icon;

        protected void InitContent(BellagioViewContent v, IPoderosaDocument d) {
            _viewContent = v;
            _document = d;
        }

        public IPoderosaDocument IPoderosaDocument {
            get {
                return _document;
            }
        }
        public BellagioViewContent BellagioViewContent {
            get {
                return _viewContent;
            }
        }

        public abstract void ReloadPreference(IAdaptable arg);

        #region ISession
        public string Caption {
            get {
                return _caption;
            }
        }

        public Image Icon {
            get {
                return _icon;
            }
        }

        public PrepareCloseResult PrepareCloseDocument(IPoderosaDocument document) {
            return PrepareCloseResult.TerminateSession;
        }

        public PrepareCloseResult PrepareCloseSession() {
            return PrepareCloseResult.TerminateSession;
        }

        public virtual void InternalStart(ISessionHost host) {
            _sessionHost = host;
            host.RegisterDocument(_document);
        }
        public virtual void InternalTerminate() {
            _viewContent.Dispose();
        }
        public void InternalAttachView(IPoderosaDocument document, IPoderosaView view) {
            BellagioView bv = (BellagioView)view.GetAdapter(typeof(BellagioView));
            _viewControl = bv.BellagioControl;
            _viewControl.Attach(_viewContent);
        }

        public void InternalDetachView(IPoderosaDocument document, IPoderosaView view) {
            BellagioView bv = (BellagioView)view.GetAdapter(typeof(BellagioView));
            BellagioDefaultControl bc = bv.BellagioControl;
            if(!bc.IsDisposed) bc.EnabledEx = false;

            _viewControl.Detach();
            _viewControl = null;
        }

        public void InternalCloseDocument(IPoderosaDocument document) {
        }

        public Type GetCorrespondingViewType(IPoderosaDocument document) {
            if(document != _document)
                throw new BellagioException("Document type error");

            return typeof(BellagioView);
        }

        public IAdaptable GetAdapter(Type adapter) {
            return BUtil.DefaultGetAdapter(this, adapter);
        }
        #endregion

    }

    //񓯊ǂݍ݋@\thLg
    //[h݂ĎsƂEmptyBbZ[Weŋ
    public enum BellagioDocumentStatus {
        Empty, Loading, Complete
    }

    public abstract class BellagioDocumentBase {
        protected BellagioDocumentStatus _documentStatus;
        protected string _documentStatusMessage;
        protected DataThreadToMainThread _notifyDelegate;

        public BellagioDocumentBase() {
            _documentStatus = BellagioDocumentStatus.Empty;
            _documentStatusMessage = "R[h͂Ă܂";
        }

        public BellagioDocumentStatus DocumentStatus {
            get {
                return _documentStatus;
            }
        }
        public string DocumentStatusMessage {
            get {
                return _documentStatusMessage;
            }
            set {
                _documentStatusMessage = value;
            }
        }
        
        public DataThreadToMainThread NotifyDelegate {
            get {
                return _notifyDelegate;
            }
            set {
                _notifyDelegate = value;
            }
        }

        /*
        public IAdaptable GetAdapter(Type adapter) {
            return BellagioRoot.DefaultGetAdapter(this, adapter);
        }
        */

        protected void DefaultSubscribeFailed(string message) {
            //UIւ̒ʒm͂ł͍sȂ
            _documentStatus = BellagioDocumentStatus.Empty;
            _documentStatusMessage = message;
        }
    }

}
