/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/FigureBoard/FigureBoardPlugin.cs#12 $
 * $DateTime: 2008/05/14 13:05:12 $
 * 
 * l{[hvOC@GMOpł̓EHb`Xg
 */
using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using System.Diagnostics;

using Poderosa;
using Poderosa.Plugins;
using Poderosa.Commands;
using Poderosa.Forms;
using Poderosa.Sessions;
using Poderosa.View;
using Poderosa.Preferences;

using Sansa.Runtime;
using Bellagio.Forms;
using Bellagio.Environment;

[assembly: PluginDeclaration(typeof(Bellagio.FigureBoard.FigureBoardPlugin))]

namespace Bellagio.FigureBoard {
    [PluginInfo(ID=FigureBoardPlugin.PLUGIN_ID, Version=BellagioVersionInfo.PLUGIN_VERSION, Author=BellagioVersionInfo.AUTHOR_NAME, Dependencies=BellagioPlugin.PLUGIN_ID)]
    public class FigureBoardPlugin : PluginBase {
        public const string PLUGIN_ID = "jp.co.lagarto.tactico.figureBoard";
        private static FigureBoardPlugin _instance;

        public override void InitializePlugin(IPoderosaWorld poderosa) {
            base.InitializePlugin(poderosa);

            _instance = this;


        }

        public static FigureBoardPlugin Instance {
            get {
                return _instance;
            }
        }

        private static ScriptScratchPad _scriptScratchPad;
        public static CommandResult ShowScriptScratchPad(ICommandTarget target) {
            if(_scriptScratchPad==null || _scriptScratchPad.IsDisposed)
                _scriptScratchPad = new ScriptScratchPad(((IPoderosaForm)target.GetAdapter(typeof(IPoderosaForm))).AsForm());

            _scriptScratchPad.Show();
            return CommandResult.Succeeded;
        }
    }



    /*
    public class OpenFigureBoardCommand : BellagioSessionOpenCommand {
        public OpenFigureBoardCommand(string schemaID, Keys shortcut)
            : base(schemaID, shortcut) {
        }
        protected override BellagioSessionBase CreateSession() {
            FigureBoardSchema cs = BellagioRoot.SchemaRoot.FindFigureBoardSchema(_schemaID);
            if(cs==null) throw new BellagioException(String.Format("tBMA{[h̃XL[} {0} ܂", _schemaID));

            FigureBoardSessionCreateParam cp = new FigureBoardSessionCreateParam(cs);
            return new FigureBoardSession(cp);
        }
    }
    */

    public class FigureBoardPreference {
        //private FigureBoard
        public void Initialize(IPreferenceBuilder builder, IPreferenceFolder folder) {
            //IPreferenceFolder f = builder.DefineFolder(folder, BellagioPlugin.Instance, "chart");
        }

    }
}
