/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Forms/TimerUtil.cs#8 $
 * $DateTime: 2007/12/28 19:23:38 $
 * 
 */
using System;
using System.Collections.Generic;
using System.Text;
using System.Drawing;
using Sansa.Runtime;
using Bellagio.Drawing;

#if UNITTEST
using NUnit.Framework;
#endif

namespace Bellagio.Forms {
    //l̕ϊ܂
    public class ConvertingTimerIntInt {
        public delegate int F(int value); //ϊ֐

        private IntTimer _src;
        private F _f;

        public ConvertingTimerIntInt(IntTimer s, F f) {
            _src = s;
            _f = f;
        }
        public int value() {
            return _f(_src.value());
        }

        public void Initialize() {
            _src.Initialize();
        }
        public void Abort() {
            _src.Abort();
        }
    }
    public class ConvertingTimerDoubleDouble {
        public delegate double F(double value); //ϊ֐

        private DoubleTimer _src;
        private F _f;

        public ConvertingTimerDoubleDouble(DoubleTimer s, F f) {
            _src = s;
            _f = f;
        }
        public double value() {
            return _f(_src.value());
        }

        public void Initialize() {
            _src.Initialize();
        }
        public void Abort() {
            _src.Abort();
        }
    }
    public class ConvertingTimerIntColor {
        public delegate Color F(int value); //ϊ֐

        private IntTimer _src;
        private F _f;

        public ConvertingTimerIntColor(IntTimer s, F f) {
            _src = s;
            _f = f;
        }
        public Color value() {
            return _f(_src.value());
        }

        public void Initialize() {
            _src.Initialize();
        }
        public void Abort() {
            _src.Abort();
        }
    }



    //͈͓ŐU^C}
    public class VibrationTimer : ConvertingTimerIntInt {
        //cyclebƂ0𒆐S-ampamp܂œ
        public VibrationTimer(IntTimer src, int midvalue, int amp) : base(src, CreateDelegate(src, midvalue, amp)) {
        }

        private static F CreateDelegate(IntTimer src, int midvalue, int amp) {
            return delegate(int value) {
                return midvalue + GraphicEffectUtil.LinearZigZag(src.FinalValue, value, amp);
            };
        }

        public static VibrationTimer Create(IPlatformBridge platform, int midvalue, int amp, double cycle_sec) {
            return Create(platform, midvalue, amp, cycle_sec, null);
        }
        public static VibrationTimer Create(IPlatformBridge platform, int midvalue, int amp, double cycle_sec, DTimerHandler.D tick) {
            int cycle= platform.getRootTimer().secondToTick(cycle_sec);
            IntTimer t = null;
            t = new IntTimer(platform,
                new DTimerHandler(delegate() { t.reset(0, 1, 0, cycle, cycle, true); }, tick));
            return new VibrationTimer(t, midvalue, amp);
        }
    }
    public class VibrationTimerF : ConvertingTimerDoubleDouble {
        //cyclebƂ0𒆐S-ampamp܂œ(float)
        public VibrationTimerF(DoubleTimer src,float  midvalue, float amp)
            : base(src, CreateDelegate(src, midvalue, amp)) {
        }

        private static F CreateDelegate(DoubleTimer src, float midvalue, float amp) {
            return delegate(double value) {
                return (double)(midvalue + GraphicEffectUtil.LinearZigZagF((float)src.FinalValue, (float)value, amp));
            };
        }

        public static VibrationTimerF Create(IPlatformBridge platform, float midvalue, float amp, double cycle_sec) {
            return Create(platform, midvalue, amp, cycle_sec, null);
        }
        public static VibrationTimerF Create(IPlatformBridge platform, float midvalue, float amp, double cycle_sec, DTimerHandler.D tick) {
            int cycle= platform.getRootTimer().secondToTick(cycle_sec);
            DoubleTimer t = null;
            t = new DoubleTimer(platform,
                new DTimerHandler(delegate() { t.reset(0, 1, 0, 1, cycle, true); }, tick));
            return new VibrationTimerF(t, midvalue, amp);
        }
    }
#if UNITTEST
    [TestFixture]
    public class TimerUtilTests : IPlatformBridge {
        private RootTimer _rootTimer;
        private StringBuilder _bld;

        [TestFixtureSetUp]
        public void SetUp() {
        }

        private void tick() {
            _rootTimer.tickForTest();
        }
        private void RecordTick(int value) {
            if(_bld.Length > 0) _bld.Append(',');
            _bld.Append(value.ToString());
        }
        private void RecordTickD(double value) {
            if(_bld.Length > 0) _bld.Append(',');
            _bld.Append(value.ToString("F1"));
        }
        private void Reset() {
            _bld = new StringBuilder();
            _rootTimer = new RootTimer(0);
        }

        public RootTimer getRootTimer() {
            return _rootTimer;
        }

        public Object getAdapter(Type klass) {
            return null; //not used
        }
        public void invalidate(int x, int y, int width, int height) {

        }

        [Test]
        public void Vibration() {
            Reset();
            VibrationTimer t = null;
            t = VibrationTimer.Create(this, 3, 2, 8, delegate() { RecordTick(t.value()); });

            Assert.AreEqual(0, _rootTimer.getTimerCount());
            t.Initialize();
            Assert.AreEqual(1, _rootTimer.getTimerCount());
            for(int i=0; i<7; i++) tick(); //InitializeɂP񓮂Ă

            Assert.AreEqual("3,4,5,4,3,2,1,2", _bld.ToString());
            Assert.AreEqual(1, _rootTimer.getTimerCount());

            //P
            for(int i=0; i<8; i++) tick();
            Assert.AreEqual("3,4,5,4,3,2,1,2,3,4,5,4,3,2,1,2", _bld.ToString());
        }
        [Test]
        public void VibrationF() {
            Reset();
            VibrationTimerF t = null;
            t = VibrationTimerF.Create(this, 0, 3, 12, delegate() { RecordTickD(t.value()); });

            Assert.AreEqual(0, _rootTimer.getTimerCount());
            t.Initialize();
            Assert.AreEqual(1, _rootTimer.getTimerCount());
            for(int i=0; i<5; i++) tick(); //InitializeɂP񓮂Ă

            Assert.AreEqual("0.0,1.0,2.0,3.0,2.0,1.0", _bld.ToString());
            Assert.AreEqual(1, _rootTimer.getTimerCount());
        }
    }
#endif

}
