/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id$
 * $DateTime$
 * 
 * tH[̂A{̂UI𔲂oUserControl
 * ɓRg[镪Ă\
 */
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Resources;
using System.Diagnostics;

using Travis.LocationOperation;
using Poderosa;

using Bellagio.Common;
using Bellagio.Data;
using Bellagio.Forms;
using Bellagio.Chart;
using Bellagio.Environment;
using Bellagio.Values;
using Bellagio.Drawing;

using Poderosa.Sessions;
using Poderosa.Forms;
using Poderosa.Commands;

namespace Bellagio.Ordering {
    public class OrderControl : UserControl {
        //R[hEs\ȂCAEgX^C
        public enum LayoutT {
            IncludeCode = 1,  //R[h͍݁Bŏ̃o[WŎgpB
            OmitCode = 2,     //R[h͂OɏoAςłB2008/3o[W
        }

        private OrderFormParameter _parameter;
        private LayoutT _layout;

        private Font _orderMainFont; //̂dvڂ͑傫tHg
        private Font _UINumericFont; //wlEʓ̓tHg
        private Font _figureFont;    //|WV̕\ŐɎgptHg
        private int _figureFontYOffset; //ʒu킹
        private Brush _figureBrush;
        private Brush _buyMarkBrush;  //Ẽ|WV/ɂ킹ĕ\
        private Brush _sellMarkBrush;
        private Color _backColor;
        private Color _foreColor;

        private int _defaultPanelHeight;
        
        //܂݂Ă
        private AbstractStockProfile _stockProfile;

        //擾ς݌l@擾̂Ƃnull
        private OrderDataStockSnapshot _stockSnapshot;

        //Qiځ@R[h
        private Label _codeLabel;
        private CodeInputBox _codeBox;

        //Riځ@s
        private Label _marketLabel;
        private ComboBox _marketButton;

        //Siځ@敪 (ρEł̓|WVe܂͒e\)
        //̎wQZbg
        //A. VKpŌEMpEMp̂R{^{Mpʂ̃R{{bNX
        private Label _orderTypeLabel;
        private RibbonMenuButton _newOrderGenbutsu;   //
        private RibbonMenuButton _newOrderCreBuy;  //Mp
        private RibbonMenuButton _newOrderCreSell;  //Mp
        private Label _creditTypeLabel;   //Mp敪(x/)
        private ComboBox _creditTypeBox;

        //B. ExEI{/{VK/ԍ
        private CheckBox _dealTypeGenbutsu;
        private CheckBox _dealTypeSeido;
        private CheckBox _dealTypeIppan;
        private RibbonMenuButton _buyButton;
        private RibbonMenuButton _sellButton;
        private CheckBox _newPositionButton;
        private CheckBox _closePositionButton;

        //C. |WV܂ĂƂ
        private Control _currentPositionOrOrder; //ϒ(P|W)EύX̂Ƃ͂ɂ̒Ƀ|WVEeo
        private DataGridView _positionDetailList;    //ϒ(|W)̂Ƃ͂̃Xgr[Œڍׂ
        private bool _positionDetailListVisible; //tH[̂\̂ƂAVisiblevpeBƂ˂FalseɂȂĂ܂I
        private Label _separator2;

        //Tiځ@i
        private Label _sashineLabel;
        private VolumeInputBox _sashineBox;
        private HoveringLabel _sashineDec10;
        private HoveringLabel _sashineDec;
        private HoveringLabel _sashineInc;
        private HoveringLabel _sashineInc10;
        private CheckBox _nariyukiButton;
        private Label _priceRangeLabel;
        private Label _priceRangeText;
        private Label _powerAmountLabel; //]͏
        private Label _powerAmountText;
        private Label _tradeAmountLabel; //
        private Label _tradeAmountText;
        private Button _currentPriceButton;
        //private Button _prevClosePriceButton;

        //Uiځ@
        private Label _volumeLabel;
        private VolumeInputBox _volumeBox;
        private HoveringLabel _volumeDec10;
        private HoveringLabel _volumeDec;
        private HoveringLabel _volumeInc;
        private HoveringLabel _volumeInc10;
        //private Button _maxVolumeButton; //S̓{^
        private Label _separator3;

        //Viځ@sAi/ʁj
        private Label _sikkoLabel;
        private ComboBox _sikkoBox;
        private Label _kouzaLabel;
        private ComboBox _kouzaBox;

        //Wiځ@AmFʕ\
        private Label _dateLabel;
        private ComboBox _dateBox;
        private CheckBox _omitConfirmDialogBox;

        //Xiځ@ÏؔԍƏȗIvV
        private Label _pinCodeLabel;
        private TextBox _pinCodeBox;
        private CheckBox _savePinCodeBox;
        private Label _separator4;

        //zu
        private RectangleOperator _regularMainRectOp;         //gbvx(ʏ)
        private RectangleOperator _gridMainRectOp;          //gbvx(ԍς̏ڍׂ̃Obhgp)
        
        private BRect _codeBoxRect;              //Ȃǂ̃{^A
        private RectangleOperator _codeBoxRectOp;
        private BRect _positionOrDealTypeRect;          //ʁÃ݂|WVAêꂩ
        private RectangleOperator _positionOrDealTypeRectOp;
        private BRect _priceAndVolumeRect;              //iEʂȂǂ̓͗̈
        private RectangleOperator _priceAndVolumeRectOp;

        //UIŒeύXɂȂꍇɏoCxg vpeBZbgł͏oȂ
        public event VoidVoidDelegate OrderContentChanged;
        public delegate void StockChangedDelegate(AbstractStockProfile prof);
        public event StockChangedDelegate StockChanged;

        public OrderControl(LayoutT layout) {
            _layout = layout;
            _backColor = Color.Black;
            _foreColor = Color.White;
            this.BorderStyle = BorderStyle.None;
            _orderMainFont = new Font("lr SVbN", 9F);
            _UINumericFont = new Font("lr SVbN", 10.5F);
            _figureFont = new Font("lr SVbN", 9F);
            _figureBrush = new SolidBrush(Color.DarkGoldenrod);
            _figureFontYOffset = 0;
            _buyMarkBrush = new SolidBrush(Color.Red);
            _sellMarkBrush = new SolidBrush(Color.DarkBlue);

            _codeBoxRect = new BRect();
            _positionOrDealTypeRect = new BRect();
            _priceAndVolumeRect = new BRect();

            _codeLabel = CreateLabelVM("(&C)");
            _codeBox = new CodeInputBox();
            _marketLabel = CreateLabelVM("s(&M)");
            _marketButton = CreateComboBox();
            if(_layout==LayoutT.IncludeCode) {
                ChartDrawingSettings ds = BellagioRoot.FixedPreferences.Chart.ChartDrawingSettings;
                _codeBox.FontEx = ds.stockBoxFont.F;
                _codeBox.CodeColor = ds.stockCodeColor.col;
                _codeBox.NameColor = ds.stockNameColor.col;
                _codeBox.BackColor = _backColor;
                _codeBox.DataProvider = new CodeDropDownDataProvider();
                _codeBox.StockChanged += new EventHandler(OnStockChanged);
                _marketButton.SelectedIndexChanged += new EventHandler(OnMarketChanged);
                _orderTypeLabel = FormUtil.CreateLabel("");
                _orderTypeLabel.TextAlign = ContentAlignment.TopLeft; //Ƀ|WV邱Ƃ̂
                _newOrderGenbutsu = CreateOrderTypeButton("", 6);
                _newOrderCreBuy = CreateOrderTypeButton("Mp", 7);
                _newOrderCreSell = CreateOrderTypeButton("Mp", 8);
                _creditTypeLabel = FormUtil.CreateLabel("Mp敪(&Y)");
                _creditTypeLabel.TextAlign = ContentAlignment.TopLeft; //_orderTypeLabelƂ킹
                _creditTypeBox = CreateComboBox();
                _creditTypeBox.SelectedIndexChanged += delegate(object sender, EventArgs args) { this.OrderContentChanged(); };
            }
            else {
                _orderTypeLabel = FormUtil.CreateLabel("");
                _orderTypeLabel.TextAlign = ContentAlignment.TopLeft; //Ƀ|WV邱Ƃ̂
                _dealTypeGenbutsu = FormUtil.CreateImageAndTextToggleButton(null, "", new EventHandler(OnDealTypeCheckedChanged));
                _dealTypeSeido = FormUtil.CreateImageAndTextToggleButton(null, "x", new EventHandler(OnDealTypeCheckedChanged));
                _dealTypeIppan = FormUtil.CreateImageAndTextToggleButton(null, "", new EventHandler(OnDealTypeCheckedChanged));
                _buyButton = CreateBuyOrSellButton("", 7);
                _sellButton = CreateBuyOrSellButton("", 8);
                _newPositionButton = FormUtil.CreateImageAndTextToggleButton(null, "VK", new EventHandler(OnNewOrCloseCheckedChanged));
                _closePositionButton = FormUtil.CreateImageAndTextToggleButton(null, "ԍ", new EventHandler(OnNewOrCloseCheckedChanged));
                _dealTypeGenbutsu.AutoCheck = _dealTypeSeido.AutoCheck = _dealTypeIppan.AutoCheck = _newPositionButton.AutoCheck = _closePositionButton.AutoCheck = false;
            }
            _currentPositionOrOrder = FormUtil.CreateCustomPaintControl(new PaintEventHandler(OnPaintCurrentPositionOrOrder));
            _currentPositionOrOrder.Resize += new EventHandler(OnResizeCurrentPositionOrOrder);
            _currentPositionOrOrder.Font = _orderMainFont;
            _positionDetailList = CreatePositionDetailListView();
            _separator2 = FormUtil.CreateSeparatorAsLabel();
            _sashineLabel = CreateLabelVM("wl(&P)");
            _sashineBox = new VolumeInputBox();
            _sashineBox.Font = _UINumericFont;
            _sashineDec10 = CreateSashineChangeLabel(3);
            _sashineDec = CreateSashineChangeLabel(5);
            _sashineInc = CreateSashineChangeLabel(6);
            _sashineInc10 = CreateSashineChangeLabel(4);
            _nariyukiButton = FormUtil.CreateImageAndTextToggleButton(null, "s", new EventHandler(OnNariyukiButtonClick));
            _nariyukiButton.ImageAlign = ContentAlignment.MiddleLeft;
            _priceRangeText = FormUtil.CreateLabel("");
            _powerAmountText = CreateLabelVM("");
            _tradeAmountText = CreateLabelVM("");
            _priceRangeLabel = FormUtil.CreateLabel("\l");
            _powerAmountLabel = CreateLabelVM("");
            _tradeAmountLabel = CreateLabelVM("TZ");
            _currentPriceButton = CreateTextCommandButton("<<l", new EventHandler(OnCurrentPriceButtonClick));
            _volumeLabel = CreateLabelVM("(&V)");
            _volumeBox = new VolumeInputBox();
            _volumeBox.Font = _UINumericFont;
            _volumeDec10 = CreateVolumeChangeLabel(3);
            _volumeDec = CreateVolumeChangeLabel(5);
            _volumeInc = CreateVolumeChangeLabel(6);
            _volumeInc10 = CreateVolumeChangeLabel(4);
            //_maxVolumeButton = CreateTextCommandButton("S", new EventHandler(OnMaxVolumeButtonClick));
            _separator3 = FormUtil.CreateSeparatorAsLabel();
            EventHandler misc_cond_change = delegate(object sender, EventArgs args) { this.OrderContentChanged(); };
            _sikkoBox = CreateComboBox("Ȃ", "t", "", "w"); //̍\͉ς̂ق
            _sikkoBox.SelectedIndexChanged += misc_cond_change;
            _sikkoLabel = CreateLabelVM("s敪(&E)");
            _kouzaLabel = CreateLabelVM("(&Z)");
            _kouzaBox = CreateComboBox();
            _kouzaBox.SelectedIndexChanged += misc_cond_change;
            _dateLabel = CreateLabelVM("L(&D)");
            _dateBox = CreateComboBox("", "T");
            _dateBox.SelectedIndexChanged += misc_cond_change;
            _omitConfirmDialogBox = new CheckBox();
            _omitConfirmDialogBox.Text = "mFʂȗ(&R)";
            _omitConfirmDialogBox.CheckedChanged += delegate(object sender, EventArgs args) { //mFʂȗƁApincodeL͋
                _savePinCodeBox.Checked = true;
                _savePinCodeBox.Enabled = !_omitConfirmDialogBox.Checked;
            };
            _pinCodeLabel = CreateLabelVM("Ï(&N)");
            _pinCodeBox = new TextBox();
            _pinCodeBox.PasswordChar = '*';
            _savePinCodeBox = new CheckBox();
            _savePinCodeBox.Text = "Ï؂L(&S)";
            _separator4 = FormUtil.CreateSeparatorAsLabel();

            if(_layout==LayoutT.IncludeCode) {
                this.Controls.AddRange(new Control[] {
                _codeLabel, _codeBox, //DIɂtH[JXɂĂBƃ^uI[_[
                _marketLabel, _marketButton,
                _orderTypeLabel, _newOrderGenbutsu, _newOrderCreBuy, _newOrderCreSell, _creditTypeLabel, _creditTypeBox, _currentPositionOrOrder, _positionDetailList, _separator2,
                _volumeLabel, _volumeBox,  _volumeInc10, _volumeInc, _volumeDec, _volumeDec10, /*_maxVolumeButton,*/  
                _sashineLabel, _sashineBox, _sashineInc10, _sashineInc, _sashineDec, _sashineDec10, _currentPriceButton, _nariyukiButton,
                _priceRangeText, _powerAmountText, _tradeAmountText,  _priceRangeLabel, _powerAmountLabel, _tradeAmountLabel, /*_prevClosePriceButton,*/ _separator3,
                _sikkoLabel, _sikkoBox, _kouzaLabel, _kouzaBox,
                _dateLabel, _dateBox, _omitConfirmDialogBox,
                _pinCodeLabel, _pinCodeBox, _savePinCodeBox, _separator4,
            });
            }
            else {
                this.Controls.AddRange(new Control[] {
                _orderTypeLabel, _dealTypeGenbutsu, _dealTypeSeido, _dealTypeIppan, _buyButton, _sellButton, _newPositionButton, _closePositionButton, _currentPositionOrOrder, _positionDetailList, _separator2,
                _volumeLabel, _volumeBox,  _volumeInc10, _volumeInc, _volumeDec, _volumeDec10, /*_maxVolumeButton,*/  
                _sashineLabel, _sashineBox, _sashineInc10, _sashineInc, _sashineDec, _sashineDec10, _currentPriceButton, _nariyukiButton,
                _priceRangeText, _powerAmountText, _tradeAmountText,  _priceRangeLabel, _powerAmountLabel, _tradeAmountLabel, /*_prevClosePriceButton,*/ _separator3,
                _sikkoLabel, _sikkoBox, _kouzaLabel, _kouzaBox,
                _dateLabel, _dateBox, _omitConfirmDialogBox,
                _pinCodeLabel, _pinCodeBox, _savePinCodeBox,
            });
            }

            int row_s = 24; //P̍()
            int lh = 19; //x
            int row_m = 30; //P̍()
            int m = 8; //W̃Rg[ԃ}[W
            int ll = 4; //̃xp[gXW
            int lw = 92; //̃xp[g̕
            int lw2 = 108; //lE]͏̕
            int lc = lw - ll; //̃x̃Rg[̕
            int cw = 100; //iEʂȂǂ̃Rg[
            int sb = 20; //ACRRg[̈
            int rib_w = 52; //摜t{̃TCY
            int rib_h = 48;

            _codeBox.Height = row_m-4; //ProbeControlVerCenterg͎̍
            _sashineBox.Height = row_m-4;
            _volumeBox.Height = row_m-4;
            _priceRangeText.Height = _powerAmountText.Height = 14;

            _codeBoxRectOp = new RectangleOperatorBuilder()
                .SplitFixed(SplitDir.Top, row_m)
                    .SplitFixed(SplitDir.Left, lw).CornerOffset(RectCorner.TopLeft, ll, 0, lc, row_s).ProbeControl(_codeLabel).CloseBranch()
                    .ProbeControlVerCenter(_codeBox)
                    .CloseBranch()
                .SplitFixed(SplitDir.Top, row_s)
                    .SplitFixed(SplitDir.Left, lw).CornerOffset(RectCorner.TopLeft, ll, 0, lc, lh).ProbeControl(_marketLabel).CloseBranch()
                    .CornerOffset(RectCorner.TopLeft, 0, 0, cw, 19).ProbeControl(_marketButton)
                    .CloseBranch()
                .Finish();

            _priceAndVolumeRectOp = new RectangleOperatorBuilder()
                .SplitFixed(SplitDir.Top, 8)
                    .Shrink(3).ProbeControl(_separator2).CloseBranch()
                .SplitFixed(SplitDir.Top, row_s)
                    .SplitFixed(SplitDir.Left, lw).CornerOffset(RectCorner.TopLeft, ll, 0, lc, row_s).ProbeControl(_volumeLabel).CloseBranch()
                    .CornerOffset(RectCorner.TopLeft, 0, 0, cw, row_s).ProbeControlVerCenter(_volumeBox)
                    .LocateRight(m, sb, sb).ProbeControlVerCenter(_volumeInc10)
                    .LocateRight(2, sb, sb).ProbeControlVerCenter(_volumeInc)
                    .LocateRight(2, sb, sb).ProbeControlVerCenter(_volumeDec)
                    .LocateRight(2, sb, sb).ProbeControlVerCenter(_volumeDec10)
                    .CloseBranch()
                .SplitFixed(SplitDir.Top, row_s)
                    .SplitFixed(SplitDir.Left, lw)
                        .CornerOffset(RectCorner.TopLeft, ll, 0, lc, row_s).ProbeControl(_sashineLabel)
                        .CloseBranch()
                    .CornerOffset(RectCorner.TopLeft, 0, 0, cw, row_s).ProbeControlVerCenter(_sashineBox)
                    .LocateRight(m, sb, row_s).ProbeControlVerCenter(_sashineInc10)
                    .LocateRight(2, sb, row_s).ProbeControlVerCenter(_sashineInc)
                    .LocateRight(2, sb, row_s).ProbeControlVerCenter(_sashineDec)
                    .LocateRight(2, sb, row_s).ProbeControlVerCenter(_sashineDec10)
                    .LocateRight(8, 56, row_s).ProbeControlVerCenter(_currentPriceButton)
                    .CloseBranch()
                .SplitFixed(SplitDir.Top, row_s)
                    .CornerOffset(RectCorner.TopLeft, lw, 0, 64, row_s).ProbeControl(_nariyukiButton)
                    .CloseBranch()
                .SplitFixed(SplitDir.Top, 16)
                    .CornerOffset(RectCorner.TopLeft, lw, 0, lw, 16).ProbeControl(_priceRangeLabel)
                    .LocateRight(8, lw2, 16).ProbeControl(_priceRangeText)
                    .CloseBranch()
                .SplitFixed(SplitDir.Top, 16)
                    .CornerOffset(RectCorner.TopLeft, lw, 0, lw, 16).ProbeControl(_tradeAmountLabel)
                    .LocateRight(8, lw2, 16).ProbeControl(_tradeAmountText)
                    .CloseBranch()
                .SplitFixed(SplitDir.Top, 16)
                    .CornerOffset(RectCorner.TopLeft, lw, 0, lw, 16).ProbeControl(_powerAmountLabel)
                    .LocateRight(8, lw2, 16).ProbeControl(_powerAmountText)
                    .CloseBranch()
                .SplitFixed(SplitDir.Top, 8)
                    .Shrink(3).ProbeControl(_separator3)
                    .CloseBranch()
                .SplitFixed(SplitDir.Top, row_s)
                    .SplitRatio(SplitDir.Left, 0.6F, 100)
                        .SplitFixed(SplitDir.Left, lw).CornerOffset(RectCorner.TopLeft, ll, 0, lc, lh).ProbeControl(_sikkoLabel).CloseBranch()
                        .CornerOffset(RectCorner.TopLeft, 0, 0, cw, row_s).ProbeControl(_sikkoBox)
                        .CloseBranch()
                    .SplitFixed(SplitDir.Left, 52).CornerOffset(RectCorner.TopLeft, 0, 0, 52, lh).ProbeControl(_kouzaLabel)
                        .CornerOffset(RectCorner.TopRight, 12, 0, 72, row_s).ProbeControl(_kouzaBox).CloseBranch()
                    .CloseBranch()
                .SplitFixed(SplitDir.Top, row_s)
                    .SplitRatio(SplitDir.Left, 0.6F, 100)
                        .SplitFixed(SplitDir.Left, lw).CornerOffset(RectCorner.TopLeft, ll, 0, lc, lh).ProbeControl(_dateLabel).CloseBranch()
                        .CornerOffset(RectCorner.TopLeft, 0, 0, cw, row_s).ProbeControl(_dateBox)
                        .CloseBranch()
                    .ProbeControl(_omitConfirmDialogBox)
                    .CloseBranch()
                .SplitFixed(SplitDir.Top, row_s)
                    .SplitRatio(SplitDir.Left, 0.6F, 100)
                        .SplitFixed(SplitDir.Left, lw).CornerOffset(RectCorner.TopLeft, ll, 0, lc, lh).ProbeControl(_pinCodeLabel).CloseBranch()
                        .CornerOffset(RectCorner.TopLeft, 0, 0, cw, row_s).ProbeControl(_pinCodeBox)
                        .CloseBranch()
                        .ProbeControl(_savePinCodeBox)
                    .CloseBranch()
                .SplitFixed(SplitDir.Top, 8)
                    .Shrink(3).ProbeControl(_separator4).CloseBranch()
                .Finish();

            //ObhRg[_currentPositionOrOrder̃TCYɒǐ`Ŏ蓮œ
            if(_layout==LayoutT.IncludeCode) {
                _positionOrDealTypeRectOp = new RectangleOperatorBuilder()
                    .SplitFixed(SplitDir.Left, lw).CornerOffset(RectCorner.TopLeft, ll, 0, lc, row_s).ProbeControl(_orderTypeLabel).CloseBranch()
                    .Tee().ProbeControlManualVisible(_currentPositionOrOrder).CloseBranch()
                    .SplitFixed(SplitDir.Right, 80)
                        .CornerOffset(RectCorner.TopLeft, 4, 0, 72, 19).ProbeControlManualVisible(_creditTypeLabel)
                        .CornerOffset(RectCorner.BottomLeft, -2, 0, 72, 19).ProbeControlManualVisible(_creditTypeBox)
                        .CloseBranch()
                    .CornerOffset(RectCorner.TopLeft, 0, 0, rib_w, rib_h).ProbeControlManualVisible(_newOrderGenbutsu)
                    .CornerOffset(RectCorner.TopRight, m, 0, rib_w, rib_h).ProbeControlManualVisible(_newOrderCreBuy)
                    .CornerOffset(RectCorner.TopRight, m, 0, rib_w, rib_h).ProbeControlManualVisible(_newOrderCreSell)
                    .Finish();
            }
            else {
                _positionOrDealTypeRectOp = new RectangleOperatorBuilder()
                    .SplitFixed(SplitDir.Left, lw).CornerOffset(RectCorner.TopLeft, ll, 0, lc, row_s).ProbeControl(_orderTypeLabel).CloseBranch()
                    .Tee().ProbeControlManualVisible(_currentPositionOrOrder).CloseBranch()
                    .SplitFixed(SplitDir.Top, 28)
                        .CornerOffset(RectCorner.TopLeft, 0, 0, rib_w, row_s).ProbeControl(_dealTypeGenbutsu)
                        .CornerOffset(RectCorner.TopRight, m, 0, rib_w, row_s).ProbeControl(_dealTypeSeido)
                        .CornerOffset(RectCorner.TopRight, m, 0, rib_w, row_s).ProbeControl(_dealTypeIppan)
                        .CloseBranch()
                    .CornerOffset(RectCorner.TopLeft, 0, 0, rib_w, rib_h).ProbeControlManualVisible(_buyButton)
                    .CornerOffset(RectCorner.TopRight, m, 0, rib_w, rib_h).ProbeControlManualVisible(_sellButton)
                    .CornerOffset(RectCorner.TopRight, m, 0, rib_w, row_s).ProbeControl(_newPositionButton)
                    .CornerOffset(RectCorner.BottomLeft, 0, rib_h-row_s*2, rib_w, row_s).ProbeControl(_closePositionButton)
                    .Finish();
            }

            //[gRectOṕAԍώƒʏňقȂ̂QޗpӂĂ
            const int codeBoxH = 54;
            int positionOrDealTypeH = _layout==LayoutT.IncludeCode? 54 : 80;
            const int priceAndVolumeH = 212;
            _defaultPanelHeight = codeBoxH + positionOrDealTypeH + priceAndVolumeH;

            RectangleOperatorBuilder bld = new RectangleOperatorBuilder();
            if(_layout==LayoutT.IncludeCode)
                bld.SplitFixed(SplitDir.Top, codeBoxH).ProbeBRect(_codeBoxRect).CloseBranch();
            bld.SplitFixed(SplitDir.Top, positionOrDealTypeH).ProbeBRect(_positionOrDealTypeRect).CloseBranch();
            bld.SplitFixed(SplitDir.Top, priceAndVolumeH).ProbeBRect(_priceAndVolumeRect).CloseBranch();
            _regularMainRectOp = bld.Finish();

            bld = new RectangleOperatorBuilder();
            if(_layout==LayoutT.IncludeCode)
                bld.SplitFixed(SplitDir.Top, codeBoxH).ProbeBRect(_codeBoxRect).CloseBranch(); //͓
            bld.SplitFixed(SplitDir.Bottom, priceAndVolumeH).ProbeBRect(_priceAndVolumeRect).CloseBranch();
            bld.ProbeBRect(_positionOrDealTypeRect);
            _gridMainRectOp = bld.Finish();


            _codeBox.MouseUp += new MouseEventHandler(OnContextMenu);
            this.ClientSize = new Size(360, _defaultPanelHeight); //̏TCYŒlɂȂ
            
            this.BackColor = _backColor;
            this.BackColor = SystemColors.Control;
            _sashineBox.BackColor = _backColor; _sashineBox.ForeColor = _foreColor;
            _sashineBox.MouseWheel += new MouseEventHandler(OnMouseWheelSashine);
            _sashineBox.UnitChangeHandler = delegate(bool increment) {
                ChangeSashine(increment, false);
                this.OrderContentChanged();
            };
            _sashineBox.TextAlign = HorizontalAlignment.Right;
            _sashineBox.ValueChangeByKey = delegate(int newvalue) {
                AdjustTradeAmountLabel();
                this.OrderContentChanged();
            };
            _volumeBox.BackColor = _backColor; _volumeBox.ForeColor = _foreColor;
            _volumeBox.MouseWheel += new MouseEventHandler(OnMouseWheelVolume);
            _volumeBox.UnitChangeHandler = delegate(bool increment) {
                ChangeVolume(increment, false);
                this.OrderContentChanged();
            };
            _volumeBox.ValueChangeByKey = delegate(int newvalue) {
                AdjustTradeAmountLabel(); AdjustVolumeInGrid(newvalue);
                this.OrderContentChanged();
            };
            _priceRangeText.TextAlign = ContentAlignment.MiddleLeft;
            Color support_info_color = Color.FromArgb(0x20, 0x20, 0x40);
            _priceRangeText.ForeColor = support_info_color;
            _tradeAmountText.ForeColor = support_info_color;
            _priceRangeLabel.ForeColor = support_info_color;
            _tradeAmountLabel.ForeColor = support_info_color;
            _powerAmountLabel.ForeColor = support_info_color;
            _powerAmountText.TextAlign = ContentAlignment.MiddleRight;
            _priceRangeText.TextAlign = ContentAlignment.MiddleRight;
            _tradeAmountText.TextAlign = ContentAlignment.MiddleRight;
            _pinCodeBox.BackColor = _backColor; _pinCodeBox.ForeColor = _foreColor;
            _pinCodeBox.MaxLength = BRuntimeOpts.MAX_PASSWORD_LENGTH;

            BellagioRoot.OrderDataProvider.StockBuyingPowerInfo.AddListener(new DataThreadToMainThread(ReceiveStockBuyingPowerInfo));
            BellagioRoot.OrderDataProvider.DerivativeBuyingPowerInfo.AddListener(new DataThreadToMainThread(ReceiveDerivativeBuyingPowerInfo));
        }

        public int DefaultPanelHeight {
            get {
                return _defaultPanelHeight;
            }
        }
        public bool IsGridVisible {
            get {
                return _positionDetailListVisible;
            }
        }
        private Label CreateLabelVT(string text) {
            Label l = FormUtil.CreateLabelVT(text);
            l.Font = this.Font;
            l.ForeColor = this.ForeColor;
            l.BackColor = this.BackColor;
            return l;
        }
        private Label CreateLabelVM(string text) {
            Label l = FormUtil.CreateLabel(text);
            l.Font = this.Font;
            l.ForeColor = this.ForeColor;
            l.BackColor = this.BackColor;
            return l;
        }
        private RibbonMenuButton CreateOrderTypeButton(string text, int image_index) {
            RibbonMenuButton b = FormUtil.CreateRibbonMenuButton(text, LargeBitmap(image_index), new MouseEventHandler(OnOrderTypeButtonClick));
            b.Checked = false;
            b.TextAlign = ContentAlignment.BottomCenter;
            return b;
        }
        private RibbonMenuButton CreateBuyOrSellButton(string text, int image_index) {
            RibbonMenuButton b = FormUtil.CreateRibbonMenuButton(text, LargeBitmap(image_index), new MouseEventHandler(OnBuyOrSellButtonClick));
            b.Checked = false;
            b.TextAlign = ContentAlignment.BottomCenter;
            return b;
        }
        private HoveringLabel CreateVolumeChangeLabel(int image_index) {
            IconList il = BellagioRoot.CommonIcons.ControlBoxes;
            HoveringLabel l = new HoveringLabel(il.GetBitmap(0, image_index), il.GetBitmap(1, image_index));
            l.MouseDown += new MouseEventHandler(OnVolumeChangeButtonClick);
            return l;
        }
        private HoveringLabel CreateSashineChangeLabel(int image_index) {
            IconList il = BellagioRoot.CommonIcons.ControlBoxes;
            HoveringLabel l = new HoveringLabel(il.GetBitmap(0, image_index), il.GetBitmap(1, image_index));
            l.MouseDown += new MouseEventHandler(OnSashineChangeButtonClick);
            return l;
        }
        private ComboBox CreateComboBox(params string[] items) {
            ComboBox cb = FormUtil.CreateComboBox(items);
            cb.BackColor = _backColor;
            cb.ForeColor = _foreColor;
            return cb;
        }
        private Button CreateTextCommandButton(string text, EventHandler click) {
            Button b = new Button();
            b.Text = text;
            b.FlatStyle = FlatStyle.System;
            b.Click += click;
            b.Enabled = false;
            return b;
        }

        //L[{[hnh
        protected override bool ProcessDialogKey(Keys keyData) {
            //Debug.WriteLine(keyData.ToString());
            //֗ȃV[gJbgL[𑕔
            Keys k = keyData & Keys.KeyCode;
            if(!_codeBox.Focused && !_pinCodeBox.Focused) { //At@xbgn̓R[h́EÏ؂̓͒
                if(k==Keys.Q && _newOrderGenbutsu.Enabled) OnOrderTypeButtonClick(_newOrderGenbutsu, null);
                if(k==Keys.L && _newOrderCreBuy.Enabled) OnOrderTypeButtonClick(_newOrderCreBuy, null);
                if(k==Keys.S && _newOrderCreSell.Enabled) OnOrderTypeButtonClick(_newOrderCreSell, null);
                if(k==Keys.P && _sashineBox.Enabled) _sashineBox.Focus();
                if(k==Keys.V && _volumeBox.Enabled) _volumeBox.Focus();
            }
            if(k==Keys.F2 && _codeBox.EnabledEx) _codeBox.SelectAllEx();
            if(k==Keys.F3 && _creditTypeBox.Enabled) ToggleCreditTypeBox();
            if(k==Keys.F4 && _nariyukiButton.Enabled) OnNariyukiButtonClick(_nariyukiButton, null);
            if(k==Keys.F5 && _currentPriceButton.Enabled) OnCurrentPriceButtonClick(_currentPriceButton, null);
            //if(k==Keys.F10 && _maxVolumeButton.Enabled) OnMaxVolumeButtonClick(_maxVolumeButton, null);
            if(k==Keys.Add && _sashineBox.Enabled) ChangeSashine(true, false);
            if(k==Keys.Subtract && _sashineBox.Enabled) ChangeSashine(false, false);

            //Escape/Enter̈Ԃ
            if(k==Keys.Escape && _positionDetailList.Focused) {
                return true;
            }
            if(k==Keys.Enter && (_positionDetailList.EditingControl!=null || _codeBox.Focused)) {
                return true;
            }
            return base.ProcessDialogKey(keyData);
        }

        public CommandResult InitContent(OrderFormParameter info) {
            Debug.Assert(this.OrderContentChanged!=null); //Cxgnho^ĂȂƂɂ̂łĂԂ܂ɐݒ
            bool detail_grid_available = false; //ڍו\ObhLǂ

            try {
                _parameter = info;
                IOrderItemFormatter formatter = BellagioRoot.OrderDataProvider.OrderItemFormatter;

                AbstractStockProfile prof = info.StockProfile;
                _stockProfile = prof;
                _currentPriceButton.Enabled = false;
                SetCurrentStock(prof==null? null : prof.Primary);
                if(_layout==LayoutT.IncludeCode) {
                    _codeBox.SetTextExternal(prof==null? "" : CodeDropDownDataProvider.DefaultFormat(prof));
                    _codeBox.LastCorrectText = _codeBox.Text;
                }
                _pinCodeBox.Text = (BellagioRoot.FixedPreferences.AutoPinCode && BellagioRoot.FixedPreferences.PinCodeVerified)? BellagioRoot.FixedPreferences.SavedPinCode : "";
                _savePinCodeBox.Checked = BellagioRoot.FixedPreferences.AutoPinCode;
                _omitConfirmDialogBox.Checked = !BellagioRoot.FixedPreferences.Ordering.ShowOrderConfirmDialog;

                //ԍρEł͐ݒ\ڂI
                if(_parameter.OrderCategory==OrderFormParameter.Category.NewPosition) {
                    TradeOrderItem item = _parameter.CurrentOrder; //ۗ𕜊Ă邱Ƃ邽
                    bool plane = item==null;
                    _codeBox.EnabledEx = true;
                    FormUtil.SetComboBoxCandidates(_marketButton, OrderingUtil.FormatArray<StockExchange>(delegate(StockExchange ex) { return formatter.FormatStockExchange(ex); }, _parameter.GetStockExchangeList()));
                    _marketButton.Enabled = prof!=null;
                    if(_marketButton.Enabled)
                        _marketButton.SelectedIndex = prof!=null && item!=null && prof.Primary.Market!=item.Stock.Market? 1 : 0;
                    bool credit_account = BellagioRoot.OrderDataProvider.AccountInfo.CreditAccountEnabled;
                    _currentPositionOrOrder.Visible = false;
                    _positionDetailList.Visible = false;
                    if(_layout==LayoutT.IncludeCode) {
                        _orderTypeLabel.Text = "(&A)";
                        _newOrderGenbutsu.Visible = _newOrderCreBuy.Visible = _newOrderCreSell.Visible = true;
                        if(!plane) {
                            if(item.DealType==OrderDealType.Genbutsu) _newOrderGenbutsu.Checked = true;
                            else if(item.LongShort==LongShort.Long) _newOrderCreBuy.Checked = true;
                            else _newOrderCreSell.Checked = true;
                        }
                        AdjustCreditLabel();
                        _creditTypeLabel.Visible = _creditTypeBox.Visible = true;
                    }
                    else {
                        _orderTypeLabel.Text = "";
                        if(!plane) {
                            _dealTypeGenbutsu.Checked = item.DealType==OrderDealType.Genbutsu || item.DealType==OrderDealType.Derivatives;
                            _dealTypeSeido.Checked = item.DealType==OrderDealType.CreditSeido;
                            _dealTypeIppan.Checked = item.DealType==OrderDealType.CreditIppan;
                            _buyButton.Checked = item.IsBuying;
                            _sellButton.Checked = !item.IsBuying;
                            _newPositionButton.Enabled = item.DealType!=OrderDealType.Genbutsu;
                            _closePositionButton.Enabled = item.DealType!=OrderDealType.Genbutsu;
                            _newPositionButton.Checked = item.DealType!=OrderDealType.Genbutsu && item.NewOrClose==OrderNewClose.New;
                            _closePositionButton.Checked = item.DealType!=OrderDealType.Genbutsu && item.NewOrClose==OrderNewClose.Close;
                        }
                    }
                    SetSashineBoxEnabled(plane? true : OrderingUtil.IsSashineRequired(item.Condition));
                    _sashineBox.SetTextByInt(plane? (prof==null? 1 : GetInitialSashinePrice(prof.Primary)) : item.AdjustPriceI(item.Sashine));
                    _nariyukiButton.Enabled = true;
                    _volumeBox.Enabled = true;
                    _volumeBox.SetTextByInt(plane? (prof==null? 0 : prof.Primary.VolumeUnit) : item.Volume);
                    _volumeBox.MaximumValue = 100000000;
                    _volumeBox.ZeroFixedDigits = prof==null? 0 : GetZeroDigitsCountFromVolumeUnit(prof.Primary.VolumeUnit);
                    //_maxVolumeButton.Visible = true;
                    //_maxVolumeButton.Enabled = false;
                    _powerAmountText.Visible = true;
                    _sikkoBox.Enabled = true;
                    _sikkoBox.SelectedIndex = plane? 0 : GetSikkoBoxSelectedIndexFromOrderCondition(item.Condition);
                    AdjustKouzaBox(true);
                    _dateBox.SelectedIndex = plane? 0 : (item.LimitDate==OrderLimitDate.Today? 0 : 1); //TODO l͌ŒIȂق
                    _dateBox.Enabled = true;
                    //]͏XV ł敨
                    BellagioRoot.OrderDataProvider.StockBuyingPowerInfo.Refresh();
                }
                else { //܂͌
                    Debug.Assert(prof!=null);
                    _codeBox.EnabledEx = false;
                    FormUtil.SetComboBoxCandidates(_marketButton, OrderingUtil.FormatArray<StockExchange>(delegate(StockExchange ex) { return formatter.FormatStockExchange(ex); }, _parameter.GetStockExchangeList()));

                    bool change = _parameter.OrderCategory==OrderFormParameter.Category.Change; //or
                    bool close = !change;
                    TradeOrderItem order = _parameter.CurrentOrder;
                    TradePositionItem position = _parameter.CurrentPosition;
                    //UIȗ郂[hłMarketButton͎gȂACreateTradeOrderItemUIłmarketButton.SelectedIndexg
                    _marketButton.Enabled = change? false : position.DealType==OrderDealType.Genbutsu;
                    _marketButton.SelectedIndex = (_marketButton.Enabled && order!=null && order.Stock.Profile.Primary!=order.Stock)? 1 : 0;
                    _currentPositionOrOrder.Visible = true;
                    if(_parameter.CloseType==OrderFormParameter.ClosePositionType.MultiplePosition) {
                        detail_grid_available = true;
                        InitPositionDetailListContent(order);
                    }
                    _orderTypeLabel.Text = close? "|WV" : "";
                    if(_layout==LayoutT.IncludeCode) {
                        _newOrderGenbutsu.Visible = _newOrderCreBuy.Visible = _newOrderCreSell.Visible = _creditTypeLabel.Visible = _creditTypeBox.Visible = false;
                        _newOrderGenbutsu.Enabled = _newOrderCreBuy.Enabled = _newOrderCreSell.Enabled = false;
                    }
                    else
                        _dealTypeGenbutsu.Visible = _dealTypeSeido.Visible = _dealTypeIppan.Visible = _buyButton.Visible = _sellButton.Visible = _newPositionButton.Visible = _closePositionButton.Visible = false;
                    if(change)
                        GetOrderTypeButton(order.DealType, order.LongShort).Checked = true;
                    _volumeBox.Enabled = !change; //ł͕ύXs
                    int max_volume = change? order.Volume : _parameter.MaximumVolume;
                    _volumeBox.MaximumValue = max_volume;
                    int volume = order!=null? order.Volume : max_volume;
                    _volumeBox.SetTextByInt(volume);
                    _volumeBox.ZeroFixedDigits = GetZeroDigitsCountFromVolumeUnit(prof.Primary.VolumeUnit);
                    _sikkoBox.Enabled = close;
                    _sikkoBox.SelectedIndex = order==null? 0 : GetSikkoBoxSelectedIndexFromOrderCondition(order.Condition);
                    SetSashineBoxEnabled(order==null? true : OrderingUtil.IsSashineRequired(order.Condition));
                    _sashineBox.SetTextByInt(order==null? GetInitialSashinePrice(prof.Primary) : order.AdjustPriceI(order.Sashine));
                    _nariyukiButton.Enabled = true;
                    _nariyukiButton.Checked = !_sashineBox.Enabled;
                    _powerAmountText.Visible = false;
                    //_maxVolumeButton.Visible = false; //S̓{^͐VK̂
                    _dateBox.Enabled = close;
                    _dateBox.SelectedIndex = order==null? 0 : (order.LimitDate==OrderLimitDate.Today? 0 : 1);
                    AdjustKouzaBox(true);
                    //lɂ̂͂̃\bh`CodeBoxoRSetCurrentStockĂ΂̂łł͕sv
                }

                //ʕ\[hŁAs\Ȃ玩̍𑝂
                _positionDetailList.Visible = _positionDetailListVisible = detail_grid_available;
                ResizeOrderPanel(detail_grid_available); //tH[̒g_ŃTCY@̂ƂɃ{^ςɓ\邪

                if(detail_grid_available) {
                    OnResizeCurrentPositionOrOrder(null, null); //蓮ŌĂԁB_positionDetailList̃TCYݒ肳
                    int h = 96 - _positionDetailList.Height; //̕sB96ŒAƂ͎̂bI
                    if(h > 0) {
                        this.Height += h;
                        ResizeOrderPanel(detail_grid_available); //Ŝ̃TCYς̂łx
                    }
                }

                return CommandResult.Succeeded;
            }
            catch(Exception ex) {
                RuntimeUtil.ReportException(ex);
                return CommandResult.Failed;
            }
        }

        private Stock GetCurrentStock() {
            if(_stockProfile==null)
                return null;
            else if(_parameter.OrderCategory==OrderFormParameter.Category.Change)
                return _parameter.CurrentOrder.Stock;
            else if(!_marketButton.Enabled && _parameter.CurrentPosition!=null)
                return _parameter.CurrentPosition.Stock;
            else
                return _marketButton.SelectedIndex==1? _stockProfile.Secondary : _stockProfile.Primary;
        }

        public void SetCurrentStockExternal(Stock stock) {
            _codeBox.SetTextExternal(CodeDropDownDataProvider.DefaultFormat(stock.Profile));
            SetCurrentStock(stock);
        }

        private void SetCurrentStock(Stock stock) {
            _stockProfile = stock==null? null : stock.Profile;

            IOrderItemFormatter formatter = BellagioRoot.OrderDataProvider.OrderItemFormatter;

            FormUtil.SetComboBoxCandidates(_marketButton, OrderingUtil.FormatArray<StockExchange>(delegate(StockExchange ex) { return formatter.FormatStockExchange(ex); }, stock==null? new StockExchange[0] : stock.Profile.GetStockExhcnageArray()));
            _marketButton.Enabled = true;
            _volumeBox.SetTextByInt(stock==null? 0 : stock.VolumeUnit);
            _volumeBox.MaximumValue = 100000000;
            _volumeBox.ZeroFixedDigits = stock==null? 0 : GetZeroDigitsCountFromVolumeUnit(stock.VolumeUnit);
            AdjustOrderType();

            if(stock!=null) {
                _currentPriceButton.Enabled = true;
                _priceRangeText.Text = "";
                // Debug.WriteLine("GetStockSnapshot");
                BellagioRoot.OrderDataProvider.GetStockSnapshot(stock.Profile, new OrderDataProvider.StockSnapshotDelegate(ReceiveStockSnapshot)); //lXVɂ
                AdjustPowerAmountInfo();
            }
            else {
                _currentPriceButton.Enabled = false;
                _priceRangeText.Text = "";
            }
            AdjustTradeAmountLabel();
        }

        private RibbonMenuButton GetOrderTypeButton(OrderDealType deal, LongShort ls) {
            //Iv̂Ƃ͌EMp{^ŔE
            switch(deal) {
                case OrderDealType.Genbutsu:
                    return _newOrderGenbutsu;
                case OrderDealType.CreditSeido:
                case OrderDealType.CreditIppan:
                    return ls==LongShort.Long? _newOrderCreBuy : _newOrderCreSell;
                case OrderDealType.Derivatives:
                    return ls==LongShort.Long? _newOrderGenbutsu : _newOrderCreSell; ;
            }
            Debug.Assert(false);
            return null;
        }
        private int GetSikkoBoxSelectedIndexFromOrderCondition(OrderCondition cond) {
            if(cond==OrderCondition.Sashine || cond==OrderCondition.Nariyuki)
                return 0; //Ȃ
            else if(cond==OrderCondition.Sashinari)
                return 3; //w
            else if(cond==OrderCondition.Hikenari || cond==OrderCondition.Hikesashi)
                return 2; //Q
            else //if(cond==OrderCondition.Yorinari || cond==OrderCondition.Yorisashi)
                return 1; //t
        }
        private OrderCondition SikkoBoxIndexToOrderCondition(int index, bool nariyuki) {
            if(index==0)
                return nariyuki? OrderCondition.Nariyuki : OrderCondition.Sashine;
            else if(index==1)
                return nariyuki? OrderCondition.Yorinari : OrderCondition.Yorisashi;
            else if(index==2)
                return nariyuki? OrderCondition.Hikenari : OrderCondition.Hikesashi;
            else
                return OrderCondition.Sashinari;
        }
        private void OnMarketChanged(object sender, EventArgs args) {
            AdjustOrderType();
            this.OrderContentChanged();
        }
        private void OnOrderTypeButtonClick(object sender, MouseEventArgs args) {
            RibbonMenuButton b = (RibbonMenuButton)sender;
            //͕KvȂƂ̂ݎs
            if(b.Checked) return;

            _newOrderGenbutsu.Checked = b==_newOrderGenbutsu;
            _newOrderCreBuy.Checked = b==_newOrderCreBuy;
            _newOrderCreSell.Checked = b==_newOrderCreSell;
            AdjustCreditLabel();
            AdjustPowerAmountInfo();
            this.OrderContentChanged();
        }
        private void OnBuyOrSellButtonClick(object sender, MouseEventArgs args) {
            RibbonMenuButton b = (RibbonMenuButton)sender;
            //͕KvȂƂ̂ݎs
            if(b.Checked) return;
            _buyButton.Checked = b==_buyButton;
            _sellButton.Checked = b==_sellButton;
            AdjustPowerAmountInfo();
            this.OrderContentChanged();
        }
        private void OnDealTypeCheckedChanged(object sender, EventArgs args) {
            _dealTypeGenbutsu.Checked = sender==_dealTypeGenbutsu;
            _dealTypeSeido.Checked = sender==_dealTypeSeido;
            _dealTypeIppan.Checked = sender==_dealTypeIppan;
            Stock stock = GetCurrentStock();
            if((stock==null || !stock.Profile.IsDerivative) && _dealTypeGenbutsu.Checked) {
                _newPositionButton.Enabled = false;
                _closePositionButton.Enabled = false;
                _newPositionButton.Checked = false;
                _closePositionButton.Checked = false;
            }
            else { //Mp
                _newPositionButton.Enabled = true;
                _closePositionButton.Enabled = true;
                if(!_newPositionButton.Checked && !_closePositionButton.Checked)
                    _newPositionButton.Checked = true; //MpɕςƂ͐VKftHg
            }
            AdjustPowerAmountInfo();
            this.OrderContentChanged();
        }
        private void OnNewOrCloseCheckedChanged(object sender, EventArgs args) {
            _newPositionButton.Checked = sender==_newPositionButton;
            _closePositionButton.Checked = sender==_closePositionButton;
            AdjustPowerAmountInfo();
            this.OrderContentChanged();
        }

        private void AdjustOrderType() {
            if(_layout==LayoutT.IncludeCode) {
                if(_stockProfile!=null && OrderingUtil.IsFutureOrOption(_stockProfile.Flags)) {
                    _newOrderGenbutsu.Enabled = false;
                    _newOrderGenbutsu.Checked = false;
                    _newOrderCreBuy.Enabled = true;
                    _newOrderCreBuy.Text = "VK";
                    _newOrderCreSell.Enabled = true;
                    _newOrderCreSell.Text = "VK";
                }
                else {
                    Stock stock = GetCurrentStock();
                    bool credit_account = BellagioRoot.OrderDataProvider.AccountInfo.CreditAccountEnabled;
                    _newOrderCreBuy.Text = "Mp";
                    _newOrderCreSell.Text = "Mp";
                    _newOrderGenbutsu.Enabled = true;
                    _newOrderCreBuy.Enabled = credit_account && (stock==null || (stock.StockFlags & (StockFlags.Seido|StockFlags.Ippan))!=StockFlags.None);
                    _newOrderCreSell.Enabled =  credit_account && (stock==null || (stock.StockFlags & StockFlags.Taisyaku)!=StockFlags.None);

                    //Mp`FbNO
                    if(!_newOrderCreBuy.Enabled && _newOrderCreBuy.Checked) { _newOrderCreBuy.Checked = false; _newOrderGenbutsu.Checked = true; }
                    if(!_newOrderCreSell.Enabled && _newOrderCreSell.Checked) { _newOrderCreSell.Checked = false; _newOrderGenbutsu.Checked = true; }
                }
                _newOrderCreBuy.Invalidate(); //Ȃƕ\܂Ȃ
                _newOrderCreSell.Invalidate();
                _newOrderGenbutsu.Invalidate();
                AdjustCreditLabel();
            }
            else {
                bool credit_account = BellagioRoot.OrderDataProvider.AccountInfo.CreditAccountEnabled;
                Stock stock = GetCurrentStock();
                if(_stockProfile!=null && OrderingUtil.IsFutureOrOption(_stockProfile.Flags)) {
                    _dealTypeGenbutsu.Text = "ʏ";
                    _dealTypeSeido.Visible = _dealTypeIppan.Visible = false;
                    _dealTypeGenbutsu.Checked = true;
                    _dealTypeSeido.Checked = _dealTypeIppan.Checked = false;
                    _newPositionButton.Enabled = _closePositionButton.Enabled = true;
                }
                else {
                    _dealTypeGenbutsu.Text = "";
                    _dealTypeSeido.Visible = _dealTypeIppan.Visible = true;
                    _dealTypeSeido.Enabled = credit_account && (stock==null || (stock.StockFlags & (StockFlags.Seido|StockFlags.Taisyaku))!=StockFlags.None);
                    _dealTypeIppan.Enabled = credit_account && (stock==null || (stock.StockFlags & StockFlags.Ippan)!=StockFlags.None);
                    //Mp`FbNO
                    if(!_dealTypeSeido.Enabled && _dealTypeSeido.Checked) { _dealTypeSeido.Checked = false; _dealTypeGenbutsu.Checked = true; }
                    if(!_dealTypeIppan.Enabled && _dealTypeIppan.Checked) { _dealTypeIppan.Checked = false; _dealTypeGenbutsu.Checked = true; }
                    _newPositionButton.Enabled = _closePositionButton.Enabled = !_dealTypeGenbutsu.Checked;
                    if(!_newPositionButton.Enabled && _newPositionButton.Checked) _newPositionButton.Checked = false;
                    if(!_closePositionButton.Enabled && _closePositionButton.Checked) _closePositionButton.Checked = false;
                }

            }

            AdjustKouzaBox(false);
        }
        private void AdjustCreditLabel() {
            Stock st = GetCurrentStock();
            if(st!=null && !OrderingUtil.IsFutureOrOption(st.Profile.Flags) && !_newOrderGenbutsu.Checked) {
                StockFlags f = st.StockFlags & (StockFlags.Seido | StockFlags.Ippan);
                if(f!=StockFlags.None) { //炩̗LȐMp}XN
                    _creditTypeBox.Items.Clear();
                    _creditTypeBox.Items.Add("x");
                    _creditTypeBox.Items.Add("");
                    if(_newOrderCreSell.Checked || f==StockFlags.Seido) { //Mp݂Ƃ͎Iɐx
                        _creditTypeBox.SelectedIndex = 0;
                        _creditTypeBox.Enabled = false;
                    }
                    else if(f==StockFlags.Ippan) {
                        _creditTypeBox.SelectedIndex = 1;
                        _creditTypeBox.Enabled = false;
                    }
                    else { //w\
                        _creditTypeBox.Enabled = true;
                        TradeOrderItem item = _parameter.CurrentOrder;
                        _creditTypeBox.SelectedIndex = item!=null && item.DealType==OrderDealType.CreditIppan? 1 : 0;
                    }
                    return;
                }
            }

            //ȏꍇ
            _creditTypeBox.Items.Clear();
            _creditTypeBox.Items.Add("--");
            _creditTypeBox.Enabled = false;
            _creditTypeBox.SelectedIndex = 0;
        }
        private void AdjustKouzaBox(bool for_init_content) {
            Stock st = GetCurrentStock();
            if(st==null || OrderingUtil.IsFutureOrOption(st.Profile.Flags)) {
                _kouzaBox.Items.Clear();
                _kouzaBox.Items.Add("--");
                _kouzaBox.Enabled = false;
                _kouzaBox.SelectedIndex = 0;
            }
            else {
                int old_index = _kouzaBox.SelectedIndex;
                _kouzaBox.Items.Clear();
                _kouzaBox.Items.Add("");
                _kouzaBox.Items.Add("");
                if(_parameter.OrderCategory==OrderFormParameter.Category.NewPosition) {
                    if(BellagioRoot.DataSourceHost.ExternalEnvironment.AccountInfo.TokuteiKouzaAvailable) {
                        _kouzaBox.Enabled = true;
                        TradeOrderItem item = _parameter.CurrentOrder;
                        if(for_init_content) //ŏ̏
                            _kouzaBox.SelectedIndex = item!=null && item.Kouza==OrderKouza.Ippan? 1 : 0;
                        else
                            _kouzaBox.SelectedIndex = old_index==1? 1 : 0; //old_index==-1肤
                    }
                    else {
                        _kouzaBox.Enabled = false;
                        _kouzaBox.SelectedIndex = 1;
                    }
                }
                else {
                    _kouzaBox.Enabled = false;
                    _kouzaBox.SelectedIndex = (_parameter.OrderCategory==OrderFormParameter.Category.ClosePosition? _parameter.CurrentPosition.OrderKouza : _parameter.CurrentOrder.Kouza)==OrderKouza.Tokutei? 0 : 1;
                }
            }
        }
        private void OnStockChanged(object sender, EventArgs args) {
            AbstractStockProfile stock = BellagioRoot.GlobalStockCollection.FindExact(_codeBox.CurrentItem.Code);
            SetCurrentStock(stock.Primary);
            this.OrderContentChanged();
            if(this.StockChanged!=null) this.StockChanged(stock);
        }
        /*
        private void OnMaxVolumeButtonClick(object sender, EventArgs args) {
            if(_stockProfile==null) return;

            //S̓{^@̂Ƃ̒ԂɉĒ\ő吔ʂZbg
            //case1 敨
            if(_stockProfile.IsDerivative) {
                DerivativeBuyingPowerInfo info = BellagioRoot.OrderDataProvider.DerivativeBuyingPowerInfo.Value;
                if(info==null) return;
                //͊ȒPB]͏ɔ\Ă
                _volumeBox.SetTextByInt(info.GetMaxVolumeFor((DerivativeStockProfile)_stockProfile, _otCreSell.Checked? LongShort.Short : LongShort.Long));
            }
            else  { //case2 Mp
                StockBuyingPowerInfo info = BellagioRoot.OrderDataProvider.StockBuyingPowerInfo.Value;
                if(info==null) return;

                //TODO l悤ɂȂAsŵƂ͎wl̒lłȂlŌvZ
                int vol = (int)(((_otCreBuy.Checked || _otCreSell.Checked)? info.Credit : info.Genbutsu) / (_sashineBox.GetTextAsInt()));
                int unit = _stockProfile==null? 1000 : _stockProfile.VolumeUnit;
                vol -= vol % unit; //܂؂̂

                _volumeBox.SetTextByInt(vol);
            }

        }
        */

        //wlύX
        private void OnSashineChangeButtonClick(object sender, MouseEventArgs args) {
            if(args.Button!=MouseButtons.Left) return;

            if(sender==_sashineDec10) ChangeSashine(false, true);
            else if(sender==_sashineDec) ChangeSashine(false, false);
            else if(sender==_sashineInc) ChangeSashine(true, false);
            else if(sender==_sashineInc10) ChangeSashine(true, true);

            this.OrderContentChanged();

        }
        private void OnMouseWheelSashine(object sender, MouseEventArgs args) {
            ChangeSashine(args.Delta>0, false);
            this.OrderContentChanged();
        }
        public void SetSashineExternal(int price) {
            _nariyukiButton.Checked = false;
            SetSashineBoxEnabled(true);
            _sashineBox.SetTextByInt(price);
            AdjustTradeAmountLabel();
        }
        private void ChangeSashine(bool increment, bool ten_times) {
            if(!_sashineBox.Enabled) return;
            int price = _sashineBox.GetTextAsInt();

            if(ten_times) {
                for(int i=0; i<10; i++)
                    price = increment? YobineIncrement(_stockProfile, price) : YobineDecrement(_stockProfile, price);
            }
            else
                price = increment? YobineIncrement(_stockProfile, price) : YobineDecrement(_stockProfile, price);

            if(price < 1) price = 1;
            if(price > _sashineBox.MaximumValue) price = _sashineBox.MaximumValue;
            _sashineBox.SetTextByInt(price);

            AdjustTradeAmountLabel();
        }

        //̌Ăђl܂ő/B敨E~ĵƂ͒ʏƈႤ̂ŕʈ
        private static int YobineIncrement(AbstractStockProfile s, int p) {
            DerivativeStockProfile d = s as DerivativeStockProfile;
            if(d!=null) {
                int step = d.Brand==DerivativeStockProfile.BrandT.NikkeiFuture? 10 : 5;
                return p - (p % step) + step; //[͐؂̂
            }
            else
                return MarketUtil.YobineIncrement(p);
        }
        private static int YobineDecrement(AbstractStockProfile s, int p) {
            DerivativeStockProfile d = s as DerivativeStockProfile;
            if(d!=null) {
                int step = d.Brand==DerivativeStockProfile.BrandT.NikkeiFuture? 10 : 5;
                return p - (p % step) - step; //[͐؂̂
            }
            else
                return MarketUtil.YobineDecrement(p);
        }

        private void OnNariyukiButtonClick(object sender, EventArgs args) {
            bool c = _nariyukiButton.Checked; //̓{ǂŕω
            _nariyukiButton.Checked = c;
            SetSashineBoxEnabled(!c);
            AdjustTradeAmountLabel();
            this.OrderContentChanged();
        }

        private void ToggleCreditTypeBox() {
            _creditTypeBox.SelectedIndex = _creditTypeBox.SelectedIndex==0? 1 : 0;
        }

        private void AdjustTradeAmountLabel() {
            Stock stock = GetCurrentStock();
            if(!_nariyukiButton.Checked && stock!=null) {
                int sashine = _sashineBox.GetTextAsInt();
                int volume = _volumeBox.GetTextAsInt();
                if(sashine!=0 && volume!=0) {
                    long p = volume;
                    p = p * sashine * stock.Profile.ImplicitPriceFactor;
                    _tradeAmountText.Text = String.Format("{0:N0}~", p);
                    return;
                }
            }

            _tradeAmountText.Text = "";
        }


        //lEXV
        private void ReceiveStockSnapshot(AsyncOpResult result, OrderDataStockSnapshot snapshot) {
            try {
                _priceRangeText.Text = ""; //܂Zbg

                if(result==AsyncOpResult.Succeeded) {
                    if(snapshot.UpperLimitPrice!=OrderDataStockSnapshot.EMPTY_VALUE && snapshot.LowerLimitPrice!=OrderDataStockSnapshot.EMPTY_VALUE) {
                        _priceRangeText.Text = String.Format("{0:N0} - {1:N0}~", snapshot.LowerLimitPrice, snapshot.UpperLimitPrice);
                    }

                    //̌lŁAƂ(Aۗ̕)͎wl}͂Ȃ
                    if(snapshot.CurrentPrice!=OrderDataStockSnapshot.EMPTY_VALUE &&
                        (_parameter.CurrentOrder==null || "manualUpdatePrice".Equals(_currentPriceButton.Tag))) {
                        _sashineBox.SetTextByInt(snapshot.CurrentPrice);
                        _sashineBox.Focus();
                        _nariyukiButton.Checked = false;
                        SetSashineBoxEnabled(true);
                        this.OrderContentChanged();
                    }
                }

                _currentPriceButton.Tag = null;
                _currentPriceButton.Enabled = true;
                _stockSnapshot = snapshot;
                AdjustTradeAmountLabel();
            }
            catch(Exception ex) {
                Debug.WriteLine(ex.Message);
                Debug.WriteLine(ex.StackTrace);
            }
        }
        private void OnCurrentPriceButtonClick(object sender, EventArgs args) {
            if(_stockProfile==null) return;

            _currentPriceButton.Enabled = false;
            //ݒl{^Ƃ̍XVƂłȂXV_currentPriceButton.Tagŋʂ
            _currentPriceButton.Tag = "manualUpdatePrice";
            BellagioRoot.OrderDataProvider.GetStockSnapshot(_stockProfile, new OrderDataProvider.StockSnapshotDelegate(ReceiveStockSnapshot));
        }

        //ʕύX
        private void OnVolumeChangeButtonClick(object sender, MouseEventArgs args) {
            if(args.Button!=MouseButtons.Left) return;

            if(sender==_volumeDec10) ChangeVolume(false, true);
            else if(sender==_volumeDec) ChangeVolume(false, false);
            else if(sender==_volumeInc) ChangeVolume(true, false);
            else if(sender==_volumeInc10) ChangeVolume(true, true);

            this.OrderContentChanged();
        }
        private void OnMouseWheelVolume(object sender, MouseEventArgs args) {
            ChangeVolume(args.Delta>0, false);
            this.OrderContentChanged();
        }
        private void ChangeVolume(bool increment, bool ten_times) {
            if(!_volumeBox.Enabled) return;

            int volume = _volumeBox.GetTextAsInt();
            int u = _stockProfile==null? 1 : _stockProfile.Primary.VolumeUnit;
            int add = u;
            if(ten_times) add *= 10;
            if(!increment) add *= -1;

            volume += add;

            if(volume < u) volume = u;
            if(volume > _volumeBox.MaximumValue) volume = _volumeBox.MaximumValue;

            _volumeBox.SetTextByInt(volume);
            AdjustVolumeInGrid(volume);

            AdjustTradeAmountLabel();
        }
        private void OnPaintCurrentPositionOrOrder(object sender, PaintEventArgs args) {
            try {
                if(_parameter==null) return;

                IOrderItemFormatter fmt = BellagioRoot.OrderDataProvider.OrderItemFormatter;
                Font f = _currentPositionOrOrder.Font; //ftHgtHg, uV
                Brush b = SystemBrushes.WindowText;
                Graphics g = args.Graphics;
                //PsڂɎʁAQsڂɐʁARsڂɒP{\

                if(_parameter.OrderCategory==OrderFormParameter.Category.ClosePosition) {
                    TradePositionItem pos = _parameter.CurrentPosition;
                    int volume = _parameter.CloseType==OrderFormParameter.ClosePositionType.MultiplePosition? pos.TotalVolume : _parameter.PositionElement.Volume;
                    bool multiple = pos.DealType!=OrderDealType.Genbutsu && _parameter.CloseType==OrderFormParameter.ClosePositionType.MultiplePosition;

                    int x = 0;
                    int y = 0;
                    DrawingUtil.DrawStringToRight(g, FormatCurrentPosition(fmt, pos), f, OrderingUtil.IsLong(pos.LongShort)? _buyMarkBrush : _sellMarkBrush, ref x, y);
                    if(pos.DealType!=OrderDealType.Genbutsu && !multiple) {
                        DrawingUtil.DrawStringToRight(g, "     ", f, b, ref x, y);
                        DrawingUtil.DrawStringToRight(g, BDate.FormatYYMMDD(_parameter.PositionElement.Date), f, b, ref x, y);
                    }

                    x = 0;
                    y = DrawingUtil.GetFontHeightAsInt(f, g);
                    DrawingUtil.DrawStringToRight(g, pos.DealType==OrderDealType.Genbutsu? "ۗL " : "ʐ ", f, b, ref x, y);
                    DrawingUtil.DrawStringToRight(g, volume.ToString("N0"), _figureFont, _figureBrush, ref x, y + _figureFontYOffset);
                    DrawingUtil.DrawStringToRight(g, pos.Stock.Profile.VolumeUnitString, f, b, ref x, y);
                    if(pos.TotalOrderingVolume!=0) {
                        DrawingUtil.DrawStringToRight(g, "( ", f, b, ref x, y);
                        DrawingUtil.DrawStringToRight(g, pos.TotalOrderingVolume.ToString(), _figureFont, _figureBrush, ref x, y + _figureFontYOffset);
                        DrawingUtil.DrawStringToRight(g, pos.Stock.Profile.VolumeUnitString, f, b, ref x, y);
                        DrawingUtil.DrawStringToRight(g, ")", f, b, ref x, y);
                    }

                    if(_parameter.CloseType==OrderFormParameter.ClosePositionType.SpecifiedElement) {
                        x = 0;
                        y += DrawingUtil.GetFontHeightAsInt(f, g);
                        DrawingUtil.DrawStringToRight(g, pos.DealType==OrderDealType.Genbutsu? "擾P " : "P@ ", f, b, ref x, y);
                        string price = (_parameter.PositionElement.Price100/100).ToString("N0");
                        DrawingUtil.DrawStringToRight(g, price, _figureFont, _figureBrush, ref x, y + _figureFontYOffset);
                        DrawingUtil.DrawStringToRight(g, "~", f, b, ref x, y);
                    }
                }
                else if(_parameter.OrderCategory==OrderFormParameter.Category.Change) {
                    TradeOrderItem order = _parameter.CurrentOrder;
                    int x = 0;
                    int y = 0;
                    Brush br = order.IsBuying? _buyMarkBrush : _sellMarkBrush;
                    DrawingUtil.DrawStringToRight(g, order.DealType==OrderDealType.Genbutsu? "" : OrderingUtil.IsShinnyo(order.DealType)? "Mp" : "", f, br, ref x, y);
                    DrawingUtil.DrawStringToRight(g, fmt.FormatTradeDescription(order.DealType, order.LongShort, order.NewOrClose), f, br, ref x, y);
                    if(OrderingUtil.IsShinnyo(order.DealType)) {
                        DrawingUtil.DrawStringToRight(g, "(", f, br, ref x, y);
                        DrawingUtil.DrawStringToRight(g, fmt.FormatShinnyoKubun(order.DealType), f, br, ref x, y);
                        DrawingUtil.DrawStringToRight(g, ")", f, br, ref x, y);
                    }

                    x = 0;
                    y += DrawingUtil.GetFontHeightAsInt(f, g);
                    DrawingUtil.DrawStringToRight(g, " ", f, b, ref x, y);
                    DrawingUtil.DrawStringToRight(g, order.Volume.ToString("N0"), _figureFont, _figureBrush, ref x, y + _figureFontYOffset);
                    DrawingUtil.DrawStringToRight(g, order.Stock.Profile.VolumeUnitString, f, b, ref x, y);
                    if(order.TradedVolume!=0) {
                        PartialTradeDisplay pd = BellagioRoot.FixedPreferences.Ordering.PartialTradeDisplay;
                        int partial_vol = pd==PartialTradeDisplay.Traded? order.TradedVolume : order.Volume - order.TradedVolume;
                        DrawingUtil.DrawStringToRight(g, pd==PartialTradeDisplay.Traded? "( " : "( ", f, b, ref x, y);
                        DrawingUtil.DrawStringToRight(g, partial_vol.ToString("N0"), _figureFont, _figureBrush, ref x, y + _figureFontYOffset);
                        DrawingUtil.DrawStringToRight(g, order.Stock.Profile.VolumeUnitString, f, b, ref x, y);
                        DrawingUtil.DrawStringToRight(g, ")", f, b, ref x, y);
                    }

                    x = 0;
                    y += DrawingUtil.GetFontHeightAsInt(f, g);
                    DrawingUtil.DrawStringToRight(g, fmt.FormatOrderCondition(order.Condition), f, b, ref x, y);
                    if(OrderingUtil.IsSashineRequired(order.Condition)) {
                        x += 5;
                        DrawingUtil.DrawStringToRight(g, order.AdjustPriceI(order.Sashine).ToString("N0"), _figureFont, _figureBrush, ref x, y + _figureFontYOffset);
                        DrawingUtil.DrawStringToRight(g, "~", f, b, ref x, y);
                    }
                    if(OrderingUtil.IsTriggerAvailable(order.TriggerType)) {
                        DrawingUtil.DrawStringToRight(g, "  (twl ", f, b, ref x, y);
                        DrawingUtil.DrawStringToRight(g, order.AdjustPriceI(order.TriggerPrice).ToString("N0"), _figureFont, _figureBrush, ref x, y + _figureFontYOffset);
                        DrawingUtil.DrawStringToRight(g, "~", f, b, ref x, y);
                        DrawingUtil.DrawStringToRight(g, order.TriggerType==OrderTriggerType.UpperBreak? "ȏ)" : "ȉ)", f, b, ref x, y);
                    }
                }
            }
            catch(Exception ex) {
                RuntimeUtil.ReportException(ex);
            }
        }
        private string FormatCurrentPosition(IOrderItemFormatter fmt, TradePositionItem pos) {
            StringBuilder bld = new StringBuilder();
            bld.Append(fmt.FormatPosition(pos.DealType, pos.LongShort));
            if(OrderingUtil.IsShinnyo(pos.DealType)) {
                bool change = _parameter.OrderCategory==OrderFormParameter.Category.Change;
                //ύXƕԍςŐMp̕قȂ
                bld.Append(" (").Append(change? fmt.FormatShinnyoKubun(pos.DealType) : fmt.FormatShinnyoKigen(pos.DealType)).Append(")");
            }
            return bld.ToString();
        }


        //ԍς̌ʏڍ׊֌WUI
        private const int VOLUME_COLUMN = 3;
        private DataGridView CreatePositionDetailListView() {
            BellagioDataGrid g = new BellagioDataGrid();
            g.ColumnCount = 4;
            g.Font = new Font(FontFamily.GenericSerif, 8);
            g.ColumnHeadersDefaultCellStyle.Font = new Font(FontFamily.GenericSerif, 8.0F);
            g.EditMode = DataGridViewEditMode.EditOnEnter|DataGridViewEditMode.EditOnF2;
            g.ColumnHeadersHeightSizeMode = DataGridViewColumnHeadersHeightSizeMode.DisableResizing;
            g.AllowUserToAddRows = false;
            g.AllowUserToDeleteRows = false;
            g.RowHeadersVisible = false;
            g.ColumnHeadersBorderStyle = DataGridViewHeaderBorderStyle.Raised;
            g.CellBeginEdit += new DataGridViewCellCancelEventHandler(OnBeforePositionDetailEdit);
            g.CellValidated += new DataGridViewCellEventHandler(OnAfterPositionDetailEdit);
            g.CellValidating += new DataGridViewCellValidatingEventHandler(OnValidatingPositionDetailEdit);
            g.PrivateMouseWheel = new BellagioDataGrid.MouseWheelDelegate(OnDataGridMouseWheel);
            g.ScrollBars = ScrollBars.Vertical;
            SetDataGridColumn(g, 0, "", 60, false);
            SetDataGridColumn(g, 1, "P", 48, false);
            SetDataGridColumn(g, 2, "\", 66, false);
            SetDataGridColumn(g, 3, "", 66, true);

            return g;
        }
        private void SetDataGridColumn(DataGridView g, int index, string text, int width, bool editable) {
            DataGridViewColumn c = g.Columns[index];
            c.HeaderText = text;
            c.Width = width;
            c.ValueType = typeof(string);
            if(!editable)
                c.DefaultCellStyle.BackColor = Color.LightGray;
        }
        //ۗ玝Ăꍇ̂current_order
        private void InitPositionDetailListContent(TradeOrderItem current_order) {
            PositionAndVolumeList ordering_positions = current_order==null? null : current_order.ClosePositionDetail;
            _positionDetailList.CancelEdit();
            _positionDetailList.Rows.Clear();
            _positionDetailList.BringToFront();
            object x = null;
            bool buying = _parameter.CurrentPosition.LongShort==LongShort.Long; //̓|WVOǂ
            List<TradePositionItem.Element> elements = _parameter.CurrentPosition.ElementCollectionCopy();
            elements.Sort(delegate(TradePositionItem.Element e1, TradePositionItem.Element e2) {
                if(e1.DateAsInt!=e2.DateAsInt)
                    return e1.DateAsInt - e2.DateAsInt; //܂tD
                else if(buying)
                    return e2.Price100 - e1.Price100; //tȂP
                else
                    return e1.Price100 - e2.Price100;
            });
            for(int i=0; i<elements.Count; i++) {
                TradePositionItem.Element e = elements[i];
                int left_vol = e.Volume-e.OrderingVolume;
                int initial_vol = ordering_positions==null? left_vol : Math.Min(left_vol, ordering_positions.Find(e.UniqueID));
                _positionDetailList.Rows.Add(BDate.FormatYYMMDD(e.Date), (e.Price100/100).ToString(), left_vol.ToString(), initial_vol.ToString());
                DataGridViewRow r = _positionDetailList.Rows[_positionDetailList.Rows.Count-1];
                r.Resizable = DataGridViewTriState.False;
                r.Tag = e;
                x = r.Cells[3].Value;
            }
        }
        private void OnResizeCurrentPositionOrOrder(object sender, EventArgs args) {
            _positionDetailList.Location = new Point(_currentPositionOrOrder.Left, _currentPositionOrOrder.Top + 32);
            _positionDetailList.Size = new Size(_currentPositionOrOrder.Width-4, _currentPositionOrOrder.Height - 32);
        }
        private void ResizeOrderPanel(bool detail_grid_visible) {
            if(detail_grid_visible) //_positionDetailList.Visible ́AFormĂȂƏɔ\
                _gridMainRectOp.Rect(this.ClientRectangle);
            else
                _regularMainRectOp.Rect(this.ClientRectangle);
            //Ƃ͊evf
            _codeBoxRectOp.Rect(_codeBoxRect.Value);
            _positionOrDealTypeRectOp.Rect(_positionOrDealTypeRect.Value);
            _priceAndVolumeRectOp.Rect(_priceAndVolumeRect.Value);
        }
        protected override void OnResize(EventArgs args) {
            base.OnResize(args);
            ResizeOrderPanel(_positionDetailListVisible);
        }

        private void OnBeforePositionDetailEdit(object sender, DataGridViewCellCancelEventArgs args) {
            if(args.ColumnIndex!=VOLUME_COLUMN) args.Cancel = true;
        }
        private void OnAfterPositionDetailEdit(object sender, DataGridViewCellEventArgs args) {
            if(args.ColumnIndex!=VOLUME_COLUMN) return;
            //g[^ʂA
            _volumeBox.SetTextByInt(GetTotalVolumeInGrid());
            this.OrderContentChanged();
        }
        private int GetTotalVolumeInGrid() {
            int vol = 0;
            for(int i=0; i<_positionDetailList.Rows.Count; i++) {
                DataGridViewCell cell = _positionDetailList.Rows[i].Cells[VOLUME_COLUMN];
                vol += Int32.Parse((string)cell.Value);
            }
            return vol;
        }
        private void OnValidatingPositionDetailEdit(object sender, DataGridViewCellValidatingEventArgs args) {
            if(args.ColumnIndex!=VOLUME_COLUMN || !_positionDetailList.Visible) return; //VKJȂƂȂǁAĂȂ̂ɃCxg邱Ƃ

            DataGridViewRow row = _positionDetailList.Rows[args.RowIndex];
            DataGridViewCell cell = row.Cells[args.ColumnIndex];
            row.ErrorText = "";

            int value;
            if(!Int32.TryParse((string)args.FormattedValue, out value)) {
                args.Cancel = true;
                BUtil.ShowWarningMessageBox("l͂Ă");
                return;
            }
            TradePositionItem.Element elem = row.Tag as TradePositionItem.Element;
            if(value < 0 || value > (elem.Volume-elem.OrderingVolume)) {
                args.Cancel = true;
                BUtil.ShowWarningMessageBox("LȐlł͂܂");
                return;
            }

            if(value % _stockProfile.VolumeUnit != 0) { //Pʊ̂܂
                args.Cancel = true;
                BUtil.ShowWarningMessageBox("Pʊ̔{͂Ă");
                return;
            }
        }
        //}EXzC[ł̐ʕύX݂
        private bool OnDataGridMouseWheel(int delta) {
            if(_positionDetailList.EditingControl!=null) return false;

            DataGridViewSelectedCellCollection c = _positionDetailList.SelectedCells;
            if(c.Count!=1) return false;
            DataGridViewCell cell = c[0];
            if(cell.ColumnIndex!=VOLUME_COLUMN) return false;

            TradePositionItem.Element elem = cell.OwningRow.Tag as TradePositionItem.Element;
            int vol = Int32.Parse((string)cell.Value);
            int unit = _stockProfile.VolumeUnit;
            vol = delta>0? vol + unit : vol - unit;
            if(vol < 0) vol = 0;
            else if(vol > (elem.Volume-elem.OrderingVolume)) vol = (elem.Volume-elem.OrderingVolume);

            cell.Value = vol.ToString();
            //ŜA
            _volumeBox.SetTextByInt(GetTotalVolumeInGrid());
            this.OrderContentChanged();
            AdjustTradeAmountLabel();
            return true;
        }

        private void AdjustVolumeInGrid(int newvalue) {
            if(_parameter.OrderCategory!=OrderFormParameter.Category.ClosePosition || _parameter.CloseType!=OrderFormParameter.ClosePositionType.MultiplePosition) return;
            Debug.Assert(_positionDetailList.Visible);

            int left = newvalue - GetTotalVolumeInGrid();
            if(left==0) return;

            //̗񂩂ύX
            for(int i=_positionDetailList.Rows.Count-1; i>=0; i--) {
                DataGridViewRow r = _positionDetailList.Rows[i];
                DataGridViewCell cell = r.Cells[VOLUME_COLUMN];
                int vol = Int32.Parse((string)cell.Value);
                if(left > 0) { //ʑ
                    int add = Math.Min(left, ((TradePositionItem.Element)r.Tag).Volume - vol);
                    cell.Value = (vol + add).ToString();
                    left -= add;
                }
                else if(left < 0) { //ʌ
                    int sub = Math.Min(-left, vol);
                    cell.Value = (vol - sub).ToString();
                    left += sub;
                }
                if(left==0) break;
            }

        }
        private PositionAndVolumeList CreatePositionAndVolumeList() {
            PositionAndVolumeList l = new PositionAndVolumeList();
            //Debug.Assert(_positionDetailList.Visible);
            for(int i=0; i<_positionDetailList.Rows.Count; i++) {
                DataGridViewRow row = _positionDetailList.Rows[i];
                DataGridViewCell cell = row.Cells[VOLUME_COLUMN];
                int vol = Int32.Parse((string)cell.Value);
                if(vol!=0) l.Add(((TradePositionItem.Element)row.Tag).UniqueID, vol);
            }
            return l;
        }

        private void SetSashineBoxEnabled(bool value) {
            _nariyukiButton.Checked = !value;
            _nariyukiButton.Image = BellagioRoot.CommonIcons.SmallCommandButtons.GetBitmap(_nariyukiButton.Checked? 5 : 6);
            _sashineBox.Enabled = value;
            _sashineBox.BackColor = value? _backColor : Color.FromArgb(64, 64, 64);
            _sashineBox.ForeColor = value? _foreColor : Color.Black;
        }
        private void ReceiveStockBuyingPowerInfo() {
            if(this.IsDisposed || !this.Visible) return;
            AdjustPowerAmountInfo();
            if(BellagioRoot.OrderDataProvider.StockBuyingPowerInfo.Value!=null)
                BellagioRoot.OrderDataProvider.DerivativeBuyingPowerInfo.Refresh();
        }
        private void ReceiveDerivativeBuyingPowerInfo() {
            if(this.IsDisposed || !this.Visible) return;
            AdjustPowerAmountInfo();
        }
        //ReLXgj[
        private void OnContextMenu(object sender, MouseEventArgs e) {
            base.OnMouseUp(e);
            if(e.Button==MouseButtons.Right /*&& !HasLoadingStatusInfo()*/) {
                if(!_codeBox.EnabledEx) return;

                ContextMenuStrip cm = new ContextMenuStrip();
                IPoderosaMenuGroup[] menus = new IPoderosaMenuGroup[] {
                    new Bellagio.Chart.ChartMenuGroups.FutureMenuGroup(new SetStockCommand((OrderForm)this.ParentForm), false) };
                Poderosa.Forms.PublicMenuUtil.BuildContextMenu(cm, menus, null);

                try {
                    cm.Show((Control)sender, e.Location);
                }
                catch(Exception ex) {
                    RuntimeUtil.ReportException(ex);
                }

            }
        }
        private class SetStockCommand : PoderosaCommandImpl {
            private OrderForm _form;
            public SetStockCommand(OrderForm f) {
                _form = f;
            }
            public override CommandResult InternalExecute(ICommandTarget target, params IAdaptable[] args) {
                AbstractStockProfile prof = (AbstractStockProfile)args[0].GetAdapter(typeof(AbstractStockProfile));
                _form.SetCurrentStockExternal(prof);
                return CommandResult.Succeeded;
            }
        }

        //xݒ
        private void AdjustPowerAmountInfo() {
            try {
                string label = "";
                string text = "";
                bool warning = false;
                if(_stockProfile!=null && _stockProfile.IsDerivative) {
                    DerivativeBuyingPowerInfo info = BellagioRoot.OrderDataProvider.DerivativeBuyingPowerInfo.Value;
                    if(info!=null) {
                        if(info.MarginDeficiency > 0) {
                            label = "؋sz";
                            text = String.Format("{0:N0}~", info.MarginDeficiency);
                            warning = true;
                        }
                        else {
                            bool mini = _stockProfile!=null && _stockProfile.IsDerivative && ((DerivativeStockProfile)_stockProfile).Brand==DerivativeStockProfile.BrandT.NikkeiFutureMini;
                            label = "/\";
                            text = String.Format("{0:N0}/{1:N0}", mini? info.maxVolumeMiniLong : info.maxVolumeLargeLong, mini? info.maxVolumeMiniShort : info.maxVolumeLargeShort, mini? "(mini)" : "");
                        }
                    }
                }
                else { //_stockProfilenull̂Ƃ͌/Mp
                    StockBuyingPowerInfo info = BellagioRoot.OrderDataProvider.StockBuyingPowerInfo.Value;
                    if(info!=null) {
                        bool credit = _layout==LayoutT.IncludeCode?
                            (_newOrderCreBuy.Checked || _newOrderCreSell.Checked) : (_dealTypeSeido.Checked || _dealTypeIppan.Checked);

                        if(credit) {
                            label = "Mp]";
                            text  = String.Format("{0:N0}~", info.Credit);
                        }
                        else {
                            label = "t]";
                            text  = String.Format("{0:N0}~", info.Genbutsu);
                        }
                    }
                }

                _powerAmountLabel.Text = label;
                _powerAmountText.Text = text;
                _powerAmountText.ForeColor = warning? Color.Red : Color.FromArgb(0x20, 0x20, 0x40);
                //_maxVolumeButton.Enabled = text.Length > 0; //񂪂ĂƂ͂OK
            }
            catch(Exception ex) {
                RuntimeUtil.ReportException(ex);
            }
        }

        //TradeOrderItem̍쐬Bݒ肪܂΃bZ[W{bNXonullԂ
        public TradeOrderItem CreateTradeOrderItemUI() {
            return CreateTradeOrderItem(true);
        }
        //TradeOrderItem̍쐬BsڂĂł邾̃vpeB𖄂߂ĕԂ
        public TradeOrderItem CreateTradeOrderItemSilent() {
            return CreateTradeOrderItem(false);
        }

        //TradeOrderItem̍쐬Bݒ肪܂΃bZ[W{bNXonullԂ
        private TradeOrderItem CreateTradeOrderItem(bool show_messagebox) {
            Stock stock = GetCurrentStock();
            if(show_messagebox) {
                if(stock==null) {
                    CreateTradeOrderItemUIFail("͂Ă܂");
                    return null;
                }
                if(_codeBox.EnabledEx && stock.Profile.Code != _codeBox.GetCodeText()) { //r[ɃR[h͂ȂĂ狑
                    CreateTradeOrderItemUIFail("͂܂");
                    return null;
                }
                if(_volumeBox.GetTextAsInt()==0) {
                    CreateTradeOrderItemUIFail("ʂ͂Ă܂");
                    return null;
                }
                if(!_nariyukiButton.Checked) {
                    int sashine = _sashineBox.GetTextAsInt();
                    if(sashine<=0) {
                        CreateTradeOrderItemUIFail("LȎwl͂Ă܂");
                        return null;
                    }
                }
            }

            TradeOrderItem item;
            IOrderItemFormatter formatter = BellagioRoot.OrderDataProvider.OrderItemFormatter;

            //stocknull
            if(_parameter.OrderCategory==OrderFormParameter.Category.NewPosition) {
                item = new TradeOrderItem(stock);
                item.OrderStatus = OrderStatus.Ordered;
                item.MarketAsText = stock==null? null : new string[] { formatter.FormatStockExchange(stock.Market) };
                if(_layout==LayoutT.IncludeCode) {
                    item.NewOrClose = OrderNewClose.New;
                    item.LongShort = _newOrderCreSell.Checked? LongShort.Short : LongShort.Long;
                    if(stock!=null && stock.Profile!=null && stock.Profile.IsDerivative) {
                        if(!_newOrderCreBuy.Checked && !_newOrderCreSell.Checked) {
                            if(show_messagebox) CreateTradeOrderItemUIFail("̎w肪܂");
                            return null;
                        }
                        item.DealType = OrderDealType.Derivatives;
                    }
                    else {
                        if(!_newOrderGenbutsu.Checked && !_newOrderCreBuy.Checked && !_newOrderCreSell.Checked) {
                            if(show_messagebox) CreateTradeOrderItemUIFail("̎w肪܂");
                            return null;
                        }
                        item.DealType = _newOrderGenbutsu.Checked? OrderDealType.Genbutsu : (_newOrderCreSell.Checked || _creditTypeBox.SelectedIndex==0)? OrderDealType.CreditSeido : OrderDealType.CreditIppan;
                    }
                }
                else {
                    if(!_buyButton.Checked && !_sellButton.Checked) {
                        if(show_messagebox) CreateTradeOrderItemUIFail("̎w肪܂");
                        return null;
                    }
                    if(!_dealTypeGenbutsu.Checked && !_newPositionButton.Checked && !_closePositionButton.Checked) {
                        if(show_messagebox) CreateTradeOrderItemUIFail("VK/ԍς̎w肪܂");
                        return null;
                    }
                    bool d = stock!=null && stock.Profile.IsDerivative;
                    if(!d && _dealTypeGenbutsu.Checked) {
                        item.DealType = OrderDealType.Genbutsu;
                        item.LongShort = LongShort.Long;
                        item.NewOrClose = _buyButton.Checked? OrderNewClose.New : OrderNewClose.Close;
                    }
                    else {
                        item.DealType = d? OrderDealType.Derivatives : _dealTypeSeido.Checked? OrderDealType.CreditSeido : OrderDealType.CreditIppan;
                        item.LongShort = _buyButton.Checked ^ _closePositionButton.Checked? LongShort.Long : LongShort.Short;
                        item.NewOrClose = _newPositionButton.Checked? OrderNewClose.New : OrderNewClose.Close;
                    }
                }


                item.Kouza = _kouzaBox.SelectedIndex==0? OrderKouza.Tokutei : OrderKouza.Ippan;
                item.LimitDate = _dateBox.SelectedIndex==0? OrderLimitDate.Today : OrderLimitDate.Week;
                item.Volume = _volumeBox.GetTextAsInt();
            }
            else if(_parameter.OrderCategory==OrderFormParameter.Category.ClosePosition) {
                item = new TradeOrderItem(stock);
                item.OrderStatus = OrderStatus.Ordered;
                item.MarketAsText = stock==null? null : new string[] { formatter.FormatStockExchange(stock.Market) };
                item.NewOrClose = OrderNewClose.Close;
                item.LongShort = _parameter.CurrentPosition.LongShort;
                item.DealType = _parameter.CurrentPosition.DealType;
                item.Kouza = _parameter.CurrentPosition.OrderKouza;
                item.LimitDate = _dateBox.SelectedIndex==0? OrderLimitDate.Today : OrderLimitDate.Week;
                item.Volume = _volumeBox.GetTextAsInt();
                item.TargetPosition = _parameter.CurrentPosition;

                if(item.DealType!=OrderDealType.Genbutsu) { //MpE敨
                    if(_parameter.CloseType==OrderFormParameter.ClosePositionType.MultiplePosition) //|WVN[Y
                        item.ClosePositionDetail = CreatePositionAndVolumeList();
                    else {
                        //P|WV
                        Debug.Assert(_parameter.PositionElement!=null);
                        item.TargetPositionElement = _parameter.PositionElement;
                    }
                }
                else
                    item.TargetPositionElement = _parameter.PositionElement;


            }
            else { //Change 
                item = _parameter.CurrentOrder.Clone();
                item.OrderStatus = OrderStatus.Changed;
            }

            item.Condition = SikkoBoxIndexToOrderCondition(_sikkoBox.SelectedIndex, _nariyukiButton.Checked);
            if(OrderingUtil.IsSashineRequired(item.Condition)) {
                if(!_sashineBox.Enabled) {
                    if(show_messagebox ) CreateTradeOrderItemUIFail("wl̓͂Kvł");
                    return null;
                }
                else {
                    int sashine = _sashineBox.GetTextAsInt();
                    if(stock!=null && stock.Profile.IsDerivative) sashine *= 100; //敨wlC
                    item.Sashine = sashine;
                }
            }

            DateTime now = DateTime.Now;
            item.OrderDate = new BDate(BDate.DateTimeToInt(now));
            item.OrderTime = new BTime(now.Hour, now.Minute, 0);
            item.TransactionStatus = OrderTransactionStatus.Stable;

            return item;
        }
        private void CreateTradeOrderItemUIFail(string message) {
            BUtil.ShowWarningMessageBox(message);
            /*
            _orderButton.ClearMouseEnterState();
            _reserveButton.ClearMouseEnterState();
            */
        }

        //MBtrueԂ
        public bool SendOrderUI() {
            try {
                TradeOrderItem item = CreateTradeOrderItemUI();
                if(item==null) return false;

                if(!_omitConfirmDialogBox.Checked) {
                    OrderConfirmDialog dlg = new OrderConfirmDialog("mF", item, false, _parameter.OrderCategory==OrderFormParameter.Category.Change? "ύX" : "");
                    DialogResult r = dlg.ShowDialog(this.ParentForm);
                    dlg.Dispose();
                    if(r!=DialogResult.OK) return false;
                }
                BellagioRoot.FixedPreferences.Ordering.ShowOrderConfirmDialog = !_omitConfirmDialogBox.Checked;
                BellagioRoot.FixedPreferences.AutoPinCode = _savePinCodeBox.Checked;

                //ۗɑ΂Ċm肵̒j
                if(_parameter.CurrentOrder!=null && _parameter.CurrentOrder.OrderStatus==OrderStatus.Preparing) {
                    BellagioRoot.OrderDataProvider.RemoveReservedOrder(_parameter.CurrentOrder);
                }

                if(_parameter.OrderCategory==OrderFormParameter.Category.Change)
                    BellagioRoot.OrderDataProvider.SendChangeOrder(item, _pinCodeBox.Text);
                else if(_parameter.OrderCategory==OrderFormParameter.Category.ClosePosition && item.DealType!=OrderDealType.Genbutsu)
                    BellagioRoot.OrderDataProvider.SendSpecifiedElementCloseOrder(item, _pinCodeBox.Text);
                else //VK܂̓|WVwȂ̕ԍ
                    BellagioRoot.OrderDataProvider.SendNewOrCloseOrder(item, _pinCodeBox.Text);

                return true;
            }
            catch(IllegalOrderException ex) {
                BUtil.ShowWarningMessageBox(ex.Message);
                return false;
            }
            catch(BellagioException ex) {
                RuntimeUtil.ReportException(ex);
                return false;
            }
            catch(Exception ex) {
                RuntimeUtil.ReportException(ex);
                return false;
            }
        }
        public bool ReserveOrderUI() {
            TradeOrderItem item = CreateTradeOrderItemUI();
            if(item!=null) {
                BellagioRoot.FixedPreferences.Ordering.ShowOrderConfirmDialog = !_omitConfirmDialogBox.Checked;

                item.OrderStatus = OrderStatus.Preparing;
                item.TransactionStatus = OrderTransactionStatus.Stable;
                BellagioRoot.OrderDataProvider.AddReservedOrder(item);
                if(Control.ModifierKeys!=Keys.Control) //CtrlȂ炾ƉBȂBpĕۗ
                    return true;
            }

            return false;
        }

        private static int GetInitialSashinePrice(Stock stock) {
            DaytimeTrade dt = BellagioRoot.DaytimeTradeProvider.Lookup(stock);
            return dt==null? 1 : dt.CurrentPriceInfo.LastClose.Value;
        }
        private static int GetZeroDigitsCountFromVolumeUnit(int unit) {
            Debug.Assert(unit > 0);
            int zero = 0;
            while((unit % 10)==0) {
                zero++;
                unit /= 10;
            }
            return zero;
        }
        private static Bitmap LargeBitmap(int index) {
            return OrderingPlugin.OrderingIcons.GetBitmap(index);
        }

        public void InitToolTipText(ToolTip tt) {
            if(_layout!=LayoutT.OmitCode)
                tt.SetToolTip(_codeBox, "R[h̓ - V[gJbg F2");
            tt.SetToolTip(_currentPriceButton, "ݒl(Ԓ)܂͊l(ԊO)wlɓ - V[gJbg F5");
            tt.SetToolTip(_nariyukiButton, "V[gJbg F4");
            //tt.SetToolTip(_maxVolumeButton, "݂̎wl̒lƗ]͏񂩂vZő\ʂ - V[gJbg F10");
            if(_layout==LayoutT.IncludeCode) {
                tt.SetToolTip(_newOrderGenbutsu, " - V[gJbg Q");
                tt.SetToolTip(_newOrderCreBuy, "Mp@xEMp̗\ȏꍇ͉EŎw肵܂ - V[gJbg L");
                tt.SetToolTip(_newOrderCreSell, "Mp - V[gJbg S");
            }
        }


    }

    public class HoveringLabel : Label {
        private Image _normal;
        private Image _hovering;
        public HoveringLabel(Image normal, Image hovering) {
            this.BorderStyle = BorderStyle.None;
            this.Size = normal.Size;
            this.Image = normal;
            _normal = normal;
            _hovering = hovering;
        }
        protected override void OnMouseEnter(EventArgs e) {
            base.OnMouseEnter(e);
            this.Image = _hovering;
            this.Cursor = Cursors.Hand;
        }
        protected override void OnMouseLeave(EventArgs e) {
            base.OnMouseLeave(e);
            this.Image = _normal;
            this.Cursor = Cursors.Default;
        }


    }
}
