/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Ordering/PositionListControl.cs#10 $
 * $DateTime: 2008/02/22 14:12:23 $
 * 
 * |WVꗗ
 */
using System;
using System.Collections.Generic;
using System.Text;
using System.Drawing;
using System.Diagnostics;
using System.Windows.Forms;

using Bellagio.Environment;
using Bellagio.Values;
using Bellagio.Forms;
using Bellagio.Drawing;
using Bellagio.Common;

using Travis;

namespace Bellagio.Ordering {
    public class PositionListDrawingSettings : DrawingSettingsBase {
        public DSFont largeLabelFont;  //傫̃tHg
        public DSFont labelFont;       //ʏtHg
        public DSFont numberFont;      //ltHg

        public DSPenStyle frameColor;  //g̐F
        public DSPenStyle delimiterColor; //tB[h؂̐F
        public DSBrush labelColor;     //W̃xF
        public DSBrush numberColor;    //l\F
        public DSBrush plusColor;      //]vvX̂Ƃ̐F
        public DSBrush minusColor;     //]v}CiX̂Ƃ̐F
        public DSBrush genbutsuColor;  //""̐F
        public DSBrush creditBuyColor; //"Mp"̐F
        public DSBrush creditSellColor; //"Mp"̐F

        public DSInt itemHeight;        //Ps̍
        public DSInt frameMargin;       //gƃeLXg̊Ԃ̗]
        public DSInt numberFontYOffset; //lɈقȂtHggƂ̌ḧʒu킹

        public PositionListDrawingSettings(string id)
            : base(id) {
        }

        protected override void CreateElements() {
            itemHeight = DefinePositiveInt("itemHeight", 40);
            frameMargin = DefinePositiveInt("frameMargin", 4);

            largeLabelFont = DefineFont("largeLabelFont", DSFont.GenericFontName, 10);
            labelFont = DefineFont("labelFont", DSFont.GenericFontName, 9F);
            numberFont = DefineFont("numberFont", DSFont.GenericFontName, 11F);
            numberFontYOffset = DefineInt("numberFontYOffset", -1);

            labelColor = DefineBrush("labelColor", Color.White);
            frameColor = DefinePenStyle("frameColor", Color.DarkOliveGreen, BPenStyle.DashStyle.Dot, 1);
            delimiterColor = DefinePenStyle("delimiterColor", Color.DarkOliveGreen, BPenStyle.DashStyle.Dot, 1);
            labelColor = DefineBrush("labelColor", Color.White);
            numberColor = DefineBrush("numberColor", Color.LightCyan);
            plusColor = DefineBrush("plusColor", Color.White);
            minusColor = DefineBrush("minusColor", Color.Red);
            genbutsuColor = DefineBrush("genbutsuColor", Color.LimeGreen);
            creditBuyColor = DefineBrush("creditBuyColor", Color.OrangeRed);
            creditSellColor = DefineBrush("creditSellColor", Color.LightBlue);
        }
    }

    //ꗗ̃Rg[@{̂ƃXN[o[S
    public class PositionListControl : BellagioListControl {
        private PositionListForm _parentForm;
        private bool _testMode; //`̃eXgƂ̃[h

        private ToolTip _toolTip;
        private TradePositionList _items;
        private PositionListDrawingSettings _settings;
        private IOrderItemFormatter _formatter;

        private ItemPosition _posIndex;
        private ItemPosition _posType;
        private ItemPosition _posStock;
        private ItemPosition _posMarket;
        private ItemPosition _posKouza;
        private ItemPosition _posVolume;
        private ItemPosition _posPrice;
        private ItemPosition _posTatebi; //iMp̂݁j
        private ItemPosition _posKeihi;
        private ItemPosition _posProfitAmount;
        private ItemPosition _posOrder;

        private IconSetInfo _iconSetInfoForGenbutsu;
        private IconSetInfo _iconSetInfoForShinnyo; //Mpp

        //}EX̓ɑΉ铮̂߂̈ʒu ȂƂ-1
        private int _hoveringItemIndex;
        private int _hoveringIconIndex;

        public PositionListControl() {
            Init(null);
        }
        internal PositionListControl(PositionListForm f) {
            Init(f);
        }
        private void Init(PositionListForm f) {
            _parentForm = f;
            _toolTip = new ToolTip(); 
            this.BackColor = Color.Black;
            _iconSetInfoForGenbutsu = CreateIconSetForGenbutsu();
            _iconSetInfoForShinnyo = CreateIconSetForShinyo();
            _hoveringItemIndex = -1;
            _hoveringItemIndex = -1;

            ReloadPreference();

            CreateItemPositions();
        }
        public bool TestMode {
            get {
                return _testMode;
            }
            set {
                _testMode = value;
            }
        }
        public PositionListDrawingSettings Settings {
            get {
                return _settings;
            }
            set {
                _settings = value;
            }
        }
        public IOrderItemFormatter ItemFormatter {
            get {
                return _formatter;
            }
            set {
                _formatter = value;
            }
        }
        internal void SetContent(TradePositionList value) {
            _items = value;
        }
        //\̃eXgpɃ_CNgɒl
        public void SetContentForTest(TradePositionList value) {
            _items = value;
        }

        public override void ReloadPreference() {
            OrderingPreferences p = BellagioRoot.FixedPreferences.Ordering;
            bool tr = p.HalfTransparentView;
            _parentForm.Opacity = p.HalfTransparentView? 0.8 : 1.0;
        }


        protected override void OnResize(EventArgs e) {
            base.OnResize(e);
            AdjustPositions(this.ContentWidth);
        }
        protected override void ResetInternalState() {
            _hoveringItemIndex = -1;
            _hoveringIconIndex = -1;
        }
        protected override BellagioDocumentStatus GetDocumentStatus() {
            return _testMode? BellagioDocumentStatus.Complete : _parentForm.Document.DocumentStatus;
        }

        protected override int ItemCount {
            get {
                return _items==null? 0 : _items.Count + 1;
            }
        }

        protected override int ItemHeight {
            get {
                return _settings.itemHeight.V;
            }
        }

        protected override void DrawItem(int itemIndex, Graphics g, int y) {
            try {
                bool explanatory = itemIndex==0; //}
                TradePositionItem item = explanatory? null : _items[itemIndex-1];
                int top = y + _settings.frameMargin.V;
                int bottom = y + _settings.itemHeight.V - _settings.frameMargin.V;
                int middle = (top + bottom) / 2; //s̒SBQƂĕ`悷邱Ƃ͂悭
                int twoline_y1 = (middle + top) / 2;
                int twoline_y2 = (middle + bottom) / 2; //Qs\̂Ƃ̊eC̒SYW
                int delim_top = top + 3;
                int delim_bottom = bottom - 3;
                int margin = 3;
                int x; //x,y̓[JϐƂđpByɂĂ͈j󂵂Ă̂Œ

                //g
                Pen delimiter_pen = _settings.delimiterColor.P;
                Pen frame_pen = _settings.frameColor.P;
                RoundRectUtil.Draw(g, frame_pen, new Rectangle(2, y+2, base.ContentWidth-4, _settings.itemHeight.V-4), 4);

                //ԍ
                if(_posIndex.width > 0) {
                    if(explanatory)
                        DrawStringUtil.MiddleCenter(g, "", _settings.labelFont.F, _settings.labelColor.B, _posIndex.center, middle);
                    else
                        DrawStringUtil.MiddleCenter(g, FormatShortcutKey(itemIndex-1), _settings.labelFont.F, _settings.labelColor.B, _posIndex.center, middle);
                }

                //tort
                if(_posType.width > 0) {
                    DrawDelimiter(g, delimiter_pen, _posType.x, delim_top, delim_bottom);
                    if(explanatory)
                        DrawStringUtil.MiddleCenter(g, "", _settings.largeLabelFont.F, _settings.labelColor.B, _posType.center, middle);
                    else {
                        Brush br;
                        if(item.DealType==OrderDealType.Genbutsu) br = _settings.genbutsuColor.B;
                        else if(item.LongShort==LongShort.Long) br = _settings.creditBuyColor.B;
                        else br = _settings.creditSellColor.B;
                        DrawStringUtil.MiddleCenter(g, _formatter.FormatPosition(item.DealType, item.LongShort), _settings.largeLabelFont.F, br, _posType.center, middle);
                    }
                }

                //R[hƖO
                if(_posStock.width > 0) {
                    DrawDelimiter(g, delimiter_pen, _posStock.x, delim_top, delim_bottom);
                    if(explanatory)
                        DrawStringUtil.MiddleLeftWithClip(g, "", _settings.labelFont.F, _settings.labelColor.B, _posStock.x, middle, _posStock.width);
                    else {
                        DrawStringUtil.MiddleLeftWithClip(g, item.Stock.Profile.Code, _settings.labelFont.F, _settings.labelColor.B, _posStock.x, twoline_y1, _posStock.width);
                        string name = item.Stock.Profile.Name;
                        Font f = name.Length>5? _settings.labelFont.F : _settings.largeLabelFont.F;
                        DrawStringUtil.MiddleLeftWithClip(g, name, f, _settings.labelColor.B, _posStock.x, twoline_y2, _posStock.width);
                    }
                }

                //sAMp̎
                if(_posMarket.width > 0) {
                    DrawDelimiter(g, delimiter_pen, _posMarket.x, delim_top, delim_bottom);
                    if(explanatory) {
                        DrawStringUtil.MiddleCenter(g, "s", _settings.labelFont.F, _settings.labelColor.B, _posMarket.center, twoline_y1);
                        DrawStringUtil.MiddleCenter(g, "", _settings.labelFont.F, _settings.labelColor.B, _posMarket.center, twoline_y2);
                    }
                    else {
                        OrderDealType dt = item.DealType;
                        if(OrderingUtil.IsShinnyo(dt)) {
                            DrawStringUtil.MiddleCenter(g, _formatter.FormatStockExchange(item.Stock.Market), _settings.labelFont.F, _settings.labelColor.B, _posMarket.center, twoline_y1);
                            DrawStringUtil.MiddleCenter(g, _formatter.FormatShinnyoKigen(dt), _settings.labelFont.F, _settings.labelColor.B, _posMarket.center, twoline_y2);
                        }
                        else if(dt==OrderDealType.Derivatives) {
                            DrawStringUtil.MiddleCenter(g, _formatter.FormatStockExchange(item.Stock.Market), _settings.labelFont.F, _settings.labelColor.B, _posMarket.center, twoline_y1);
                            DrawStringUtil.MiddleCenter(g, "--", _settings.labelFont.F, _settings.labelColor.B, _posMarket.center, twoline_y2);
                        }
                    }
                }

                //
                if(_posKouza.width > 0) {
                    DrawDelimiter(g, delimiter_pen, _posKouza.x, delim_top, delim_bottom);
                    if(explanatory) {
                        DrawStringUtil.MiddleCenter(g, "", _settings.labelFont.F, _settings.labelColor.B, _posKouza.center, middle);
                    }
                    else {
                        string kouza = item.Stock.Profile.IsDerivative? "--" : _formatter.FormatOrderKouza(item.OrderKouza);
                        DrawStringUtil.MiddleCenter(g, kouza, _settings.largeLabelFont.F, _settings.labelColor.B, _posKouza.center, middle);
                    }
                }

                //(MpƐ敨ŕ\)
                if(_posTatebi.width > 0) {
                    DrawDelimiter(g, delimiter_pen, _posTatebi.x, delim_top, delim_bottom);
                    if(explanatory)
                        DrawStringUtil.MiddleLeft(g, "", _settings.labelFont.F, _settings.labelColor.B, _posTatebi.x+margin, middle);
                    else if(OrderingUtil.IsShinnyo(item.DealType) || OrderingUtil.IsFutureOrOption(item.Stock.Profile.Flags)) {
                        string text = _parentForm.DisplayStyle==PositionListDisplayStyle.CombineSameStock? "--" : BDate.FormatYYMMDD(item.LastTradeItem.Date);
                        DrawStringUtil.MiddleLeft(g, text, _settings.labelFont.F, _settings.labelColor.B, _posTatebi.x+margin, middle);
                    }

                }


                //ʁ@iۗLʁAi
                if(_posVolume.width > 0) {
                    DrawDelimiter(g, delimiter_pen, _posVolume.x, delim_top, delim_bottom);
                    x = _posVolume.right - margin;
                    if(explanatory) {
                        DrawStringUtil.MiddleRight(g, "", _settings.labelFont.F, _settings.labelColor.B, x, twoline_y1);
                        DrawStringUtil.MiddleRight(g, "()", _settings.labelFont.F, _settings.labelColor.B, x, twoline_y2);
                    }
                    else {
                        y = item.TotalOrderingVolume == 0? middle : twoline_y1;
                        DrawStringUtil.MiddleRight(g, item.Stock.Profile.VolumeUnitString, _settings.labelFont.F, _settings.labelColor.B, ref x, y);
                        DrawStringUtil.MiddleRight(g, item.TotalVolume.ToString("N0"), _settings.numberFont.F, _settings.numberColor.B, ref x, y + _settings.numberFontYOffset.V);

                        if(item.TotalOrderingVolume > 0) {
                            x = _posVolume.right - margin;
                            y = twoline_y2;
                            DrawStringUtil.MiddleRight(g, item.Stock.Profile.VolumeUnitString+")", _settings.labelFont.F, _settings.labelColor.B, ref x, y);
                            DrawStringUtil.MiddleRight(g, item.TotalOrderingVolume.ToString("N0"), _settings.numberFont.F, _settings.numberColor.B, ref x, y + _settings.numberFontYOffset.V);
                            DrawStringUtil.MiddleRight(g, "(", _settings.labelFont.F, _settings.labelColor.B, ref x, y);
                        }
                    }
                }

                //P@i擾Ai
                if(_posPrice.width > 0) {
                    DrawDelimiter(g, delimiter_pen, _posPrice.x, delim_top, delim_bottom);
                    x = _posPrice.right - margin;
                    if(explanatory)
                        DrawStringUtil.MiddleRight(g, "ϒP", _settings.labelFont.F, _settings.labelColor.B, x, twoline_y1);
                    else {
                        DrawStringUtil.MiddleRight(g, "~", _settings.labelFont.F, _settings.labelColor.B, ref x, twoline_y1);
                        DrawStringUtil.MiddleRight(g, item.AveragePriceAsString("N2"), _settings.numberFont.F, _settings.numberColor.B, ref x, twoline_y1+ _settings.numberFontYOffset.V);
                    }

                    x = _posPrice.right - margin;
                    if(explanatory)
                        DrawStringUtil.MiddleRight(g, "ݒl", _settings.labelFont.F, _settings.labelColor.B, x, twoline_y2);
                    else {
                        DrawStringUtil.MiddleRight(g, "~", _settings.labelFont.F, _settings.labelColor.B, ref x, twoline_y2);
                        DrawStringUtil.MiddleRight(g, FormatPriceHI(item.CurrentPrice100), _settings.numberFont.F, _settings.numberColor.B, ref x, twoline_y2+ _settings.numberFontYOffset.V);
                    }
                }

                //oƗ(Mpŕ\)
                if(_posKeihi.width > 0) {
                    DrawDelimiter(g, delimiter_pen, _posKeihi.x, delim_top, delim_bottom);
                    x = _posKeihi.right - margin;
                    if(explanatory)
                        DrawStringUtil.MiddleRight(g, "xo", _settings.labelFont.F, _settings.labelColor.B, x, middle);
                    else if(OrderingUtil.IsShinnyo(item.DealType)) {
                        DrawStringUtil.MiddleRight(g, "~", _settings.labelFont.F, _settings.labelColor.B, ref x, middle);
                        DrawStringUtil.MiddleRight(g, (item.TotalKeihi - item.TotalRisoku).ToString("N0"), _settings.numberFont.F, _settings.numberColor.B, ref x, middle + _settings.numberFontYOffset.V);
                    }
                    else if(item.DealType==OrderDealType.Derivatives)
                        DrawStringUtil.MiddleRight(g, "--", _settings.labelFont.F, _settings.labelColor.B, x, middle);
                }


                //v(z)
                if(_posProfitAmount.width > 0) {
                    DrawDelimiter(g, delimiter_pen, _posProfitAmount.x, delim_top, delim_bottom);
                    x = _posProfitAmount.right - margin;
                    if(explanatory)
                        DrawStringUtil.MiddleRight(g, "]v", _settings.labelFont.F, _settings.labelColor.B, x, middle);
                    else {
                        int profit = (int)item.TotalProfit;
                        DrawStringUtil.MiddleRight(g, "~", _settings.labelFont.F, _settings.labelColor.B, ref x, middle);
                        DrawStringUtil.MiddleRight(g, String.Format("{0}{1:N0}", profit>0? "+" : "", profit), _settings.numberFont.F, profit<0? _settings.minusColor.B : _settings.plusColor.B, ref x, middle + _settings.numberFontYOffset.V);
                    }
                }

                //ԍϒ |WV𑝂₷{^Ȃ񂩂Ƃ
                if(_posOrder.width > 0) {
                    DrawDelimiter(g, delimiter_pen, _posOrder.x, delim_top, delim_bottom);
                    if(explanatory)
                        DrawStringUtil.MiddleCenter(g, "", _settings.labelFont.F, _settings.labelColor.B, _posOrder.center, middle);
                    else {
                        int cy = (top + bottom)/2;
                        IconSetInfo actions = GetIconSetInfoFor(item);
                        if(actions!=null) actions.Draw(g, _posOrder.center, cy);
                    }
                }

            }
            catch(Exception ex) {
                Debug.WriteLine(ex.Message);
                Debug.WriteLine(ex.StackTrace);
            }
        }

        protected override void OnMouseMove(MouseEventArgs e) {
            base.OnMouseMove(e);
            ItemAndPoint pt = base.GetPointInItem(e.X, e.Y);
            if(pt.itemIndex>0 && GetIconSetInfoFor(_items[pt.itemIndex-1])==null) pt.itemIndex = -1;
            int new_hovering_index = pt.itemIndex;
            TradePositionItem item = new_hovering_index <= 0? null : _items[new_hovering_index-1];
            int new_icon_index = -1;
            if(new_hovering_index > 0) {
                IconSetInfo actions = GetIconSetInfoFor(item);
                if(actions!=null)
                    new_icon_index = actions.FindHoveringIndex(pt.x - _posOrder.center, pt.y - this.ItemHeight/2);
            }

            //ԕωƂ̋

            if(_hoveringItemIndex!=new_hovering_index || _hoveringIconIndex!=new_icon_index) {
                //1. ToolTip
                if(new_icon_index < 0) //͈͊O܂͖}
                    _toolTip.SetToolTip(this, null);
                else
                    _toolTip.SetToolTip(this, GetIconSetInfoFor(item).GetAt(new_icon_index).toolTipText);

                _hoveringItemIndex = new_hovering_index;
                _hoveringIconIndex = new_icon_index;

                //2. }EXJ[\
                this.Cursor = _hoveringIconIndex!=-1? Cursors.Hand : Cursors.Default;
                //this.Invalidate();
            }
        }
        protected override void OnMouseUp(MouseEventArgs e) {
            base.OnMouseUp(e);
            if(e.Button==MouseButtons.Left) {

                ItemAndPoint pt = base.GetPointInItem(e.X, e.Y);
                if(pt.itemIndex > 0 && GetIconSetInfoFor(_items[pt.itemIndex-1])!=null) {
                    TradePositionItem item = _items[pt.itemIndex-1];
                    IconSetInfo actions = GetIconSetInfoFor(item);
                    if(actions!=null) {
                        int action_index = actions.FindHoveringIndex(pt.x - _posOrder.center, pt.y - this.ItemHeight/2);
                        if(action_index >= 0) {
                            ShowClosePositionForm(item);
                        }
                    }
                }
            }
            else if(e.Button==MouseButtons.Right)
                ShowVisibleConfigContextMenu();
        }
        protected override void OnVisibleConfigChanged() {
            BellagioRoot.FixedPreferences.Ordering.PositionListHiddenColumns = FormatHiddenColumns();
            AdjustPositions(this.ContentWidth);
            _parentForm.AdjustWidthInfo();
            Invalidate();
        }

        public override void DoActionByNumericIndex(int index) {
            if(index>=0 && index<_items.Count) {
                TradePositionItem item = _items[index];
                if(item.LeftVolume > 0) ShowClosePositionForm(item);
            }
        }
        private void ShowClosePositionForm(TradePositionItem item) {
            TradePositionItem.Element target_elem;
            //OrderFormParameter.ClosePositionType closetype;

            //łȂP[X
            if(item.Stock.Profile.IsTransient) {
                BUtil.ShowWarningMessageBox("I͉̒TCgpB");
                return;
            }
            if(item.Stock.IsObsolete) {
                BUtil.ShowWarningMessageBox("I͏ꂳĂ܂");
                return;
            }

            //̌x͕ċʂ̂ꍇ̂
            if(_parentForm.DisplayStyle==PositionListDisplayStyle.CombineSameStock && BellagioRoot.FixedPreferences.Ordering.ShowMultipleCreditCloseWarning &&
                item.DealType!=OrderDealType.Genbutsu) {
                /*
                WarningWithDisableOption dlg = new WarningWithDisableOption("", "Qllł镡ʂ̈ꊇ\璍o܂", "x\");
                dlg.CheckBoxChecked = BellagioRoot.FixedPreferences.Ordering.ShowMultipleCreditCloseWarning;
                bool ok = dlg.ShowDialog()==DialogResult.OK;
                BellagioRoot.FixedPreferences.Ordering.ShowMultipleCreditCloseWarning= dlg.CheckBoxChecked;
                dlg.Dispose();
                if(!ok) return;
                */
                BUtil.ShowWarningMessageBox("Qllł錚ʂ̈ꊇ\璍o܂");
            }

            //P
            if(item.ElementCount==1) {
                if(_parentForm.DisplayStyle==PositionListDisplayStyle.CombineSameStock && item.DealType!=OrderDealType.Genbutsu)
                    target_elem = null; //ꊇ\Ȃ猚ʑI
                else
                    target_elem = item.LastTradeItem;
            }
            else { //
                Debug.Assert(item.DealType!=OrderDealType.Genbutsu);
                target_elem = null;
            }
            OrderingPlugin.Instance.Commands.OpenOrderFormCommand(CastCommandTarget(), OrderFormParameter.ForClosePosition(item, target_elem==null? OrderFormParameter.ClosePositionType.MultiplePosition : OrderFormParameter.ClosePositionType.SpecifiedElement, target_elem));
        }
        private void GenhikiGenwatashi(TradePositionItem item) {
            if(item.ElementCount > 1) {
                BUtil.ShowWarningMessageBox("ŕʂ̂Mp̌En͌ċʂ̎w肪KvłB");
            }
            else {
                GenhikiGenwatasiForm f = new GenhikiGenwatasiForm();
                Debug.Assert(item.ElementCount==1);
                try {
                    f.InitContent(OrderFormParameter.ForClosePosition(item, OrderFormParameter.ClosePositionType.SpecifiedElement, item.LastTradeItem));
                    f.ShowDialog(_parentForm);
                }
                finally {
                    f.Dispose();
                }
            }
        }

        private void CreateItemPositions() {
            _posIndex = new ItemPosition("ԍ", 24, true, true);
            _posType = new ItemPosition("", 60, true, true);
            _posStock = new ItemPosition("", 80, true, true);
            _posOrder = new ItemPosition("", 48, true, true);

            _posVolume = new ItemPosition("", 108, true, false);
            _posProfitAmount = new ItemPosition("]v", 112, true, false);
            _posPrice = new ItemPosition("ϒP/ݒl", 124, true, false);
            _posTatebi = new ItemPosition("", 68, true, false);
            _posKouza = new ItemPosition("", 52, true, false);
            _posMarket = new ItemPosition("s/", 60, true, false);
            _posKeihi = new ItemPosition("xo", 104, true, false);

            _itemPositions = new ItemPosition[] {
            _posIndex, _posType, _posStock, _posMarket, _posKouza, _posTatebi, _posVolume, _posPrice, _posKeihi, _posProfitAmount, _posOrder
            };
            AdjustItemPositionVisibility(BellagioRoot.FixedPreferences.Ordering.PositionListHiddenColumns);
        }

        private void AdjustPositions(int width) {
            //Ăԏ\DxAʂɕKv̏ȂƁuTCYLقǕ\ڂvƂȂȂB
            ItemPositionAlloc alloc = new ItemPositionAlloc();
            alloc.remain = width;
            SetFixedPositionWidth(_posIndex, ref alloc);
            SetFixedPositionWidth(_posType, ref alloc);
            SetFixedPositionWidth(_posStock, ref alloc);
            SetFixedPositionWidth(_posOrder, ref alloc);

            SetFixedPositionWidth(_posVolume, ref alloc);
            SetFixedPositionWidth(_posProfitAmount, ref alloc);
            SetFixedPositionWidth(_posPrice,  ref alloc);
            SetFixedPositionWidth(_posTatebi, ref alloc);
            SetFixedPositionWidth(_posKouza, ref alloc);
            SetFixedPositionWidth(_posMarket, ref alloc);
            SetFixedPositionWidth(_posKeihi, ref alloc);
            if(alloc.remain > 0) AdjustRemainingWidth2(_posStock, _posProfitAmount, alloc.remain);

            //X𖄂߂
            _itemPositions[0].x = 0;
            for(int i=1; i<_itemPositions.Length; i++)
                _itemPositions[i].x = _itemPositions[i-1].right;
            
            _omittedItemExists = alloc.omitted_flag;
        }

        private static IconSetInfo CreateIconSetForGenbutsu() {
            IconList il = OrderingPlugin.OrderingIcons;
            IconSetInfo r = new IconSetInfo(il, new IconPosition[] { new IconPosition(13, -il.IconSize.Width/2, "p") });
            return r;
        }
        private static IconSetInfo CreateIconSetForShinyo() {
            IconList il = OrderingPlugin.OrderingIcons;
            IconSetInfo r = new IconSetInfo(il, new IconPosition[] { new IconPosition(12, -il.IconSize.Width/2, "ԍϒ")/*, new IconPosition(3, 0, "/n")*/ });
            return r;
        }

        private IconSetInfo GetIconSetInfoFor(TradePositionItem item) {
            if(item.OrderRestriction==OrderRestriction.None) {
                if(item.DealType==OrderDealType.Genbutsu)
                    return _iconSetInfoForGenbutsu;
                else
                    return _iconSetInfoForShinnyo;
            }
            else
                return null;
        }

        //ۂ̒l100{Ăl
        private static string FormatPriceHI(int value) {
            if((value % 100)==0)
                return (value/100).ToString("N0");
            else
                return (((double)value) / 100.0).ToString("N0");
        }

        protected override void Dispose(bool disposing) {
            base.Dispose(disposing);
            if(disposing)
                _toolTip.Dispose();
        }
    }
}
