/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Screening/AutoTradingDialog.cs#3 $
 * $DateTime: 2008/05/14 13:05:12 $
 */
using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Diagnostics;
using System.Text;
using System.Collections.Generic;

using Poderosa.Util;
using Poderosa.Sessions;

using Bellagio.Values;
using Bellagio.Data;
using Bellagio.Forms;
using Bellagio.Chart;
using Bellagio.Environment;

namespace Bellagio.Screening {
    internal class AutoTradingDialog : BellagioDefaultForm, ScreeningExecutorBase.IProgressNotifier {
        private static readonly int[] _signalCountValues = new int[] { 100, 1000, Int32.MaxValue };
        private static AutoTradingExecution _prevExecution; //p[^ۑp

        private AutoTradingSchema[] _schemas;
        private ScreeningParameterUI[] _parameterUIs;
        private int _selectedSchemaIndex;

        private AutoTradingExecution _execution;
        private BasicStockProfile _currentStock;
        private int _currentBrandIndex;

        private System.Windows.Forms.Button _okButton;
        private System.Windows.Forms.Button _cancelButton;
        private System.Windows.Forms.GroupBox _filterGroup;
        private System.Windows.Forms.Label _messageLabel;
        private System.Windows.Forms.Label _filterLabel;
        private System.Windows.Forms.ComboBox _filterBox;
        private System.Windows.Forms.GroupBox _autoTradingItemGroup;
        private System.Windows.Forms.Label _lCondition;
        private System.Windows.Forms.Label _schemaLabel;
        private System.Windows.Forms.ComboBox _schemaBox;
        private System.Windows.Forms.GroupBox _dateGroup;
        private System.Windows.Forms.Label _startDateLabel;
        private System.Windows.Forms.DateTimePicker _startDatePicker;
        private System.Windows.Forms.Label _endDateLabel;
        private System.Windows.Forms.DateTimePicker _endDatePicker;
        private System.Windows.Forms.Label _signalCountLabel;
        private System.Windows.Forms.ComboBox _signalCountBox;
        private System.Windows.Forms.ProgressBar _progressBar;
        /// <summary>
        /// KvȃfUCiϐłB
        /// </summary>
        private System.ComponentModel.Container components = null;

        //private BookmarkFolder _bookmarkFolder;

        public AutoTradingDialog() {
            //
            // Windows tH[ fUCi T|[gɕKvłB
            //
            InitializeComponent();

            //
            // TODO: InitializeComponent ĂяǒɁARXgN^ R[hǉĂB
            //
            InitUI();
        }

        public AutoTradingResult Result {
            get {
                return _execution==null? null : _execution.Result;
            }
        }

        /// <summary>
        /// gpĂ郊\[XɌ㏈s܂B
        /// </summary>
        protected override void Dispose(bool disposing) {
            if(disposing) {
                if(components != null) {
                    components.Dispose();
                }
                foreach(ScreeningParameterUI u in _parameterUIs)
                    if(u!=null) u.DisposeControls();
            }
            base.Dispose(disposing);
        }

        #region Windows tH[ fUCiŐꂽR[h
        /// <summary>
        /// fUCi T|[gɕKvȃ\bhłB̃\bh̓e
        /// R[h GfB^ŕύXȂłB
        /// </summary>
        private void InitializeComponent() {
            this._filterGroup = new System.Windows.Forms.GroupBox();
            this._filterBox = new System.Windows.Forms.ComboBox();
            this._filterLabel = new System.Windows.Forms.Label();
            this._messageLabel = new System.Windows.Forms.Label();
            this._autoTradingItemGroup = new System.Windows.Forms.GroupBox();
            this._lCondition = new System.Windows.Forms.Label();
            this._schemaBox = new System.Windows.Forms.ComboBox();
            this._schemaLabel = new System.Windows.Forms.Label();
            this._dateGroup = new System.Windows.Forms.GroupBox();
            this._startDateLabel = new Label();
            this._startDatePicker = new System.Windows.Forms.DateTimePicker();
            this._endDateLabel = new Label();
            this._endDatePicker = new System.Windows.Forms.DateTimePicker();
            this._signalCountLabel = new Label();
            this._signalCountBox = new ComboBox();
            this._progressBar = new System.Windows.Forms.ProgressBar();
            this._okButton = new System.Windows.Forms.Button();
            this._cancelButton = new System.Windows.Forms.Button();
            this._filterGroup.SuspendLayout();
            this._autoTradingItemGroup.SuspendLayout();
            this._dateGroup.SuspendLayout();
            this.SuspendLayout();
            // 
            // _filterGroup
            // 
            this._filterGroup.Controls.Add(this._filterBox);
            this._filterGroup.Controls.Add(this._filterLabel);
            this._filterGroup.Controls.Add(this._messageLabel);
            this._filterGroup.FlatStyle = System.Windows.Forms.FlatStyle.System;
            this._filterGroup.Location = new System.Drawing.Point(8, 8);
            this._filterGroup.Name = "_filterGroup";
            this._filterGroup.Size = new System.Drawing.Size(464, 76);
            this._filterGroup.TabIndex = 0;
            this._filterGroup.TabStop = false;
            this._filterGroup.Text = "P@Ώېݒ";
            // 
            // _filterBox
            // 
            this._filterBox.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this._filterBox.Location = new System.Drawing.Point(136, 40);
            this._filterBox.Name = "_filterBox";
            this._filterBox.Size = new System.Drawing.Size(280, 20);
            this._filterBox.TabIndex = 3;
            //this._filterBox.SelectedIndexChanged += new System.EventHandler(this.OnFilterBoxChanged);
            // 
            // _filterLabel
            // 
            this._filterLabel.Location = new System.Drawing.Point(24, 40);
            this._filterLabel.Name = "_filterLabel";
            this._filterLabel.Size = new System.Drawing.Size(64, 16);
            this._filterLabel.TabIndex = 2;
            this._filterLabel.Text = "Ώ(&F)";
            this._filterLabel.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // _messageLabel
            // 
            this._messageLabel.Location = new System.Drawing.Point(16, 16);
            this._messageLabel.Name = "_messageLabel";
            this._messageLabel.Size = new System.Drawing.Size(432, 16);
            this._messageLabel.TabIndex = 1;
            this._messageLabel.Text = "܂Ώۂ߂܂Bł̑ΏۖȂقǍɌʂ܂B";
            // 
            // _autoTradingItemGroup
            // 
            this._autoTradingItemGroup.Controls.Add(this._lCondition);
            this._autoTradingItemGroup.Controls.Add(this._schemaBox);
            this._autoTradingItemGroup.FlatStyle = System.Windows.Forms.FlatStyle.System;
            this._autoTradingItemGroup.Location = new System.Drawing.Point(8, 92);
            this._autoTradingItemGroup.Name = "_autoTradingItemGroup";
            this._autoTradingItemGroup.Size = new System.Drawing.Size(464, 96);
            this._autoTradingItemGroup.TabIndex = 4;
            this._autoTradingItemGroup.TabStop = false;
            this._autoTradingItemGroup.Text = "Q@[̑I";
            // 
            // _lCondition
            // 
            this._lCondition.Location = new System.Drawing.Point(16, 16);
            this._lCondition.Name = "_lCondition";
            this._lCondition.Size = new System.Drawing.Size(416, 23);
            this._lCondition.TabIndex = 5;
            this._lCondition.Text = "[͊gLbgɂĒǉ邱Ƃł܂B";
            this._lCondition.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // _autoTradingItemBox
            // 
            this._schemaBox.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this._schemaBox.Location = new System.Drawing.Point(16, 40);
            this._schemaBox.Name = "_autoTradingItemBox";
            this._schemaBox.Size = new System.Drawing.Size(416, 20);
            this._schemaBox.TabIndex = 7;
            // 
            // _dateGroup
            // 
            this._dateGroup.Controls.Add(this._startDateLabel);
            this._dateGroup.Controls.Add(this._startDatePicker);
            this._dateGroup.Controls.Add(this._endDateLabel);
            this._dateGroup.Controls.Add(this._endDatePicker);
            this._dateGroup.Controls.Add(this._signalCountLabel);
            this._dateGroup.Controls.Add(this._signalCountBox);
            this._dateGroup.FlatStyle = System.Windows.Forms.FlatStyle.System;
            this._dateGroup.Location = new System.Drawing.Point(8, 196);
            this._dateGroup.Name = "_dateGroup";
            this._dateGroup.Size = new System.Drawing.Size(464, 100);
            this._dateGroup.TabIndex = 10;
            this._dateGroup.TabStop = false;
            this._dateGroup.Text = "R@ΏۊԂȂ";
            // 
            // _startDateLabelLabel
            // 
            this._startDateLabel.Location = new System.Drawing.Point(8, 16);
            this._startDateLabel.Name = "_startDateLabel";
            this._startDateLabel.TabIndex = 0;
            this._startDateLabel.Text = "Jn";
            this._startDateLabel.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // _startDatePicker
            // 
            this._startDatePicker.Location = new System.Drawing.Point(80, 16);
            this._startDateLabel.Size = new System.Drawing.Size(64, 24);
            this._startDatePicker.MaxDate = new System.DateTime(2010, 12, 31, 0, 0, 0, 0);
            this._startDatePicker.MinDate = new System.DateTime(1990, 1, 1, 0, 0, 0, 0);
            this._startDatePicker.Name = "_datePicker";
            this._startDatePicker.TabIndex = 1;
            this._startDatePicker.ValueChanged += new System.EventHandler(this.OnStartDateChanged);
            // 
            // _endDateLabelLabel
            // 
            this._endDateLabel.Location = new System.Drawing.Point(8, 40);
            this._endDateLabel.Size = new System.Drawing.Size(64, 24);
            this._endDateLabel.Name = "_endDateLabelLabel";
            this._endDateLabel.TabIndex = 2;
            this._endDateLabel.Text = "I";
            this._endDateLabel.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // _endDatePicker
            // 
            this._endDatePicker.Location = new System.Drawing.Point(80, 40);
            this._endDatePicker.MaxDate = new System.DateTime(2010, 12, 31, 0, 0, 0, 0);
            this._endDatePicker.MinDate = new System.DateTime(1990, 1, 1, 0, 0, 0, 0);
            this._endDatePicker.Name = "_datePicker";
            this._endDatePicker.TabIndex = 3;
            this._endDatePicker.ValueChanged += new System.EventHandler(this.OnEndDateChanged);
            // 
            // _signalCountLabel
            // 
            this._signalCountLabel.Location = new System.Drawing.Point(8, 64);
            this._signalCountLabel.Size = new System.Drawing.Size(184, 24);
            this._signalCountLabel.Name = "_signalCountLabelLabel";
            this._signalCountLabel.TabIndex = 4;
            this._signalCountLabel.Text = "ł؂VOi(&S)";
            this._signalCountLabel.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // _signalCountBox
            // 
            this._signalCountBox.Location = new System.Drawing.Point(192, 64);
            this._signalCountBox.Size = new System.Drawing.Size(88, 24);
            this._signalCountBox.Name = "_signalCountBoxBox";
            this._signalCountBox.TabIndex = 5;
            this._signalCountBox.DropDownStyle = ComboBoxStyle.DropDownList;
            // 
            // _progressBar
            // 
            this._progressBar.Location = new System.Drawing.Point(8, 312);
            this._progressBar.Name = "_progressBar";
            this._progressBar.Size = new System.Drawing.Size(464, 23);
            this._progressBar.TabIndex = 14;
            // 
            // _okButton
            // 
            this._okButton.DialogResult = System.Windows.Forms.DialogResult.OK;
            this._okButton.FlatStyle = System.Windows.Forms.FlatStyle.System;
            this._okButton.Location = new System.Drawing.Point(312, 344);
            this._okButton.Name = "_okButton";
            this._okButton.TabIndex = 15;
            this._okButton.Text = "OK";
            this._okButton.Click += new System.EventHandler(this.OnOK);
            // 
            // _cancelButton
            // 
            this._cancelButton.DialogResult = System.Windows.Forms.DialogResult.Cancel;
            this._cancelButton.FlatStyle = System.Windows.Forms.FlatStyle.System;
            this._cancelButton.Location = new System.Drawing.Point(400, 344);
            this._cancelButton.Name = "_cancelButton";
            this._cancelButton.TabIndex = 16;
            this._cancelButton.Text = "LZ";
            this._cancelButton.Click += new System.EventHandler(this.OnCancel);
            // 
            // ScreeningDialog
            // 
            this.AcceptButton = this._okButton;
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 12);
            this.CancelButton = this._cancelButton;
            this.ClientSize = new System.Drawing.Size(482, 376);
            this.Controls.Add(this._dateGroup);
            this.Controls.Add(this._autoTradingItemGroup);
            this.Controls.Add(this._progressBar);
            this.Controls.Add(this._filterGroup);
            this.Controls.Add(this._cancelButton);
            this.Controls.Add(this._okButton);
            this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
            this.MaximizeBox = false;
            this.MinimizeBox = false;
            this.Name = "AutoTradingDialog";
            this.ShowInTaskbar = false;
            this.StartPosition = System.Windows.Forms.FormStartPosition.CenterParent;
            this.Text = "";
            this._filterGroup.ResumeLayout(false);
            this._autoTradingItemGroup.ResumeLayout(false);
            this._dateGroup.ResumeLayout(false);
            this.ResumeLayout(false);

        }
        #endregion

        private void InitUI() {

            if(_prevExecution!=null) {
                _startDatePicker.Value = BDate.ToDateTime(_prevExecution.Query.OriginDate);
                _endDatePicker.Value = BDate.ToDateTime(_prevExecution.Query.LastDate);
            }
            else {
                DateTime ld = ScreeningPlugin.Instance.ScreeningDailyDataProvider.GuessLatestTradeDate;
                _endDatePicker.Value = ld;
                ld = ld.AddYears(-1);
                _startDatePicker.Value = ld;
            }

            int si = -1;
            List<AutoTradingSchema> coll = new List<AutoTradingSchema>();
            BellagioRoot.SchemaRoot.CollectAutoTradingSchema(coll);
            _schemas = new AutoTradingSchema[coll.Count];
            _parameterUIs = new ScreeningParameterUI[coll.Count];
            for(int i=0; i<coll.Count; i++) {
                AutoTradingSchema item = coll[i];
                _schemas[i] = item;
                StringWithParameterParser string_parser = new StringWithParameterParser(item);

                _schemaBox.Items.Add(string_parser.Parse(item.title));
                if(_prevExecution!=null && _prevExecution.Query.SourceSchema==item)
                    si = i;
            }
            _schemaBox.SelectedIndex = (si==-1 && coll.Count==0)? -1 : 0;
            _selectedSchemaIndex = -1;
            _schemaBox.SelectedIndexChanged += new EventHandler(OnSelectedSchemaChanged);
            OnSelectedSchemaChanged(_schemaBox, null);

            _filterBox.Items.AddRange(EnumDescAttribute.For(typeof(ScreeningFilterType)).DescriptionCollection());
            _currentBrandIndex = _filterBox.Items.Count;
            IPoderosaDocument pd = BellagioPlugin.Instance.ActivePoderosaWindow.DocumentTabFeature.ActiveDocument;
            StaticChartSession sc = pd==null? null : pd.OwnerSession as StaticChartSession;
            _currentStock = (sc!=null)? sc.CurrentStock.Profile as BasicStockProfile : null;
            if(_currentStock!=null)
                _filterBox.Items.Add(String.Format("{0} {1}", _currentStock.Code, _currentStock.Name));
            _filterBox.SelectedIndex = 0;

            if(_prevExecution!=null) {
                _filterBox.SelectedIndex = _prevExecution.Query.TargetStockProfile!=null? _currentBrandIndex : (int)_prevExecution.Query.StaticFilter;
            }
            else
                _filterBox.SelectedIndex = 0;

            for(int i=0; i<_signalCountValues.Length; i++) {
                _signalCountBox.Items.Add(_signalCountValues[i]==Int32.MaxValue? "" : _signalCountValues[i].ToString());
                if(_prevExecution!=null && _signalCountValues[i]==_prevExecution.Query.LimitSignalCount)
                    _signalCountBox.SelectedIndex = i;
            }
            if(_signalCountBox.SelectedIndex==-1)
                _signalCountBox.SelectedIndex = 0;
            

        }

        private void OnSelectedSchemaChanged(object sender, EventArgs args) {
            if(_selectedSchemaIndex == _schemaBox.SelectedIndex) return;

            ScreeningParameterUI u;
            _autoTradingItemGroup.SuspendLayout();
            if(_selectedSchemaIndex!=-1) {
                u = _parameterUIs[_selectedSchemaIndex];
                Debug.Assert(u!=null);
                foreach(ScreeningParameterUI.ParamTag tag in u.Tags) {
                    _autoTradingItemGroup.Controls.Remove(tag.label);
                    _autoTradingItemGroup.Controls.Remove(tag.valueControl);
                }
            }

            u = _parameterUIs[_schemaBox.SelectedIndex];
            if(u==null) {
                AutoTradingSchema schema = _schemas[_schemaBox.SelectedIndex];
                u = new ScreeningParameterUI(schema, schema.parameterDescription.ParseOptionalString(""), new EventHandler(OnParameterChanged));
                _parameterUIs[_schemaBox.SelectedIndex] = u;
            }

            int x = _schemaBox.Left;
            foreach(ScreeningParameterUI.ParamTag tag in u.Tags) {
                tag.label.Location = new Point(x, 64);
                _autoTradingItemGroup.Controls.Add(tag.label);
                x += tag.label.Width + 8;
                _autoTradingItemGroup.Controls.Add(tag.valueControl);
                tag.valueControl.Location = new Point(x, 64);
                x += tag.valueControl.Width + 8;
            }

            _autoTradingItemGroup.ResumeLayout();
            _selectedSchemaIndex = _schemaBox.SelectedIndex;
        }
        //IɃeLXg܂ŔfĂ܂
        private void OnParameterChanged(object sender, EventArgs args) {
            ScreeningParameterUI u = _parameterUIs[_selectedSchemaIndex];
            CommitParameter(u);

            AutoTradingSchema item = _schemas[_selectedSchemaIndex];
            StringWithParameterParser string_parser = new StringWithParameterParser(item);
            _schemaBox.Items[_selectedSchemaIndex] = string_parser.Parse(item.title);

        }


        private void OnOK(object sender, EventArgs args) {
            this.DialogResult = DialogResult.None;

            AutoTradingQuery q = CreateQuery();
            if(q==null) return;

            SetUIEnabled(false);
            _execution = new AutoTradingExecution(q);
            _execution.ProgressNotifier = this;
            if(_execution==null) return;


            //_progressBar.Maximum = _execution.BrandEnumerator.Count;
            _progressBar.Value = 0;
            _progressBar.Enabled = true;

            this.Cursor = Cursors.AppStarting;
            _execution.AsyncExecute();
        }
        private void SetUIEnabled(bool value) {
            int ind = _schemaBox.SelectedIndex;
            ScreeningParameterUI u = _parameterUIs[ind];
            _okButton.Enabled = value;
            _filterBox.Enabled = value;
            _schemaBox.Enabled = value;
            _startDatePicker.Enabled = value;
            _endDatePicker.Enabled = value;
            _signalCountBox.Enabled = value;
            u.EnableControls(value);
        }

        private void CommitParameter(ScreeningParameterUI u) {
            foreach(ScreeningParameterUI.ParamTag tag in u.Tags) {
                int v = (int)tag.valueControl.Value;
                BellagioRoot.ExtensionKitPreference.Find(tag.fullID).Value = v.ToString();
            }
        }

        private void OnCancel(object sender, EventArgs args) {
            if(_execution!=null) {
                this.DialogResult = DialogResult.None;
                SetUIEnabled(true);
                _execution.Abort();
            }
        }

        private void OnStartDateChanged(object sender, EventArgs args) {
        }
        private void OnEndDateChanged(object sender, EventArgs args) {
        }

        private AutoTradingQuery CreateQuery() {
            if(_startDatePicker.Value.CompareTo(DateTime.Today)>0) {
                BUtil.ShowWarningMessageBox(this, "JnłB");
                return null;
            }
            if(_startDatePicker.Value.CompareTo(_endDatePicker.Value)>0) {
                BUtil.ShowWarningMessageBox(this, "IJn̐ɐݒ肳Ă܂B");
                return null;
            }

            try {
                int ind = _schemaBox.SelectedIndex;
                //p[^commit
                ScreeningParameterUI u = _parameterUIs[ind];
                CommitParameter(u);

                AutoTradingQuery q = new AutoTradingQuery();
                q.ConstructWithSchema(_schemas[ind]);
                AbstractStockProfile target = _filterBox.SelectedIndex==_currentBrandIndex? _currentStock : null;
                ScreeningFilterType staticFilter = _filterBox.SelectedIndex==_currentBrandIndex? ScreeningFilterType.None : (ScreeningFilterType)_filterBox.SelectedIndex;
                q.SetParameters(BDate.DateTimeToInt(_startDatePicker.Value), BDate.DateTimeToInt(_endDatePicker.Value),
                    _signalCountValues[_signalCountBox.SelectedIndex], staticFilter, target);


                return q;
            }
            catch(Exception ex) {
                BUtil.ShowWarningMessageBox(this, ex.Message);
                return null;
            }

        }

        private void ExitSuccessFully() {
            this.DialogResult = DialogResult.OK;
            this.Cursor = Cursors.Default;
            AutoTradingResult r = _execution.Result;
            _prevExecution = _execution; //sŎgp

            StringBuilder msg = new StringBuilder();
            if(r.HasTooManyResults) {
                BUtil.ShowWarningMessageBox(this, String.Format("VOiɒBߓrőł؂܂B͈͂ĂB"));
            }
            else {
                msg.AppendFormat("؂܂B\nVOio {0} łB\n", r.Count);

                BUtil.ShowInformationMessageBox(msg.ToString());
            }
            Close();
        }


        #region IProgressNotifier o

        private delegate void ProgressDelegate(int count);

        public void InitProgress(int limit) {
            this.Invoke(new ProgressDelegate(UIInitProgress), limit);
        }
        private void UIInitProgress(int limit) {
            _progressBar.Value = 0;
            _progressBar.Maximum = limit;
        }

        public void OnProgress(int count) {
            this.Invoke(new ProgressDelegate(UIOnProgress), count);
        }
        private void UIOnProgress(int count) {
            if(count<_progressBar.Maximum) _progressBar.Value = count;
        }

        public void OnComplete() {
            this.Invoke(new VoidVoidDelegate(ExitSuccessFully));
        }

        public void OnFail(string message) {
            BUtil.ShowWarningMessageBox(message);
            this.Invoke(new VoidVoidDelegate(ResetExec));
        }

        public void OnAbort() {
            this.Invoke(new VoidVoidDelegate(ResetExec));
        }
        private void ResetExec() {
            Debug.Assert(BUtil.IsExecutingInMainThread);
            this.Cursor = Cursors.Default;
            _progressBar.Value = 0;
            _execution = null;
        }

        #endregion

    }
}
