/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/TestData/DotNetTest.cs#3 $
 * $DateTime$
 */
#if UNITTEST
using System;
using System.Collections.Generic;
using System.Text;
using System.IO;

using NUnit.Framework;

//.NET Framework̃NX̋mFƂɎgp
namespace Bellagio.TestData {
    [TestFixture]
    public class DotNetTest {
        [Test]
        public void PathCombine() {
            //Path.Combine̓mF
            Assert.AreEqual("C:\\xxx\\yyy.txt", Path.Combine("C:\\xxx", "yyy.txt"));
            Assert.AreEqual("C:\\xxx\\yyy.txt", Path.Combine("C:\\xxx\\", "yyy.txt"));
            Assert.AreEqual("C:\\zzz\\yyy.txt", Path.GetFullPath(Path.Combine("C:\\xxx\\", "..\\zzz\\yyy.txt"))); // ".."߂ɂGetFullPathKv
            Assert.AreEqual("C:\\xxx\\yyy.txt", Path.Combine("C:\\zzz", "C:\\xxx\\yyy.txt"));
        }
    }
}
#endif
