/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Travis/CSVReader.cs#3 $
 * $DateTime$
 * 
 */
using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using System.Diagnostics;

namespace Travis.IO {
    //stringIuWFNg̍쐬ɗ͗}CSV[_
    public class CSVReader {
        //Xgf[^stringIuWFNgɂ͔̂Ȃ̂ŊȒPstructɁB̍ڂintȂenumɕϊ邾낤
        public struct STR {
            public int start;
            public int end;
        }

        private TextReader _text;
        private int _lineNumber;
        private char[] _line;
        private int _lineLength;

        public CSVReader(TextReader text) {
            Debug.Assert(text!=null);
            _line = new char[0x400]; //1024Ώ\̂͂
            _lineNumber = 0;
            _text = text;
        }
        //s܂œǂށBCR͖BNULLs͖ɂȂ肩˂Ȃ
        public bool ReadLine() {
            int len = 0;
            int r = _text.Read();
            if(r==-1) return false;

            while(r!=-1) {
                char ch = (char)r;
                if(ch=='\n' || ch=='\0')
                    break;
                else if(ch!='\r')
                    _line[len++] = ch;
                r = _text.Read();
            }

            _lineNumber++;
            if(len > 0) {
                _lineLength = len;
                return true;
            }
            else
                return false;
        }

        //value.endǂݎn߂ăJ}܂ł^
        public void ReadItem(ref STR value) {
            int c = value.end;
            if(c >= _lineLength) throw new IOException("Too short line");
            if(_line[c]==',') c++;

            value.start = c;
            char ch = _line[c];
            while(ch!=',' && c!=_lineLength) {
                c++;
                ch = _line[c];
            }
            value.end = c;
        }

        public char GetCharAt(int index) {
            return _line[index];
        }

        public int CurrentLineNumber {
            get {
                return _lineNumber;
            }
        }
        public char[] RawLine {
            get {
                return _line;
            }
        }
        public int CurrentLineLength {
            get {
                return _lineLength;
            }
        }

        //ݍsʃXg[ɏ
        public void WriteCurrentLineTo(TextWriter w) {
            w.WriteLine(_line, 0, _lineLength);
        }
        public string GetCurrentLine() {
            return new string(_line, 0, _lineLength);
        }
        public string GetCurrentSubLine(int index, int length) {
            return new string(_line, index, length);
        }
        public string ParseString(ref STR value) {
            if(value.end == value.start)
                return "";
            else
                return new string(_line, value.start, value.end - value.start);
        }

        public int ParseInt(ref STR value) {
            int result = 0;
            for(int t = value.start; t < value.end; t++) {
                char ch = _line[t];
                if(ch < '0' || ch > '9') throw new FormatException(String.Format("'{0}' is found in an integer description", ch));
                result *= 10;
                result += (int)(ch - '0');
            }
            return result;
        }
        public double ParseDouble(ref STR value) {
            //蔲
            return Double.Parse(ParseString(ref value));
        }

        public int ParseNullableInt(ref STR value, int null_value) {
            if(value.start==value.end)
                return null_value;
            else
                return ParseInt(ref value);
        }

        //0,1boolփp[X
        public bool Parse01ToBool(ref STR value) {
            char v = _line[value.start];
            if(v=='0')
                return false;
            else if(v=='1')
                return true;
            else
                throw new FormatException(String.Format("'{0}' is found in a bool description", v));
        }
        //ȗfalse
        public bool Parse01ToOpBool(ref STR value) {
            if(value.end==value.start)
                return false;
            else
                return Parse01ToBool(ref value);
        }
    }
}
