/*
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id$
 * $DateTime$
 */
using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;

#if UNITTEST
using NUnit.Framework;
#endif

namespace Travis.Collections {
    public static class LinkedListUtil {
        //LinkedListɃ}b`̂菜
        public delegate bool ActionDelegate<T>(T value);
        public static void ActionWithRemove<T>(LinkedList<T> collection, ActionDelegate<T> action) {
            LinkedListNode<T> node = collection.First;
            while(node!=null) {
                T value = node.Value;
                LinkedListNode<T> next = node.Next;
                if(action(value)) collection.Remove(node);
                node = next;
            }
        }
    }

    public static class ArrayUtil {
        public static bool Contains<T>(T[] array, T element) {
            for(int i=0; i<array.Length; i++)
                if(array[i].Equals(element)) return true;
            return false;
        }
        public static T2[] ConvertArray<T1, T2>(T1[] src) where T1:T2 {
            T2[] r = new T2[src.Length];
            for(int i=0; i<r.Length; i++)
                r[i] = src[i];
            return r;
        }
    }


    //RNVȀ𖞂yATBÖӐ`FbNȂǂɎgB
    public static class DupChecker<E, K> {
        public delegate K Mapper(E e);

        //dȂȂnull
        public static Pair<E,E> Check(ICollection<E> coll, Mapper m) {
            Dictionary<K, E> d = new Dictionary<K, E>();
            foreach(E e in coll) {
                E p;
                K k = m(e);
                if(d.TryGetValue(k, out p)) return new Pair<E,E>(p, e);
                d.Add(k, e);
            }
            return null;
        }
    }

    //C++STLɂ悤Pair
    public class Pair<T1, T2> {
        public T1 first;
        public T2 second;
        public Pair(T1 f, T2 s) {
            first = f;
            second = s;
        }
    }

    public static class ComparisonChain<T> {
        public static Comparison<T> Make(params Comparison<T>[] elements) {
            return delegate(T t1, T t2) {
                for(int i=0; i<elements.Length; i++) {
                    int r = elements[i](t1, t2);
                    if(r!=0) return r;
                }
                return 0;
            };
        }
    }

#if UNITTEST
    [TestFixture]
    public class CollectionUtilTests {
        private static string Concat(LinkedList<string> coll) {
            StringBuilder bld = new StringBuilder();
            foreach(string t in coll)
                bld.Append(t);
            return bld.ToString();
        }
        [Test]
        public void ActionWithRemoveTest() {
            LinkedList<string> c = new LinkedList<string>();
            c.AddLast("A");
            c.AddLast("B");
            c.AddLast("C");
            Assert.AreEqual("ABC", Concat(c));

            LinkedListUtil.ActionWithRemove<string>(c, delegate(string v) { return v=="B"; });
            Assert.AreEqual("AC", Concat(c));

            LinkedListUtil.ActionWithRemove<string>(c, delegate(string v) { return true; });
            Assert.AreEqual("", Concat(c));
        }
        [Test]
        public void DupCheck() {
            string[] c = new string[] { "Rommell", "Manstein", "Guderian" };
            Pair<string, string> p = DupChecker<string, int>.Check(c, delegate(string s) { return s.Length; });
            Assert.AreEqual("Manstein", p.first);
            Assert.AreEqual("Guderian", p.second);
            p = DupChecker<string, int>.Check(c, delegate(string s) { return s.GetHashCode(); });
            Assert.IsNull(p);
        }
    }
#endif
}
